/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlOccurrenceMarker
implements OccurrenceMarker {
    private static final char[] CLOSE_TAG_START = new char[]{'<', '/'};
    private static final char[] TAG_SELF_CLOSE = new char[]{'/', '>'};
    private static final Set<String> TAGS_REQUIRING_CLOSING = HtmlOccurrenceMarker.getRequiredClosingTags();

    public static final Set<String> getRequiredClosingTags() {
        String[] tags = new String[]{"html", "head", "title", "style", "script", "noscript", "body", "section", "nav", "article", "aside", "h1", "h2", "h3", "h4", "h5", "h6", "header", "footer", "address", "pre", "dialog", "blockquote", "ol", "ul", "dl", "a", "q", "cite", "em", "strong", "small", "mark", "dfn", "abbr", "time", "progress", "meter", "code", "var", "samp", "kbd", "sub", "sup", "span", "i", "b", "bdo", "ruby", "rt", "rp", "ins", "del", "figure", "iframe", "object", "video", "audio", "canvas", "map", "table", "caption", "form", "fieldset", "label", "button", "select", "datalist", "textarea", "output", "details", "bb", "menu", "legend", "div", "acronym", "applet", "big", "blink", "center", "dir", "font", "frame", "frameset", "isindex", "listing", "marquee", "nobr", "noembed", "noframes", "plaintext", "s", "spacer", "strike", "tt", "u", "xmp"};
        return new HashSet<String>(Arrays.asList(tags));
    }

    @Override
    public void markOccurrences(RSyntaxDocument doc, Token t, RSyntaxTextAreaHighlighter h, SmartHighlightPainter p) {
        String lexemeStr = t.getLexeme();
        char[] lexeme = lexemeStr.toCharArray();
        lexemeStr = lexemeStr.toLowerCase();
        int tokenOffs = t.getOffset();
        Element root = doc.getDefaultRootElement();
        int lineCount = root.getElementCount();
        int curLine = root.getElementIndex(t.getOffset());
        boolean found = false;
        boolean forward = true;
        for (t = doc.getTokenListForLine(curLine); t != null && t.isPaintable(); t = t.getNextToken()) {
            if (t.getType() != 25) continue;
            if (t.isSingleChar('<') && t.getOffset() + 1 == tokenOffs) {
                if (!TAGS_REQUIRING_CLOSING.contains(lexemeStr)) break;
                found = true;
                break;
            }
            if (!t.is(CLOSE_TAG_START) || t.getOffset() + 2 != tokenOffs) continue;
            found = true;
            forward = false;
            break;
        }
        if (!found) {
            return;
        }
        if (forward) {
            t = t.getNextToken().getNextToken();
            while (true) {
                if (t != null && t.isPaintable()) {
                    Token match;
                    if (t.getType() == 25 && t.is(CLOSE_TAG_START) && (match = t.getNextToken()) != null && match.is(lexeme)) {
                        try {
                            int end = match.getOffset() + match.length();
                            h.addMarkedOccurrenceHighlight(match.getOffset(), end, p);
                            end = tokenOffs + match.length();
                            h.addMarkedOccurrenceHighlight(tokenOffs, end, p);
                        }
                        catch (BadLocationException ble) {
                            ble.printStackTrace();
                        }
                        return;
                    }
                    t = t.getNextToken();
                    continue;
                }
                if (++curLine < lineCount) {
                    t = doc.getTokenListForLine(curLine);
                }
                if (curLine >= lineCount) break;
            }
        } else {
            Stack<Token> matches = new Stack<Token>();
            boolean inPossibleMatch = false;
            t = doc.getTokenListForLine(curLine);
            int endBefore = tokenOffs - 2;
            while (true) {
                if (t != null && t.getOffset() < endBefore && t.isPaintable()) {
                    if (t.getType() == 25) {
                        Token next;
                        if (t.isSingleChar('<')) {
                            next = t.getNextToken();
                            if (next != null) {
                                if (next.is(lexeme)) {
                                    matches.push(next);
                                    inPossibleMatch = true;
                                } else {
                                    inPossibleMatch = false;
                                }
                                t = next;
                            }
                        } else if (t.isSingleChar('>')) {
                            inPossibleMatch = false;
                        } else if (inPossibleMatch && t.is(TAG_SELF_CLOSE)) {
                            matches.pop();
                        } else if (t.is(CLOSE_TAG_START) && (next = t.getNextToken()) != null) {
                            if (next.is(lexeme) && !matches.isEmpty()) {
                                matches.pop();
                            }
                            t = next;
                        }
                    }
                    t = t.getNextToken();
                    continue;
                }
                if (!matches.isEmpty()) {
                    try {
                        Token match = (Token)matches.pop();
                        int end = match.getOffset() + match.length();
                        h.addMarkedOccurrenceHighlight(match.getOffset(), end, p);
                        end = tokenOffs + match.length();
                        h.addMarkedOccurrenceHighlight(tokenOffs, end, p);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                    return;
                }
                if (--curLine >= 0) {
                    t = doc.getTokenListForLine(curLine);
                }
                if (curLine < 0) break;
            }
        }
    }
}

