/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.Iterator;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TokenIterator
implements Iterator<Token> {
    private RSyntaxDocument doc;
    private int curLine;
    private Token token;

    public TokenIterator(RSyntaxDocument doc) {
        this.doc = doc;
        this.token = doc.getTokenListForLine(0);
    }

    private int getLineCount() {
        return this.doc.getDefaultRootElement().getElementCount();
    }

    @Override
    public boolean hasNext() {
        return this.token != null;
    }

    @Override
    public Token next() {
        Token t = this.token;
        if (this.token != null) {
            if (this.token.isPaintable()) {
                this.token = this.token.getNextToken();
                int lineCount = this.getLineCount();
                while (this.token != null && !this.token.isPaintable() && ++this.curLine < lineCount) {
                    t = new TokenImpl(t);
                    this.token = this.doc.getTokenListForLine(this.curLine);
                }
            } else {
                this.token = null;
            }
        }
        return t;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

