/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.config.Config;
import com.baselet.control.config.SharedConfig;
import com.baselet.control.constants.Constants;
import com.baselet.control.enums.Program;
import com.baselet.control.enums.RuntimeType;
import com.baselet.control.util.Utils;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DiagramNotification;
import com.baselet.diagram.PaletteHandler;
import com.baselet.diagram.SelectorOld;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.element.Relation;
import com.baselet.gui.listener.ScrollbarListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import org.apache.log4j.Logger;

public class DrawPanel
extends JLayeredPane
implements Printable {
    private static final Logger log = Logger.getLogger(DrawPanel.class);
    private final Point origin;
    private JScrollPane _scr;
    private final SelectorOld selector;
    private final DiagramHandler handler;
    private final List<GridElement> gridElements = new ArrayList<GridElement>();
    private DiagramNotification notification;

    public DrawPanel(DiagramHandler handler) {
        this.handler = handler;
        this.origin = new Point();
        this.setLayout(null);
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.selector = new SelectorOld(this);
        JScrollPane p = new JScrollPane(){

            @Override
            public void setEnabled(boolean en) {
                super.setEnabled(en);
                this.getViewport().getView().setEnabled(en);
            }
        };
        p.getHorizontalScrollBar().setUnitIncrement(50);
        p.getHorizontalScrollBar().setSize(0, 15);
        p.setHorizontalScrollBarPolicy(30);
        p.getVerticalScrollBar().setUnitIncrement(50);
        p.getVerticalScrollBar().setSize(15, 0);
        p.setVerticalScrollBarPolicy(20);
        ScrollbarListener sbL = new ScrollbarListener(this);
        p.getHorizontalScrollBar().addMouseListener(sbL);
        p.getVerticalScrollBar().addMouseListener(sbL);
        p.setBorder(null);
        this.setScrollPanel(p);
        if (Program.getInstance().getRuntimeType() != RuntimeType.BATCH) {
            new Timer("updatePanelAndScrollbars", true).schedule(new TimerTask(){

                @Override
                public void run() {
                    if (DrawPanel.this.isValid()) {
                        DrawPanel.this.updatePanelAndScrollbars();
                        this.cancel();
                    }
                }
            }, 25L, 25L);
        }
        this.repaint();
    }

    @Override
    public void setEnabled(boolean en) {
        super.setEnabled(en);
        this.handler.setEnabled(en);
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setEnabled(en);
            ++n2;
        }
        if (en) {
            this.setBackground(new Color(255, 255, 255));
        } else {
            this.setBackground(new Color(235, 235, 235));
        }
    }

    public DiagramHandler getHandler() {
        return this.handler;
    }

    private void setScrollPanel(JScrollPane scr) {
        this._scr = scr;
        scr.setViewportView(this);
    }

    public JScrollPane getScrollPane() {
        return this._scr;
    }

    public static Rectangle getContentBounds(int borderSpace, Collection<GridElement> entities) {
        if (entities.size() == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = 0;
        int maxy = 0;
        for (GridElement e : entities) {
            minx = Math.min(minx, e.getRectangle().x - borderSpace);
            miny = Math.min(miny, e.getRectangle().y - borderSpace);
            maxx = Math.max(maxx, e.getRectangle().x + e.getRectangle().width + borderSpace);
            maxy = Math.max(maxy, e.getRectangle().y + e.getRectangle().height + borderSpace);
        }
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        RepaintManager currentManager = RepaintManager.currentManager(this);
        currentManager.setDoubleBufferingEnabled(false);
        Rectangle bounds = DrawPanel.getContentBounds(Config.getInstance().getPrintPadding(), this.getGridElements());
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        AffineTransform t = g2d.getTransform();
        double scale = Math.min(pageFormat.getImageableWidth() / (double)bounds.width, pageFormat.getImageableHeight() / (double)bounds.height);
        if (scale < 1.0) {
            t.scale(scale, scale);
            g2d.setTransform(t);
        }
        g2d.translate(-bounds.x, -bounds.y);
        this.paint(g2d);
        currentManager = RepaintManager.currentManager(this);
        currentManager.setDoubleBufferingEnabled(true);
        return 0;
    }

    public List<GridElement> getGridElements() {
        return this.gridElements;
    }

    public List<Relation> getOldRelations() {
        return this.getHelper(Relation.class);
    }

    public List<com.baselet.element.relation.Relation> getStickables(Collection<GridElement> excludeList) {
        if (!SharedConfig.getInstance().isStickingEnabled() || this.handler instanceof PaletteHandler) {
            return Collections.emptyList();
        }
        List<com.baselet.element.relation.Relation> returnList = this.getHelper(com.baselet.element.relation.Relation.class);
        returnList.removeAll(excludeList);
        return returnList;
    }

    private <T extends GridElement> List<T> getHelper(Class<T> filtered) {
        ArrayList<GridElement> gridElementsToReturn = new ArrayList<GridElement>();
        for (GridElement e : this.getGridElements()) {
            if (!e.getClass().equals(filtered)) continue;
            gridElementsToReturn.add(e);
        }
        return gridElementsToReturn;
    }

    public SelectorOld getSelector() {
        return this.selector;
    }

    public void updatePanelAndScrollbars() {
        this.insertUpperLeftWhitespaceIfNeeded();
        this.removeUnnecessaryWhitespaceAroundDiagram();
    }

    private void insertUpperLeftWhitespaceIfNeeded() {
        Rectangle diaWithoutWhite = DrawPanel.getContentBounds(0, this.getGridElements());
        int adjustWidth = 0;
        if (diaWithoutWhite.getX() < 0) {
            adjustWidth = diaWithoutWhite.getX();
        }
        int adjustHeight = 0;
        if (diaWithoutWhite.getY() < 0) {
            adjustHeight = diaWithoutWhite.getY();
        }
        this.moveOrigin(adjustWidth, adjustHeight);
        if (adjustWidth != 0 || adjustHeight != 0) {
            int i = 0;
            while (i < this.getComponents().length) {
                Component c = this.getComponent(i);
                c.setLocation(this.handler.realignToGrid(false, c.getX() - adjustWidth), this.handler.realignToGrid(false, c.getY() - adjustHeight));
                ++i;
            }
        }
        if (adjustWidth < 0) {
            this.setHorizontalScrollbarVisibility(true);
        }
        if (adjustHeight < 0) {
            this.setVerticalScrollbarVisibility(true);
        }
        int width = (int)((double)this._scr.getHorizontalScrollBar().getValue() + this.getViewableDiagrampanelSize().getWidth() - (double)adjustWidth);
        int height = (int)((double)this._scr.getVerticalScrollBar().getValue() + this.getViewableDiagrampanelSize().getHeight() - (double)adjustHeight);
        this.setPreferredSize(new Dimension(width, height));
        this.changeViewPosition(-adjustWidth, -adjustHeight);
    }

    public void changeViewPosition(int incx, int incy) {
        Point viewp = this._scr.getViewport().getViewPosition();
        this._scr.getViewport().setViewSize(this.getPreferredSize());
        this._scr.getViewport().setViewPosition(new Point(viewp.x + incx, viewp.y + incy));
    }

    private void removeUnnecessaryWhitespaceAroundDiagram() {
        Rectangle diaWithoutWhite = DrawPanel.getContentBounds(0, this.getGridElements());
        Dimension viewSize = this.getViewableDiagrampanelSize();
        int horSbPos = this._scr.getHorizontalScrollBar().getValue();
        int verSbPos = this._scr.getVerticalScrollBar().getValue();
        horSbPos = this.handler.realignToGrid(false, horSbPos);
        verSbPos = this.handler.realignToGrid(false, verSbPos);
        int newX = 0;
        if (this._scr.getHorizontalScrollBar().isShowing()) {
            newX = horSbPos > diaWithoutWhite.getX() ? diaWithoutWhite.getX() : horSbPos;
        }
        int newY = 0;
        if (this._scr.getVerticalScrollBar().isShowing()) {
            newY = verSbPos > diaWithoutWhite.getY() ? diaWithoutWhite.getY() : verSbPos;
        }
        int newWidth = (int)((double)horSbPos + viewSize.getWidth());
        if ((double)(diaWithoutWhite.getX() + diaWithoutWhite.getWidth()) > (double)horSbPos + viewSize.getWidth()) {
            newWidth = diaWithoutWhite.getX() + diaWithoutWhite.getWidth();
        }
        int newHeight = (int)((double)verSbPos + viewSize.getHeight());
        if ((double)(diaWithoutWhite.getY() + diaWithoutWhite.getHeight()) > (double)verSbPos + viewSize.getHeight()) {
            newHeight = diaWithoutWhite.getY() + diaWithoutWhite.getHeight();
        }
        this.moveOrigin(newX, newY);
        for (GridElement ge : this.getGridElements()) {
            ge.setLocation(this.handler.realignToGrid(false, ge.getRectangle().x - newX), this.handler.realignToGrid(false, ge.getRectangle().y - newY));
        }
        this.changeViewPosition(-newX, -newY);
        this.setPreferredSize(new Dimension(newWidth - newX, newHeight - newY));
        this.checkIfScrollbarsAreNecessary();
    }

    public Dimension getViewableDiagrampanelSize() {
        return this.getVisibleRect().getSize();
    }

    private void checkIfScrollbarsAreNecessary() {
        Rectangle diaWithoutWhite = DrawPanel.getContentBounds(0, this.getGridElements());
        Dimension viewSize = this.getViewableDiagrampanelSize();
        boolean vertWasVisible = this.isVerticalScrollbarVisible();
        boolean horWasVisible = this.isHorizontalScrollbarVisible();
        int verSbWidth = 0;
        int horSbHeight = 0;
        if (vertWasVisible) {
            verSbWidth = this._scr.getVerticalScrollBar().getWidth();
        }
        if (horWasVisible) {
            horSbHeight = this._scr.getHorizontalScrollBar().getHeight();
        }
        if (this._scr.getHorizontalScrollBar().getValue() < this.handler.getGridSize() && (double)(diaWithoutWhite.getX() + diaWithoutWhite.getWidth()) <= viewSize.getWidth() + (double)verSbWidth) {
            this.setHorizontalScrollbarVisibility(false);
        } else if (this._scr.getHorizontalScrollBar().getValue() < this.handler.getGridSize() && this.getViewableDiagrampanelSize().width + this._scr.getHorizontalScrollBar().getValue() == diaWithoutWhite.getX() + diaWithoutWhite.getWidth()) {
            this.setHorizontalScrollbarVisibility(false);
        } else {
            this.setHorizontalScrollbarVisibility(true);
        }
        if (this._scr.getVerticalScrollBar().getValue() < this.handler.getGridSize() && (double)(diaWithoutWhite.getY() + diaWithoutWhite.getHeight()) <= viewSize.getHeight() + (double)horSbHeight) {
            this.setVerticalScrollbarVisibility(false);
        } else if (this._scr.getVerticalScrollBar().getValue() < this.handler.getGridSize() && this.getViewableDiagrampanelSize().height + this._scr.getVerticalScrollBar().getValue() == diaWithoutWhite.getY() + diaWithoutWhite.getHeight()) {
            this.setVerticalScrollbarVisibility(false);
        } else {
            this.setVerticalScrollbarVisibility(true);
        }
        int adx = 0;
        int ady = 0;
        if (this._scr.getHorizontalScrollBar().getValue() != 0 && vertWasVisible && !this.isVerticalScrollbarVisible()) {
            adx = this.handler.realignToGrid(false, horSbHeight);
        }
        if (this._scr.getVerticalScrollBar().getValue() != 0 && horWasVisible && !this.isHorizontalScrollbarVisible()) {
            ady = this.handler.realignToGrid(false, verSbWidth);
        }
        if (adx != 0 || ady != 0) {
            this.setPreferredSize(new Dimension((int)(this.getPreferredSize().getWidth() + (double)adx), (int)this.getPreferredSize().getHeight() + ady));
            this.changeViewPosition(adx, ady);
        }
    }

    private void setHorizontalScrollbarVisibility(boolean visible) {
        if (visible) {
            this._scr.setHorizontalScrollBarPolicy(32);
        } else {
            this._scr.setHorizontalScrollBarPolicy(31);
        }
    }

    private void setVerticalScrollbarVisibility(boolean visible) {
        if (visible) {
            this._scr.setVerticalScrollBarPolicy(22);
        } else {
            this._scr.setVerticalScrollBarPolicy(21);
        }
    }

    private boolean isHorizontalScrollbarVisible() {
        return this._scr.getHorizontalScrollBarPolicy() == 32;
    }

    private boolean isVerticalScrollbarVisible() {
        return this._scr.getVerticalScrollBarPolicy() == 22;
    }

    private void drawGrid(Graphics2D g2d) {
        g2d.setColor(Constants.GRID_COLOR);
        int gridSize = this.handler.getGridSize();
        if (gridSize == 1) {
            return;
        }
        int width = 2000 + (int)this.getPreferredSize().getWidth();
        int height = 1000 + (int)this.getPreferredSize().getHeight();
        int i = gridSize;
        while (i < width) {
            g2d.drawLine(i, 0, i, height);
            i += gridSize;
        }
        i = gridSize;
        while (i < height) {
            g2d.drawLine(0, i, width, i);
            i += gridSize;
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        for (GridElement ge : this.gridElements) {
            if (ge.getLayer().equals(DrawPanel.getLayer((JComponent)((Object)ge.getComponent())))) continue;
            this.setLayer((JComponent)((Object)ge.getComponent()), ge.getLayer());
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(Utils.getUxRenderingQualityHigh(true));
        if (Config.getInstance().isShow_grid()) {
            this.drawGrid(g2d);
        }
        super.paintComponents(g);
    }

    public Point getOriginAtDefaultZoom() {
        Point originCopy = new Point(this.origin);
        originCopy.setLocation(this.origin.x * 10 / this.handler.getGridSize(), this.origin.y * 10 / this.handler.getGridSize());
        return originCopy;
    }

    public Point getOrigin() {
        log.trace((Object)("Diagram origin: " + this.origin));
        return new Point(this.origin);
    }

    public void moveOrigin(int dx, int dy) {
        log.trace((Object)("Move origin to: " + this.origin));
        this.origin.translate(this.handler.realignToGrid(false, dx), this.handler.realignToGrid(false, dy));
    }

    public void zoomOrigin(int oldGridSize, int newGridSize) {
        log.trace((Object)("Zoom origin to: " + this.origin));
        this.origin.setLocation(this.origin.x * newGridSize / oldGridSize, this.origin.y * newGridSize / oldGridSize);
    }

    public void removeElement(GridElement gridElement) {
        this.gridElements.remove(gridElement);
        this.remove((Component)((Object)gridElement.getComponent()));
    }

    public void addElement(GridElement gridElement) {
        this.gridElements.add(gridElement);
        this.add((Component)((Object)gridElement.getComponent()), gridElement.getLayer());
    }

    public void updateElements() {
        for (GridElement e : this.gridElements) {
            e.updateModelFromText();
        }
    }

    public GridElement getElementToComponent(Component component) {
        for (GridElement e : this.gridElements) {
            if (!e.getComponent().equals(component)) continue;
            return e;
        }
        return null;
    }

    public void scroll(int amount) {
        JScrollBar scrollBar = this._scr.getVerticalScrollBar();
        int increment = scrollBar.getUnitIncrement();
        scrollBar.setValue(scrollBar.getValue() + amount * increment);
    }

    public void setNotification(DiagramNotification newNotification) {
        if (this.notification != null) {
            this.remove(this.notification);
        }
        this.notification = newNotification;
        this.add(this.notification);
        this.repaint();
    }
}

