/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.config.SharedConfig;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Direction;
import com.baselet.control.enums.ElementStyle;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.PropertiesParser;
import com.baselet.element.UndoHistory;
import com.baselet.element.UndoInformation;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.facet.Settings;
import com.baselet.element.facet.common.GroupFacet;
import com.baselet.element.facet.common.LayerFacet;
import com.baselet.element.interfaces.Component;
import com.baselet.element.interfaces.DrawHandlerInterface;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.interfaces.GridElementDeprecatedAddons;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.Stickable;
import com.baselet.element.sticking.StickableMap;
import com.baselet.element.sticking.Stickables;
import com.baselet.element.sticking.StickingPolygon;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class NewGridElement
implements GridElement {
    private final Logger log = Logger.getLogger(NewGridElement.class);
    private DrawHandler drawer;
    private DrawHandler metaDrawer;
    private Component component;
    private DrawHandlerInterface handler;
    private List<String> panelAttributes;
    protected PropertiesParserState state;
    protected final UndoHistory undoStack = new UndoHistory();
    private boolean autoresizePossiblyInProgress = false;

    public void init(Rectangle rectangle, String string, String string2, Component component, DrawHandlerInterface drawHandlerInterface) {
        this.component = component;
        this.drawer = component.getDrawHandler();
        this.metaDrawer = component.getMetaDrawHandler();
        this.setPanelAttributesHelper(string);
        this.setRectangle(rectangle);
        this.handler = drawHandlerInterface;
        this.state = new PropertiesParserState(this.createSettings(), this.drawer);
        this.setAdditionalAttributes(string2);
    }

    @Override
    public String getPanelAttributes() {
        return SharedUtils.listToString("\n", this.panelAttributes);
    }

    @Override
    public List<String> getPanelAttributesAsList() {
        return this.panelAttributes;
    }

    @Override
    public void setPanelAttributes(String string) {
        this.setPanelAttributesHelper(string);
        this.updateModelFromText();
    }

    public void setPanelAttributesHelper(String string) {
        this.panelAttributes = Arrays.asList(string.split("\n", -1));
    }

    @Override
    public void updateModelFromText() {
        this.autoresizePossiblyInProgress = true;
        this.drawer.clearCache();
        this.drawer.resetStyle();
        try {
            PropertiesParser.parsePropertiesAndHandleFacets(this, this.state);
        }
        catch (Exception exception) {
            this.log.info((Object)"Cannot parse Properties Text", (Throwable)exception);
            this.drawer.resetStyle();
            String string = exception.getLocalizedMessage();
            if (string == null) {
                string = exception.toString();
            }
            this.drawError(this.drawer, string);
        }
        this.autoresizePossiblyInProgress = false;
        this.component.afterModelUpdate();
    }

    protected void drawError(DrawHandler drawHandler, String string) {
        drawHandler.setEnableDrawing(true);
        drawHandler.setForegroundColor(ColorOwn.RED);
        drawHandler.setBackgroundColor(ColorOwn.RED.transparency(ColorOwn.Transparency.SELECTION_BACKGROUND));
        drawHandler.setLineWidth(0.2);
        drawHandler.drawRectangle(0.0, 0.0, this.getRealSize().width, this.getRealSize().height);
        this.resetAndDrawMetaDrawerContent(this.metaDrawer);
        drawHandler.print(string, 3.0, (double)this.getRealSize().height * 0.5 - drawHandler.textHeightMax(), AlignHorizontal.LEFT);
    }

    void resetMetaDrawerAndDrawCommonContent(PropertiesParserState propertiesParserState, boolean bl) {
        this.drawCommonContent(propertiesParserState);
        if (bl) {
            this.resetAndDrawMetaDrawerContent(this.metaDrawer);
        }
    }

    protected abstract void drawCommonContent(PropertiesParserState var1);

    protected void resetAndDrawMetaDrawerContent(DrawHandler drawHandler) {
        drawHandler.clearCache();
        drawHandler.setForegroundColor(ColorOwn.TRANSPARENT);
        drawHandler.setBackgroundColor(ColorOwn.SELECTION_BG);
        drawHandler.drawRectangle(0.0, 0.0, this.getRealSize().width, this.getRealSize().height);
        if (SharedConfig.getInstance().isDev_mode()) {
            drawHandler.setForegroundColor(ColorOwn.BLACK);
            drawHandler.setFontSize(10.5);
            drawHandler.print(this.getId().toString(), new PointDouble(this.getRealSize().width - 3, this.getRealSize().height - 2), AlignHorizontal.RIGHT);
        }
        drawHandler.resetColorSettings();
        if (SharedConfig.getInstance().isShow_stickingpolygon()) {
            this.drawStickingPolygon(drawHandler);
        }
    }

    @Override
    public void setProperty(String string, Object object) {
        StringBuilder stringBuilder = new StringBuilder("");
        for (String string2 : this.getPanelAttributesAsList()) {
            if (string2.startsWith(string)) continue;
            stringBuilder.append(string2).append("\n");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        if (object != null) {
            stringBuilder.append("\n").append(string).append("=").append(object.toString());
        }
        this.setPanelAttributes(stringBuilder.toString());
    }

    @Override
    public String getSetting(String string) {
        for (String string2 : this.getPanelAttributesAsList()) {
            String[] stringArray;
            if (!string2.startsWith(string + "=") || (stringArray = string2.split("=", 2)).length <= 1) continue;
            return stringArray[1];
        }
        return null;
    }

    @Override
    public String getAdditionalAttributes() {
        return "";
    }

    @Override
    public void setAdditionalAttributes(String string) {
    }

    @Override
    public boolean isInRange(Rectangle rectangle) {
        return rectangle.contains(this.getRectangle());
    }

    @Override
    public Set<Direction> getResizeArea(int n, int n2) {
        HashSet<Direction> hashSet = new HashSet<Direction>();
        if (this.state.getElementStyle() == ElementStyle.NORESIZE || this.state.getElementStyle() == ElementStyle.AUTORESIZE) {
            return hashSet;
        }
        if (n <= 5 && n >= 0) {
            hashSet.add(Direction.LEFT);
        } else if (n <= this.getRectangle().width && n >= this.getRectangle().width - 5) {
            hashSet.add(Direction.RIGHT);
        }
        if (n2 <= 5 && n2 >= 0) {
            hashSet.add(Direction.UP);
        } else if (n2 <= this.getRectangle().height && n2 >= this.getRectangle().height - 5) {
            hashSet.add(Direction.DOWN);
        }
        return hashSet;
    }

    @Override
    @Deprecated
    public final StickingPolygon generateStickingBorder(Rectangle rectangle) {
        return this.state.getStickingPolygonGenerator().generateStickingBorder(rectangle);
    }

    @Override
    public final StickingPolygon generateStickingBorder() {
        return this.generateStickingBorder(this.getRealRectangle());
    }

    private final void drawStickingPolygon(DrawHandler drawHandler) {
        Rectangle rectangle = new Rectangle(0, 0, this.getRealSize().width, this.getRealSize().height);
        StickingPolygon stickingPolygon = this.generateStickingBorder(rectangle);
        drawHandler.setLineType(LineType.DASHED);
        drawHandler.setForegroundColor(ColorOwn.STICKING_POLYGON);
        Vector<StickingPolygon.StickLine> vector = stickingPolygon.getStickLines();
        drawHandler.drawLines(vector.toArray(new Line[vector.size()]));
        drawHandler.setLineType(LineType.SOLID);
        drawHandler.resetColorSettings();
    }

    @Override
    public void setRectangle(Rectangle rectangle) {
        this.component.setBoundsRect(rectangle);
    }

    @Override
    public void setLocationDifference(int n, int n2) {
        this.setLocation(this.getRectangle().x + n, this.getRectangle().y + n2);
    }

    @Override
    public void setLocation(int n, int n2) {
        Rectangle rectangle = this.getRectangle();
        rectangle.setLocation(n, n2);
        this.component.setBoundsRect(rectangle);
    }

    @Override
    public void setSize(int n, int n2) {
        if (n != this.getRectangle().width || n2 != this.getRectangle().height) {
            Rectangle rectangle = this.getRectangle();
            rectangle.setSize(n, n2);
            this.setRectangle(rectangle);
            if (!this.autoresizePossiblyInProgress) {
                this.updateModelFromText();
            }
        }
    }

    @Override
    public Rectangle getRectangle() {
        return this.component.getBoundsRect();
    }

    @Override
    public void repaint() {
        this.component.repaintComponent();
    }

    @Override
    public Dimension getRealSize() {
        return new Dimension(this.zoom(this.getRectangle().width), this.zoom(this.getRectangle().height));
    }

    public Rectangle getRealRectangle() {
        return new Rectangle(this.zoom(this.getRectangle().x), this.zoom(this.getRectangle().y), this.zoom(this.getRectangle().width), this.zoom(this.getRectangle().height));
    }

    private int zoom(int n) {
        return n * 10 / this.getGridSize();
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    protected abstract Settings createSettings();

    @Override
    public List<AutocompletionText> getAutocompletionList() {
        ArrayList<AutocompletionText> arrayList = new ArrayList<AutocompletionText>();
        this.addAutocompletionTexts(arrayList, this.state.getSettings().getFacetsForFirstRun());
        this.addAutocompletionTexts(arrayList, this.state.getSettings().getFacetsForSecondRun());
        return arrayList;
    }

    private void addAutocompletionTexts(List<AutocompletionText> list, List<? extends Facet> list2) {
        for (Facet facet : list2) {
            for (AutocompletionText autocompletionText : facet.getAutocompletionStrings()) {
                list.add(autocompletionText);
            }
        }
    }

    @Override
    public Integer getLayer() {
        return this.state.getFacetResponse(LayerFacet.class, LayerFacet.DEFAULT_VALUE);
    }

    @Override
    public Integer getGroup() {
        return this.state.getFacetResponse(GroupFacet.class, null);
    }

    public void handleAutoresize(DimensionDouble dimensionDouble, AlignHorizontal alignHorizontal) {
        double d = this.drawer.getDistanceBorderToText() * 2.0;
        double d2 = dimensionDouble.getWidth() + d;
        double d3 = dimensionDouble.getHeight() + this.drawer.textHeightMax() / 2.0;
        Dimension dimension = this.getRealSize();
        double d4 = d2 - (double)dimension.width;
        double d5 = d3 - (double)dimension.height;
        int n = SharedUtils.realignTo(false, this.unzoom(d4), true, this.getGridSize());
        int n2 = SharedUtils.realignTo(false, this.unzoom(d5), true, this.getGridSize());
        List<Direction> list = null;
        if (alignHorizontal == AlignHorizontal.LEFT) {
            list = Arrays.asList(Direction.RIGHT, Direction.DOWN);
        } else if (alignHorizontal == AlignHorizontal.RIGHT) {
            n = -n;
            list = Arrays.asList(Direction.LEFT, Direction.DOWN);
        } else if (alignHorizontal == AlignHorizontal.CENTER) {
            n = SharedUtils.realignTo(false, (double)n / 2.0, true, this.getGridSize()) * 2;
            list = Arrays.asList(Direction.RIGHT, Direction.LEFT, Direction.DOWN);
        }
        this.drag(list, n, n2, new Point(0, 0), false, true, this.handler.getStickableMap(), false);
    }

    private double unzoom(double d) {
        return d / 10.0 * (double)this.getGridSize();
    }

    @Override
    public void setRectangleDifference(int n, int n2, int n3, int n4, boolean bl, StickableMap stickableMap, boolean bl2) {
        Rectangle rectangle = this.getRectangle();
        StickingPolygon stickingPolygon = this.generateStickingBorder();
        String string = this.getAdditionalAttributes();
        this.setRectangle(new Rectangle(rectangle.x + n, rectangle.y + n2, rectangle.getWidth() + n3, rectangle.getHeight() + n4));
        this.moveStickables(stickableMap, bl2, rectangle, stickingPolygon, string);
    }

    @Override
    public void drag(Collection<Direction> collection, int n, int n2, Point point, boolean bl, boolean bl2, StickableMap stickableMap, boolean bl3) {
        Rectangle rectangle = this.getRectangle();
        StickingPolygon stickingPolygon = this.generateStickingBorder();
        String string = this.getAdditionalAttributes();
        if (collection.isEmpty()) {
            this.setLocationDifference(n, n2);
        } else {
            int n3;
            Rectangle rectangle2 = this.getRectangle();
            if (bl && this.diagonalResize(collection)) {
                boolean bl4;
                n3 = n > 0 && n > n2 ? 1 : 0;
                boolean bl5 = n2 > 0 && n2 > n;
                boolean bl6 = n < 0 && n < n2;
                boolean bl7 = bl4 = n2 < 0 && n2 < n;
                if (n3 != 0 || bl6) {
                    n2 = n;
                }
                if (bl5 || bl4) {
                    n = n2;
                }
            }
            if (collection.contains((Object)Direction.LEFT) && collection.contains((Object)Direction.RIGHT)) {
                rectangle2.setX(rectangle2.getX() - n / 2);
                rectangle2.setWidth(Math.max(rectangle2.getWidth() + n, this.minSize()));
            } else if (collection.contains((Object)Direction.LEFT)) {
                n3 = rectangle2.getWidth() - n;
                if (n3 >= this.minSize()) {
                    rectangle2.setX(rectangle2.getX() + n);
                    rectangle2.setWidth(n3);
                }
            } else if (collection.contains((Object)Direction.RIGHT)) {
                rectangle2.setWidth(Math.max(rectangle2.getWidth() + n, this.minSize()));
            }
            if (collection.contains((Object)Direction.UP) && (n3 = rectangle2.getHeight() - n2) >= this.minSize()) {
                rectangle2.setY(rectangle2.getY() + n2);
                rectangle2.setHeight(n3);
            }
            if (collection.contains((Object)Direction.DOWN)) {
                rectangle2.setHeight(Math.max(rectangle2.getHeight() + n2, this.minSize()));
            }
            this.setRectangle(rectangle2);
            if (!this.autoresizePossiblyInProgress) {
                this.updateModelFromText();
            }
        }
        this.moveStickables(stickableMap, bl3, rectangle, stickingPolygon, string);
    }

    private void moveStickables(StickableMap stickableMap, boolean bl, Rectangle rectangle, StickingPolygon stickingPolygon, String string) {
        Map<Stickable, List<PointChange>> map = Stickables.moveStickPointsBasedOnPolygonChanges(stickingPolygon, this.generateStickingBorder(), stickableMap, this.getGridSize());
        if (bl) {
            this.undoStack.add(new UndoInformation(this.getRectangle(), rectangle, map, this.getGridSize(), string, this.getAdditionalAttributes()));
        }
    }

    @Override
    public void dragEnd() {
    }

    @Override
    public boolean isSelectableOn(Point point) {
        return this.getRectangle().contains(point);
    }

    private boolean diagonalResize(Collection<Direction> collection) {
        return collection.contains((Object)Direction.UP) && collection.contains((Object)Direction.RIGHT) || collection.contains((Object)Direction.UP) && collection.contains((Object)Direction.LEFT) || collection.contains((Object)Direction.DOWN) && collection.contains((Object)Direction.LEFT) || collection.contains((Object)Direction.DOWN) && collection.contains((Object)Direction.RIGHT);
    }

    protected DrawHandlerInterface getHandler() {
        return this.handler;
    }

    public int getGridSize() {
        return this.getHandler().getGridSize();
    }

    private int minSize() {
        return this.handler.getGridSize() * 2;
    }

    @Override
    public void undoDrag() {
        this.execUndoInformation(true);
    }

    private void execUndoInformation(boolean bl) {
        UndoInformation undoInformation = this.undoStack.get(bl);
        if (undoInformation != null) {
            this.setRectangle(this.getRectangle().add(undoInformation.getDiffRectangle(this.getGridSize(), bl)));
            Stickables.applyChanges(undoInformation.getStickableMoves(bl), null);
            this.setAdditionalAttributes(undoInformation.getAdditionalAttributes(bl));
        }
    }

    @Override
    public void redoDrag() {
        this.execUndoInformation(false);
    }

    @Override
    public void mergeUndoDrag() {
        UndoInformation undoInformation = this.undoStack.remove();
        UndoInformation undoInformation2 = this.undoStack.remove();
        this.undoStack.add(undoInformation.merge(undoInformation2));
    }

    @Override
    public GridElementDeprecatedAddons getDeprecatedAddons() {
        return GridElementDeprecatedAddons.NONE;
    }
}

