/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ascan.ActiveScanTableModel;
import org.zaproxy.zap.extension.ascan.ResponseCountSnapshot;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.Target;

public class ActiveScan
extends Scanner
implements GenericScanner2,
ScannerListener {
    private static final int MAX_STATS_HISTORY_SIZE = 240;
    private String displayName = null;
    private int progress = 0;
    private ActiveScanTableModel messagesTableModel = new ActiveScanTableModel();
    private SiteNode startNode = null;
    private ResponseCountSnapshot rcTotals = new ResponseCountSnapshot();
    private ResponseCountSnapshot rcLastSnapshot = new ResponseCountSnapshot();
    private List<ResponseCountSnapshot> rcHistory = new ArrayList<ResponseCountSnapshot>();
    private Date timeStarted = null;
    private Date timeFinished = null;
    private int maxResultsToList = 0;
    private int prevScanReqCount = 0;
    private final List<Integer> hRefs = Collections.synchronizedList(new ArrayList());
    private final List<Integer> alerts = Collections.synchronizedList(new ArrayList());
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> schedHandle;
    private static final Logger log = Logger.getLogger(ActiveScan.class);

    public ActiveScan(String string, ScannerParam scannerParam, ConnectionParam connectionParam, ScanPolicy scanPolicy) {
        super(scannerParam, connectionParam, scanPolicy);
        this.displayName = string;
        this.maxResultsToList = scannerParam.getMaxResultsToList();
        this.addScannerListener(this);
    }

    @Override
    public int getMaximum() {
        return 100;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public boolean isRunning() {
        return !this.isStop();
    }

    @Override
    public boolean isStopped() {
        return super.isStop();
    }

    @Override
    public void pauseScan() {
        if (this.isRunning()) {
            super.pause();
        }
    }

    public int getTotalRequests() {
        return this.rcTotals.getTotal();
    }

    public ResponseCountSnapshot getRequestHistory() {
        if (this.rcHistory.size() > 0) {
            try {
                return this.rcHistory.remove(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void start(Target target) {
        this.reset();
        this.timeStarted = new Date();
        this.progress = 0;
        super.start(target);
        if (View.isInitialised()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (ActiveScan.this.isStop()) {
                        ActiveScan.this.schedHandle.cancel(true);
                        return;
                    }
                    ResponseCountSnapshot responseCountSnapshot = ActiveScan.this.rcTotals.clone();
                    ActiveScan.this.rcHistory.add(responseCountSnapshot.getDifference(ActiveScan.this.rcLastSnapshot));
                    if (ActiveScan.this.rcHistory.size() > 240) {
                        ActiveScan.this.rcHistory.remove(0);
                    }
                    ActiveScan.this.rcLastSnapshot = responseCountSnapshot;
                }
            };
            this.schedHandle = this.scheduler.scheduleAtFixedRate(runnable, 2L, 2L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void stopScan() {
        super.stop();
        if (this.schedHandle != null) {
            this.schedHandle.cancel(true);
        }
    }

    @Override
    public void resumeScan() {
        if (this.isPaused()) {
            super.resume();
        }
    }

    @Override
    public void alertFound(Alert alert) {
        int n = alert.getAlertId();
        if (n != -1) {
            this.alerts.add(alert.getAlertId());
        }
    }

    @Override
    public void hostComplete(int n, String string) {
    }

    @Override
    public void hostNewScan(int n, String string, HostProcess hostProcess) {
    }

    @Override
    public void hostProgress(int n, String string, String string2, int n2) {
        int n3 = 0;
        for (HostProcess hostProcess : this.getHostProcesses()) {
            n3 += hostProcess.getPercentageComplete();
        }
        this.progress = n3 / this.getHostProcesses().size();
        this.updatePluginRequestCounts();
    }

    public void updatePluginRequestCounts() {
        if (this.getHostProcesses().size() == 1) {
            HostProcess hostProcess = this.getHostProcesses().get(0);
            List<Plugin> list = hostProcess.getRunning();
            int n = this.getTotalRequests();
            int n2 = n - this.prevScanReqCount;
            if (list.size() > 1) {
                log.debug((Object)("More than 1 plugin running: " + list.size() + " unable to calculate request counts"));
            } else if (n2 > 0) {
                if (list.size() == 1) {
                    hostProcess.setPluginRequestCount(list.get(0).getId(), n2);
                } else {
                    list = hostProcess.getCompleted();
                    if (list.size() > 0) {
                        log.debug((Object)("Plugin " + list.get(list.size() - 1).getId() + " total # reqs: " + n2));
                        hostProcess.setPluginRequestCount(list.get(list.size() - 1).getId(), n2);
                        this.prevScanReqCount = n;
                    }
                }
            }
        }
    }

    @Override
    public void scannerComplete(int n) {
        this.timeFinished = new Date();
    }

    public DefaultListModel<HistoryReference> getList() {
        return null;
    }

    public ActiveScanTableModel getMessagesTableModel() {
        return this.messagesTableModel;
    }

    @Override
    public void notifyNewMessage(HttpMessage httpMessage) {
        HistoryReference historyReference = httpMessage.getHistoryRef();
        if (historyReference == null) {
            try {
                historyReference = new HistoryReference(Model.getSingleton().getSession(), 14, httpMessage);
                httpMessage.setHistoryRef(null);
                this.hRefs.add(historyReference.getHistoryId());
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        } else {
            this.hRefs.add(historyReference.getHistoryId());
        }
        this.rcTotals.incResponseCodeCount(httpMessage.getResponseHeader().getStatusCode());
        if (historyReference != null && this.rcTotals.getTotal() <= this.maxResultsToList) {
            this.addHistoryReference(historyReference);
        }
    }

    private void addHistoryReference(HistoryReference historyReference) {
        if (View.isInitialised()) {
            this.addHistoryReferenceInEdt(historyReference);
        }
    }

    private void addHistoryReferenceInEdt(final HistoryReference historyReference) {
        if (EventQueue.isDispatchThread()) {
            this.messagesTableModel.addHistoryReference(historyReference);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActiveScan.this.addHistoryReference(historyReference);
                }
            });
        }
    }

    @Override
    public SiteNode getStartNode() {
        return this.startNode;
    }

    @Override
    public void setStartNode(SiteNode siteNode) {
        this.startNode = siteNode;
        super.setStartNode(siteNode);
    }

    public void reset() {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.messagesTableModel.clear();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActiveScan.this.reset();
                }
            });
        }
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public List<Integer> getMessagesIds() {
        return this.hRefs;
    }

    public List<Integer> getAlertsIds() {
        return this.alerts;
    }

    public State getState() {
        if (this.timeStarted == null) {
            return State.NOT_STARTED;
        }
        if (this.isStop()) {
            return State.FINISHED;
        }
        if (this.isPaused()) {
            return State.PAUSED;
        }
        return State.RUNNING;
    }

    @Override
    public void setDisplayName(String string) {
        this.displayName = string;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setScanId(int n) {
        this.setId(n);
    }

    @Override
    public int getScanId() {
        return this.getId();
    }

    public static enum State {
        NOT_STARTED,
        RUNNING,
        PAUSED,
        FINISHED;

    }
}

