/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.view.View;

public class CategoryTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private Map<String, String> i18nToStr = null;
    private Map<Integer, String> scannersQuality = new HashMap<Integer, String>();
    private static final String[] columnNames = new String[]{Constant.messages.getString("ascan.policy.table.testname"), Constant.messages.getString("ascan.policy.table.threshold"), Constant.messages.getString("ascan.policy.table.strength"), Constant.messages.getString("ascan.policy.table.quality")};
    private Vector<Plugin> listTestCategory = new Vector();
    private PluginFactory pluginFactory;
    private int category;
    private Plugin.AlertThreshold defaultThreshold;

    public void setTable(int n, PluginFactory pluginFactory, Plugin.AlertThreshold alertThreshold) {
        this.listTestCategory.clear();
        this.pluginFactory = pluginFactory;
        this.category = n;
        this.defaultThreshold = alertThreshold;
        for (Plugin plugin : pluginFactory.getAllPlugin()) {
            if (plugin.getCategory() != n) continue;
            this.listTestCategory.add(plugin);
            this.scannersQuality.put(plugin.getId(), Constant.messages.getString("ascan.policy.table.quality." + plugin.getStatus().name()));
        }
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Plugin plugin = this.listTestCategory.get(n);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                boolean bl;
                Plugin.AlertThreshold alertThreshold = Plugin.AlertThreshold.valueOf(this.i18nToStr((String)object));
                boolean bl2 = bl = !Plugin.AlertThreshold.OFF.equals((Object)alertThreshold);
                if (plugin.isEnabled() != bl) {
                    if (bl) {
                        String[] stringArray = plugin.getDependency();
                        if (stringArray != null && stringArray.length != 0) {
                            ArrayList<Plugin> arrayList = new ArrayList<Plugin>(stringArray.length);
                            if (!this.pluginFactory.addAllDependencies(plugin, arrayList)) {
                                View.getSingleton().showWarningDialog(Constant.messages.getString("ascan.policy.unfulfilled.dependencies"));
                                return;
                            }
                            ArrayList<Plugin> arrayList2 = new ArrayList<Plugin>();
                            for (Plugin plugin2 : arrayList) {
                                if (plugin2.isEnabled()) continue;
                                arrayList2.add(plugin2);
                            }
                            if (!arrayList2.isEmpty()) {
                                this.setPluginsEnabled(arrayList2, true);
                            }
                        }
                    } else {
                        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
                        for (Plugin plugin3 : this.pluginFactory.getDependentPlugins(plugin)) {
                            if (!plugin3.isEnabled()) continue;
                            arrayList.add(plugin3);
                        }
                        if (!arrayList.isEmpty()) {
                            this.setPluginsEnabled(arrayList, false);
                        }
                    }
                }
                plugin.setAlertThreshold(alertThreshold);
                plugin.setEnabled(bl);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 2: {
                plugin.setAttackStrength(Plugin.AttackStrength.valueOf(this.i18nToStr((String)object)));
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    private void setPluginsEnabled(List<Plugin> list, boolean bl) {
        Plugin.AlertThreshold alertThreshold = bl ? this.defaultThreshold : Plugin.AlertThreshold.OFF;
        for (Plugin plugin : list) {
            int n;
            plugin.setEnabled(bl);
            plugin.setAlertThreshold(alertThreshold);
            if (plugin.getCategory() != this.category || (n = this.getPluginRow(plugin)) == -1) continue;
            this.fireTableCellUpdated(n, 1);
        }
    }

    private int getPluginRow(Plugin plugin) {
        for (int i = 0; i < this.listTestCategory.size(); ++i) {
            if (!plugin.equals(this.listTestCategory.get(i))) continue;
            return i;
        }
        return -1;
    }

    private String strToI18n(String string) {
        return Constant.messages.getString("ascan.policy.level." + string.toLowerCase());
    }

    private String i18nToStr(String string) {
        if (this.i18nToStr == null) {
            this.i18nToStr = new HashMap<String, String>();
            for (Plugin.AlertThreshold enum_ : Plugin.AlertThreshold.values()) {
                this.i18nToStr.put(this.strToI18n(enum_.name()), enum_.name());
            }
            for (Enum enum_ : Plugin.AttackStrength.values()) {
                this.i18nToStr.put(this.strToI18n(enum_.name()), enum_.name());
            }
        }
        return this.i18nToStr.get(string);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.getTestList().size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Plugin plugin = this.listTestCategory.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = plugin.getName();
                break;
            }
            case 1: {
                string = this.strToI18n(plugin.getAlertThreshold(true).name());
                break;
            }
            case 2: {
                string = this.strToI18n(plugin.getAttackStrength(true).name());
                break;
            }
            case 3: {
                string = this.scannersQuality.get(plugin.getId());
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private List<Plugin> getTestList() {
        if (this.listTestCategory == null) {
            this.listTestCategory = new Vector();
        }
        return this.listTestCategory;
    }
}

