/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.Script;
import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.hash.HashUtil;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCacheBackedScriptClassCompiler
implements ScriptClassCompiler,
Closeable {
    private final ScriptCompilationHandler scriptCompilationHandler;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final CacheRepository cacheRepository;
    private final CacheValidator validator;
    private final CompositeStoppable caches = new CompositeStoppable();

    public FileCacheBackedScriptClassCompiler(CacheRepository cacheRepository, CacheValidator validator, ScriptCompilationHandler scriptCompilationHandler, ProgressLoggerFactory progressLoggerFactory) {
        this.cacheRepository = cacheRepository;
        this.validator = validator;
        this.scriptCompilationHandler = scriptCompilationHandler;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    @Override
    public <T extends Script, M> CompiledScript<T, M> compile(ScriptSource source, ClassLoader classLoader, ClassLoaderId classLoaderId, CompileOperation<M> operation, Class<T> scriptBaseClass, Action<? super ClassNode> verifier) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("source.filename", source.getFileName());
        properties.put("source.hash", HashUtil.createCompactMD5((String)source.getResource().getText()));
        String dslId = operation.getId();
        String cacheName = String.format("scripts/%s/%s", source.getClassName(), dslId);
        PersistentCache cache = this.cacheRepository.cache(cacheName).withProperties(properties).withValidator(this.validator).withDisplayName(String.format("%s class cache for %s", dslId, source.getDisplayName())).withInitializer(new ProgressReportingInitializer(this.progressLoggerFactory, new CacheInitializer(source, classLoader, operation, verifier, scriptBaseClass))).open();
        this.caches.add(new Object[]{cache});
        File classesDir = this.classesDir(cache);
        File metadataDir = this.metadataDir(cache);
        return this.scriptCompilationHandler.loadFromDir(source, classLoader, classesDir, metadataDir, operation, scriptBaseClass, classLoaderId);
    }

    @Override
    public void close() {
        this.caches.stop();
    }

    private File classesDir(PersistentCache cache) {
        return new File(cache.getBaseDir(), "classes");
    }

    private File metadataDir(PersistentCache cache) {
        return new File(cache.getBaseDir(), "metadata");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProgressReportingInitializer
    implements Action<PersistentCache> {
        private ProgressLoggerFactory progressLoggerFactory;
        private Action<? super PersistentCache> delegate;

        public ProgressReportingInitializer(ProgressLoggerFactory progressLoggerFactory, Action<PersistentCache> delegate) {
            this.progressLoggerFactory = progressLoggerFactory;
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(PersistentCache cache) {
            ProgressLogger op = this.progressLoggerFactory.newOperation(FileCacheBackedScriptClassCompiler.class).start("Compile script into cache", "Compiling script into cache");
            try {
                this.delegate.execute((Object)cache);
            }
            finally {
                op.completed();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheInitializer
    implements Action<PersistentCache> {
        private final Action<? super ClassNode> verifier;
        private final Class<? extends Script> scriptBaseClass;
        private final ClassLoader classLoader;
        private final CompileOperation<?> transformer;
        private final ScriptSource source;

        public <T extends Script> CacheInitializer(ScriptSource source, ClassLoader classLoader, CompileOperation<?> transformer, Action<? super ClassNode> verifier, Class<T> scriptBaseClass) {
            this.source = source;
            this.classLoader = classLoader;
            this.transformer = transformer;
            this.verifier = verifier;
            this.scriptBaseClass = scriptBaseClass;
        }

        public void execute(PersistentCache cache) {
            File classesDir = FileCacheBackedScriptClassCompiler.this.classesDir(cache);
            File metadataDir = FileCacheBackedScriptClassCompiler.this.metadataDir(cache);
            FileCacheBackedScriptClassCompiler.this.scriptCompilationHandler.compileToDir(this.source, this.classLoader, classesDir, metadataDir, this.transformer, this.scriptBaseClass, this.verifier);
        }
    }
}

