/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.language.base.internal.ProjectLayout;
import org.gradle.model.Defaults;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.ComponentSpec;

public class JarBinaryRules
extends RuleSource {
    @Defaults
    void configureJarBinaries(ComponentSpec jvmLibrary, final ProjectLayout projectLayout, final JavaToolChainRegistry toolChains) {
        jvmLibrary.getBinaries().withType(JarBinarySpecInternal.class).beforeEach((Action)new Action<JarBinarySpecInternal>(){

            public void execute(JarBinarySpecInternal jarBinary) {
                String libraryName = jarBinary.getId().getLibraryName();
                jarBinary.setClassesDir(jarBinary.getNamingScheme().getOutputDirectory(projectLayout.getBuildDir(), "classes"));
                jarBinary.setResourcesDir(jarBinary.getNamingScheme().getOutputDirectory(projectLayout.getBuildDir(), "resources"));
                File jarsDir = jarBinary.getNamingScheme().getOutputDirectory(projectLayout.getBuildDir(), "jars");
                jarBinary.setJarFile(new File(jarsDir, String.format("%s.jar", libraryName)));
                jarBinary.setApiJarFile(new File(jarsDir, String.format("api/%s.jar", libraryName)));
                jarBinary.setToolChain((JavaToolChain)toolChains.getForPlatform(jarBinary.getTargetPlatform()));
            }
        });
    }
}

