/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.model;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.language.base.internal.model.VariantsMetaData;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.VariantAspect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVariantsMetaData
implements VariantsMetaData {
    private final Map<String, Object> variantCoordinates;
    private final Set<String> allVariantAxes;
    private final Set<String> nonNullVariantAxes;
    private final Map<String, ModelType<?>> variantAxisTypes;

    private DefaultVariantsMetaData(Map<String, Object> variantCoordinates, Map<String, ModelType<?>> variantAxisTypes) {
        this.variantCoordinates = variantCoordinates;
        this.allVariantAxes = variantCoordinates.keySet();
        this.nonNullVariantAxes = ImmutableSet.copyOf(Maps.filterEntries(variantCoordinates, (Predicate)new Predicate<Map.Entry<String, Object>>(){

            public boolean apply(Map.Entry<String, Object> input) {
                return input.getValue() != null;
            }
        }).keySet());
        this.variantAxisTypes = variantAxisTypes;
    }

    public static VariantsMetaData extractFrom(BinarySpec spec, ModelSchemaStore schemaStore) {
        VariantAspect variantAspect;
        LinkedHashMap variants = Maps.newLinkedHashMap();
        ImmutableMap.Builder dimensionTypesBuilder = ImmutableMap.builder();
        ModelSchema schema = schemaStore.getSchema(((BinarySpecInternal)spec).getPublicType());
        if (schema instanceof StructSchema && (variantAspect = (VariantAspect)((StructSchema)schema).getAspect(VariantAspect.class)) != null) {
            for (ModelProperty<?> property : variantAspect.getDimensions()) {
                Object value = property.getPropertyValue((Object)spec);
                variants.put(property.getName(), value);
                dimensionTypesBuilder.put((Object)property.getName(), (Object)property.getType());
            }
        }
        return new DefaultVariantsMetaData(Collections.unmodifiableMap(variants), (Map<String, ModelType<?>>)dimensionTypesBuilder.build());
    }

    @Override
    public Set<String> getDeclaredVariantAxes() {
        return this.allVariantAxes;
    }

    @Override
    public Set<String> getNonNullVariantAxes() {
        return this.nonNullVariantAxes;
    }

    @Override
    public String getValueAsString(String variantAxis) {
        Object o = this.variantCoordinates.get(variantAxis);
        if (o instanceof Named) {
            return ((Named)o).getName();
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o == null ? null : o.toString();
    }

    @Override
    public <T extends Named> T getValueAsType(Class<T> clazz, String variantAxis) {
        return (T)((Named)this.variantCoordinates.get(variantAxis));
    }

    @Override
    public ModelType<?> getVariantAxisType(String variantAxis) {
        return this.variantAxisTypes.get(variantAxis);
    }
}

