/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.dsl;

import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;
import java.util.Objects;

public final class UnsupportedSpecializationException
extends RuntimeException {
    private static final long serialVersionUID = -2122892028296836269L;
    private final Node node;
    private final Node[] suppliedNodes;
    private final Object[] suppliedValues;

    public UnsupportedSpecializationException(Node node, Node[] suppliedNodes, Object ... suppliedValues) {
        super("Unexpected values provided for " + node + ": " + Arrays.toString(suppliedValues));
        Objects.requireNonNull(suppliedNodes, "The suppliedNodes parameter must not be null.");
        if (suppliedNodes.length != suppliedValues.length) {
            throw new IllegalArgumentException("The length of suppliedNodes must match the length of suppliedValues.");
        }
        this.node = node;
        this.suppliedNodes = suppliedNodes;
        this.suppliedValues = suppliedValues;
    }

    public Node getNode() {
        return this.node;
    }

    public Node[] getSuppliedNodes() {
        return this.suppliedNodes;
    }

    public Object[] getSuppliedValues() {
        return this.suppliedValues;
    }
}

