/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;

public class DeclarationContext {
    public final Visibility visibility;
    public final DefaultDefinee defaultDefinee;
    public static final DeclarationContext MODULE = new DeclarationContext(Visibility.PUBLIC, DefaultDefinee.LEXICAL_SCOPE);
    public static final DeclarationContext METHOD = new DeclarationContext(Visibility.PUBLIC, DefaultDefinee.LEXICAL_SCOPE);
    public static final DeclarationContext BLOCK = new DeclarationContext(null, DefaultDefinee.LEXICAL_SCOPE);
    public static final DeclarationContext TOP_LEVEL = new DeclarationContext(Visibility.PRIVATE, DefaultDefinee.LEXICAL_SCOPE);
    public static final DeclarationContext INSTANCE_EVAL = new DeclarationContext(Visibility.PUBLIC, DefaultDefinee.SINGLETON_CLASS);
    public static final DeclarationContext CLASS_EVAL = new DeclarationContext(Visibility.PUBLIC, DefaultDefinee.SELF);

    public DeclarationContext(Visibility visibility, DefaultDefinee defaultDefinee) {
        this.visibility = visibility;
        this.defaultDefinee = defaultDefinee;
    }

    private static Frame lookupVisibility(Frame frame) {
        while (frame != null) {
            Visibility visibility = RubyArguments.getDeclarationContext((Object[])frame.getArguments()).visibility;
            if (visibility != null) {
                return frame;
            }
            frame = RubyArguments.getDeclarationFrame(frame.getArguments());
        }
        throw new UnsupportedOperationException("No declaration frame with visibility found");
    }

    public static Visibility findVisibility(Frame frame) {
        Frame visibilityFrame = DeclarationContext.lookupVisibility(frame);
        return RubyArguments.getDeclarationContext((Object[])visibilityFrame.getArguments()).visibility;
    }

    public static void changeVisibility(Frame frame, Visibility newVisibility) {
        Frame visibilityFrame = DeclarationContext.lookupVisibility(frame);
        DeclarationContext oldDeclarationContext = RubyArguments.getDeclarationContext(visibilityFrame.getArguments());
        if (newVisibility != oldDeclarationContext.visibility) {
            RubyArguments.setDeclarationContext(visibilityFrame.getArguments(), oldDeclarationContext.withVisibility(newVisibility));
        }
    }

    private DeclarationContext withVisibility(Visibility visibility) {
        assert (visibility != null);
        return new DeclarationContext(visibility, this.defaultDefinee);
    }

    public DynamicObject getModuleToDefineMethods(VirtualFrame frame, RubyContext context, SingletonClassNode singletonClassNode) {
        switch (this.defaultDefinee) {
            case LEXICAL_SCOPE: {
                return RubyArguments.getMethod(frame.getArguments()).getSharedMethodInfo().getLexicalScope().getLiveModule();
            }
            case SINGLETON_CLASS: {
                Object self = RubyArguments.getSelf(frame.getArguments());
                return singletonClassNode.executeSingletonClass(self);
            }
            case SELF: {
                return (DynamicObject)RubyArguments.getSelf(frame.getArguments());
            }
        }
        throw new UnsupportedOperationException();
    }

    private static enum DefaultDefinee {
        LEXICAL_SCOPE,
        SINGLETON_CLASS,
        SELF;

    }
}

