/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.languagetool.languagemodel.LanguageModel;

public class LuceneLanguageModel
implements LanguageModel {
    private static final Map<File, LuceneSearcher> dirToSearcherMap = new HashMap<File, LuceneSearcher>();
    private final List<File> indexes = new ArrayList<File>();
    private final Map<Integer, LuceneSearcher> luceneSearcherMap = new HashMap<Integer, LuceneSearcher>();
    private final File topIndexDir;

    public static void validateDirectory(File topIndexDir) {
        if (!topIndexDir.exists() || !topIndexDir.isDirectory()) {
            throw new RuntimeException("Not found or is not a directory: " + topIndexDir);
        }
        ArrayList<String> dirs = new ArrayList<String>();
        for (String name : topIndexDir.list()) {
            if (!name.matches("[123]grams")) continue;
            dirs.add(name);
        }
        if (dirs.size() == 0) {
            throw new RuntimeException("Directory must contain at least '1grams', '2grams', and '3grams': " + topIndexDir.getAbsolutePath());
        }
        if (dirs.size() < 3) {
            throw new RuntimeException("Expected at least '1grams', '2grams', and '3grams' sub directories but only got " + dirs + " in " + topIndexDir.getAbsolutePath());
        }
    }

    public LuceneLanguageModel(File topIndexDir) throws IOException {
        LuceneLanguageModel.validateDirectory(topIndexDir);
        this.topIndexDir = topIndexDir;
        this.addIndex(topIndexDir, 1);
        this.addIndex(topIndexDir, 2);
        this.addIndex(topIndexDir, 3);
        this.addIndex(topIndexDir, 4);
        if (this.luceneSearcherMap.size() == 0) {
            throw new RuntimeException("No directories '1grams' ... '3grams' found in " + topIndexDir);
        }
    }

    private void addIndex(File topIndexDir, int ngramSize) throws IOException {
        File indexDir = new File(topIndexDir, ngramSize + "grams");
        if (indexDir.exists() && indexDir.isDirectory()) {
            if (this.luceneSearcherMap.containsKey(ngramSize)) {
                throw new RuntimeException("Searcher for ngram size " + ngramSize + " already exists");
            }
            this.luceneSearcherMap.put(ngramSize, this.getCachedLuceneSearcher(indexDir));
            this.indexes.add(indexDir);
        }
    }

    @Override
    public long getCount(List<String> tokens) {
        Objects.requireNonNull(tokens);
        Term term = new Term("ngram", StringUtils.join(tokens, (String)" "));
        return this.getCount(term, this.getLuceneSearcher(tokens.size()));
    }

    @Override
    public long getCount(String token1) {
        Objects.requireNonNull(token1);
        return this.getCount(Arrays.asList(token1));
    }

    @Override
    public long getCount(String token1, String token2) {
        Objects.requireNonNull(token1);
        Objects.requireNonNull(token2);
        return this.getCount(Arrays.asList(token1, token2));
    }

    @Override
    public long getCount(String token1, String token2, String token3) {
        Objects.requireNonNull(token1);
        Objects.requireNonNull(token2);
        Objects.requireNonNull(token3);
        return this.getCount(Arrays.asList(token1, token2, token3));
    }

    @Override
    public long getTotalTokenCount() {
        LuceneSearcher luceneSearcher = this.getLuceneSearcher(1);
        try {
            RegexpQuery query = new RegexpQuery(new Term("totalTokenCount", ".*"));
            TopDocs docs = luceneSearcher.searcher.search((Query)query, 1000);
            if (docs.totalHits == 0) {
                throw new RuntimeException("Expected 'totalTokenCount' meta documents not found in 1grams index");
            }
            if (docs.totalHits > 1000) {
                throw new RuntimeException("Did not expect more than 1000 'totalTokenCount' meta documents: " + docs.totalHits);
            }
            long result = 0L;
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                result += Long.parseLong(luceneSearcher.reader.document(scoreDoc.doc).get("totalTokenCount"));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected LuceneSearcher getLuceneSearcher(int ngramSize) {
        LuceneSearcher luceneSearcher = this.luceneSearcherMap.get(ngramSize);
        if (luceneSearcher == null) {
            throw new RuntimeException("No " + ngramSize + "grams directory found in " + this.topIndexDir);
        }
        return luceneSearcher;
    }

    private LuceneSearcher getCachedLuceneSearcher(File indexDir) throws IOException {
        LuceneSearcher luceneSearcher = dirToSearcherMap.get(indexDir);
        if (luceneSearcher == null) {
            LuceneSearcher newSearcher = new LuceneSearcher(indexDir);
            dirToSearcherMap.put(indexDir, newSearcher);
            return newSearcher;
        }
        return luceneSearcher;
    }

    private long getCount(Term term, LuceneSearcher luceneSearcher) {
        try {
            TopDocs docs = luceneSearcher.searcher.search((Query)new TermQuery(term), 1);
            if (docs.totalHits > 0) {
                int docId = docs.scoreDocs[0].doc;
                return Long.parseLong(luceneSearcher.reader.document(docId).get("count"));
            }
            return 0L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        for (LuceneSearcher searcher : this.luceneSearcherMap.values()) {
            try {
                searcher.reader.close();
                searcher.directory.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return this.indexes.toString();
    }

    protected static class LuceneSearcher {
        final FSDirectory directory;
        final IndexReader reader;
        final IndexSearcher searcher;

        private LuceneSearcher(File indexDir) throws IOException {
            Path path = indexDir.toPath();
            if (Files.isSymbolicLink(path)) {
                path = indexDir.getCanonicalFile().toPath();
            }
            this.directory = FSDirectory.open((Path)path);
            this.reader = DirectoryReader.open((Directory)this.directory);
            this.searcher = new IndexSearcher(this.reader);
        }

        public IndexReader getReader() {
            return this.reader;
        }
    }
}

