/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.font.CMap;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;

public class PDGlyphs
implements IAttributeSupport {
    private final AttributeMap attributes = new AttributeMap();
    private final int codepoint;
    private final PDFont font;
    private Boolean whitespace;
    private float width;

    public PDGlyphs(PDFont pDFont, int n) {
        this.font = pDFont;
        this.codepoint = n;
        this.width = pDFont.getGlyphWidthEncoded(n);
    }

    public double getAscent() {
        return this.font.getFontDescriptor().getAscent();
    }

    public final Object getAttribute(Object object) {
        return this.attributes.getAttribute(object);
    }

    public char[] getChars() {
        CMap cMap = this.font.getToUnicode();
        if (cMap == null) {
            return new char[]{(char)this.font.getEncoding().getDecoded(this.codepoint)};
        }
        return cMap.getChars(this.codepoint);
    }

    public int getCodepoint() {
        return this.codepoint;
    }

    public int getDecoded() {
        return this.font.getEncoding().getDecoded(this.codepoint);
    }

    public double getDescent() {
        return this.font.getFontDescriptor().getDescent();
    }

    public PDFont getFont() {
        return this.font;
    }

    public String getGlyphName() {
        return this.font.getEncoding().getGlyphName(this.codepoint);
    }

    public int getUnicode() {
        try {
            CMap cMap = this.font.getToUnicode();
            if (cMap == null) {
                return this.font.getEncoding().getDecoded(this.codepoint);
            }
            return cMap.getDecoded(this.codepoint);
        }
        catch (Exception exception) {
            return this.font.getEncoding().getDecoded(this.codepoint);
        }
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isWhitespace() {
        if (this.whitespace != null) {
            return this.whitespace;
        }
        int n = this.getDecoded();
        this.whitespace = n == 0 || n == 32;
        return this.whitespace;
    }

    public final Object removeAttribute(Object object) {
        return this.attributes.removeAttribute(object);
    }

    public void reset() {
        this.width = this.font.getGlyphWidthEncoded(this.codepoint);
    }

    public final Object setAttribute(Object object, Object object2) {
        return this.attributes.setAttribute(object, object2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("glyph ");
        stringBuilder.append((char)this.getUnicode());
        stringBuilder.append(", cp ");
        stringBuilder.append(this.codepoint);
        stringBuilder.append(", uc ");
        stringBuilder.append(this.getUnicode());
        return stringBuilder.toString();
    }
}

