/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.STXRefSubsection;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.Iterator;

public abstract class AbstractXRefWriter
implements IXRefEntryVisitor {
    private COSWriter cosWriter;
    private IRandomAccess randomAccess;
    public static final byte[] STARTXREF = "startxref".getBytes();

    protected IRandomAccess getRandomAccess() {
        return this.randomAccess;
    }

    protected void setRandomAccess(IRandomAccess iRandomAccess) {
        this.randomAccess = iRandomAccess;
    }

    public AbstractXRefWriter(COSWriter cOSWriter) {
        this.cosWriter = cOSWriter;
    }

    protected void finish(STXRefSection sTXRefSection) throws IOException {
        this.writeStartXRef(sTXRefSection.getOffset());
    }

    protected void writeStartXRef(long l) throws IOException {
        this.getCosWriter().write(STARTXREF);
        this.getCosWriter().writeEOL();
        this.getCosWriter().write(StringTools.toByteArray((String)Long.toString(l)));
        this.getCosWriter().writeEOL();
    }

    public COSWriter getCosWriter() {
        return this.cosWriter;
    }

    protected abstract byte[] getTypeCompressed();

    protected abstract byte[] getTypeFree();

    protected abstract byte[] getTypeOccupied();

    protected void initialize(STXRefSection sTXRefSection) throws IOException {
        sTXRefSection.setOffset(this.getCosWriter().getRandomAccess().getOffset());
        int n = sTXRefSection.getMaxObjectNumber();
        if (sTXRefSection.getPrevious() != null) {
            n = Math.max(sTXRefSection.getPrevious().getSize(), n);
        }
        sTXRefSection.setSize(n);
    }

    protected void visitFromSection(STXRefSection sTXRefSection) throws IOException {
        Iterator iterator = sTXRefSection.subsectionIterator();
        while (iterator.hasNext()) {
            STXRefSubsection sTXRefSubsection = (STXRefSubsection)iterator.next();
            this.visitFromSubsection(sTXRefSubsection);
            Iterator iterator2 = sTXRefSubsection.getEntries().iterator();
            while (iterator2.hasNext()) {
                try {
                    ((STXRefEntry)iterator2.next()).accept(this);
                }
                catch (XRefEntryVisitorException xRefEntryVisitorException) {
                    throw (IOException)xRefEntryVisitorException.getCause();
                }
            }
        }
    }

    @Override
    public void visitFromCompressed(STXRefEntryCompressed sTXRefEntryCompressed) throws XRefEntryVisitorException {
        try {
            this.write(sTXRefEntryCompressed.getStreamObjectNumber(), sTXRefEntryCompressed.getIndex(), this.getTypeCompressed());
        }
        catch (IOException iOException) {
            throw new XRefEntryVisitorException(iOException);
        }
    }

    @Override
    public void visitFromFree(STXRefEntryFree sTXRefEntryFree) throws XRefEntryVisitorException {
        try {
            this.write(sTXRefEntryFree.getNextFreeObjectNumber(), sTXRefEntryFree.getGenerationNumber(), this.getTypeFree());
        }
        catch (IOException iOException) {
            throw new XRefEntryVisitorException(iOException);
        }
    }

    @Override
    public void visitFromOccupied(STXRefEntryOccupied sTXRefEntryOccupied) throws XRefEntryVisitorException {
        try {
            this.write((int)sTXRefEntryOccupied.getOffset(), sTXRefEntryOccupied.getGenerationNumber(), this.getTypeOccupied());
        }
        catch (IOException iOException) {
            throw new XRefEntryVisitorException(iOException);
        }
    }

    protected abstract void visitFromSubsection(STXRefSubsection var1) throws IOException;

    protected abstract void write(int var1, int var2, byte[] var3) throws IOException;

    public void writeXRef(STXRefSection sTXRefSection) throws IOException {
        this.initialize(sTXRefSection);
        this.visitFromSection(sTXRefSection);
        this.finish(sTXRefSection);
    }
}

