/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.dom.PACKAGE;
import de.intarsys.tools.file.Loader;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class SchemaDirectory
implements LSResourceResolver {
    private static final Logger Log = PACKAGE.Log;
    private final File schemaDir;
    private final String rootSchema;
    private Schema schema;

    public SchemaDirectory(File file) {
        this(file, null);
    }

    public SchemaDirectory(File file, String string) {
        this.schemaDir = file;
        this.rootSchema = string;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Source[] getSources() throws IOException {
        return new SchemaFinder().getSchemaSources();
    }

    private String resolveFileName(String string, String string2) {
        String string3;
        String string4 = "";
        if (string.toLowerCase().startsWith("http://") && (string3 = new File(string.substring(7)).getParent()) != null) {
            string4 = String.valueOf(string3) + File.separator;
        }
        return String.valueOf(string4) + this.systemIdToFileName(string2);
    }

    @Override
    public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
        String string6 = this.resolveFileName(string5, string4);
        File file = new File(this.schemaDir, string6);
        if (file.canRead() && file.isFile()) {
            SchemaLSInput schemaLSInput = new SchemaLSInput(string3, string4, string5);
            try {
                schemaLSInput.setByteStream(new FileInputStream(file));
                return schemaLSInput;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.log(Level.WARNING, fileNotFoundException.getLocalizedMessage(), fileNotFoundException);
            }
        }
        Log.log(Level.WARNING, "failed resolving schema type '" + string + "', namespaceURI '" + string2 + "', baseURI '" + string5 + "', systemId '" + string4 + "'");
        return null;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    private String systemIdToFileName(String string) {
        if (string.startsWith("http://")) {
            return string.substring(7);
        }
        return string;
    }

    class SchemaFinder
    extends Loader {
        private final ArrayList<Source> xsdSources = new ArrayList();

        @Override
        protected boolean basicLoadFile(File file, boolean bl, String string) {
            if (file.getName().toLowerCase().endsWith(".xsd")) {
                this.xsdSources.add(new StreamSource(file));
            }
            return true;
        }

        public Source[] getSchemaSources() throws IOException {
            this.xsdSources.clear();
            if (StringTools.isEmpty(SchemaDirectory.this.rootSchema)) {
                this.load(SchemaDirectory.this.schemaDir, true, true);
            } else {
                this.load(SchemaDirectory.this.schemaDir, SchemaDirectory.this.rootSchema, true, false);
            }
            return this.xsdSources.toArray(new Source[this.xsdSources.size()]);
        }
    }

    static class SchemaLSInput
    implements LSInput {
        private String publicId;
        private String systemId;
        private String baseURI;
        private String encoding;
        private String stringData;
        private Reader characterStream;
        private boolean certifiedText;
        private InputStream byteStream;

        public SchemaLSInput(String string, String string2, String string3) {
            this.publicId = string;
            this.systemId = string2;
            this.baseURI = string3;
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public InputStream getByteStream() {
            return new InputStream(){

                @Override
                public void close() throws IOException {
                    SchemaLSInput.this.byteStream.close();
                }

                @Override
                public int read() throws IOException {
                    return SchemaLSInput.this.byteStream.read();
                }
            };
        }

        @Override
        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        @Override
        public Reader getCharacterStream() {
            return this.characterStream;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setBaseURI(String string) {
            this.baseURI = string;
        }

        @Override
        public void setByteStream(InputStream inputStream) {
            this.byteStream = inputStream;
        }

        @Override
        public void setCertifiedText(boolean bl) {
            this.certifiedText = bl;
        }

        @Override
        public void setCharacterStream(Reader reader) {
            this.characterStream = reader;
        }

        @Override
        public void setEncoding(String string) {
            this.encoding = string;
        }

        @Override
        public void setPublicId(String string) {
            this.publicId = string;
        }

        @Override
        public void setStringData(String string) {
            this.stringData = string;
        }

        @Override
        public void setSystemId(String string) {
            this.systemId = string;
        }
    }
}

