/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.dom.ElementConfigurationException;
import de.intarsys.tools.dom.ElementTools;
import de.intarsys.tools.monitor.MemberMonitorTrace;
import de.intarsys.tools.monitor.Monitor;
import de.intarsys.tools.monitor.MonitorTrace;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.w3c.dom.Element;

public class MemberMonitor
extends Monitor {
    private Class clazz;
    private Method method;
    private Field field;

    public MemberMonitor() {
    }

    public MemberMonitor(String string) {
        super(string);
    }

    public MemberMonitor(String string, Class clazz, Field field) {
        super(string);
        this.clazz = clazz;
        this.field = field;
    }

    public MemberMonitor(String string, Class clazz, Method method) {
        super(string);
        this.clazz = clazz;
        this.method = method;
    }

    @Override
    public void configure(Element element) throws ElementConfigurationException {
        String string;
        super.configure(element);
        String string2 = ElementTools.getPathString(element, "monitoredclass", null);
        if (string2 == null) {
            throw new ElementConfigurationException("<monitoredclass> may not be null");
        }
        try {
            this.clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ElementConfigurationException(String.valueOf(string2) + " not found");
        }
        catch (SecurityException securityException) {
            throw new ElementConfigurationException(String.valueOf(string2) + " not permitted");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ElementConfigurationException(String.valueOf(string2) + " not instantiable");
        }
        String string3 = ElementTools.getPathString(element, "monitoredmethod", null);
        if (string3 != null) {
            try {
                this.method = this.getClazz().getMethod(string3, new Class[0]);
            }
            catch (SecurityException securityException) {
                throw new ElementConfigurationException(String.valueOf(string3) + " not permitted");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ElementConfigurationException(String.valueOf(string3) + " not instantiable");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ElementConfigurationException(String.valueOf(string3) + " not found");
            }
        }
        if ((string = ElementTools.getPathString(element, "monitoredfield", null)) != null) {
            try {
                this.field = this.getClazz().getField(string);
            }
            catch (SecurityException securityException) {
                throw new ElementConfigurationException(String.valueOf(string) + " not permitted");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ElementConfigurationException(String.valueOf(string) + " not instantiable");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new ElementConfigurationException(String.valueOf(string) + " not found");
            }
        }
        if (this.field == null && this.method == null) {
            throw new ElementConfigurationException("field or method must be set");
        }
    }

    @Override
    protected MemberMonitorTrace createMonitorTrace() {
        return new MemberMonitorTrace(this);
    }

    @Override
    protected void doCalculation(MonitorTrace monitorTrace) {
        if (monitorTrace.getStart() < this.statistic.min) {
            this.statistic.min = monitorTrace.getStart();
        }
        if (monitorTrace.getStop() < this.statistic.min) {
            this.statistic.min = monitorTrace.getStop();
        }
        if (monitorTrace.getStart() > this.statistic.max) {
            this.statistic.max = monitorTrace.getStart();
        }
        if (monitorTrace.getStop() > this.statistic.max) {
            this.statistic.max = monitorTrace.getStop();
        }
        this.statistic.total = this.last - this.first;
        this.statistic.avg = (this.statistic.avg * this.statistic.count + monitorTrace.getStop()) / (this.statistic.count + 1L);
        ++this.statistic.count;
    }

    protected Class getClazz() {
        return this.clazz;
    }

    protected Field getField() {
        return this.field;
    }

    protected Method getMethod() {
        return this.method;
    }
}

