/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.renderers;

import java.awt.Color;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.pdfsam.guiclient.commons.models.AbstractPdfSelectionTableModel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class JPdfSelectionTableRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = -4780112050203181493L;
    private boolean fullAccessRequired = true;

    public JPdfSelectionTableRenderer() {
    }

    public JPdfSelectionTableRenderer(boolean fullAccessRequired) {
        this.fullAccessRequired = fullAccessRequired;
    }

    public boolean isFullAccessRequired() {
        return this.fullAccessRequired;
    }

    public void setFullAccessRequired(boolean fullAccessRequired) {
        this.fullAccessRequired = fullAccessRequired;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setOpaque(true);
        this.setIcon(null);
        this.setFont(table.getFont());
        this.setToolTipText(null);
        boolean loadedWithErrors = ((AbstractPdfSelectionTableModel)table.getModel()).getRow(row).isLoadedWithErrors();
        boolean syntaxErrors = ((AbstractPdfSelectionTableModel)table.getModel()).getRow(row).isSyntaxErrors();
        boolean fullPermission = ((AbstractPdfSelectionTableModel)table.getModel()).getRow(row).isFullPermission();
        boolean encrypted = ((AbstractPdfSelectionTableModel)table.getModel()).getRow(row).isEncrypted();
        if (column == 0) {
            this.setFont(table.getTableHeader().getFont());
            this.setBackground(table.getTableHeader().getBackground());
            this.setForeground(table.getTableHeader().getForeground());
        } else {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (loadedWithErrors) {
                this.setBackground(new Color(222, 189, 189));
                if (column == 1) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/images/erroronload.png")));
                }
            } else if (syntaxErrors || this.fullAccessRequired && !fullPermission) {
                this.setBackground(Color.YELLOW);
            }
        }
        if (column == 4) {
            if (value != null && value.toString().length() > 0) {
                this.setText("**********");
            } else {
                this.setText("");
            }
        } else if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("");
        }
        if (column == 1 && encrypted) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/images/encrypted.png")));
        }
        if (column == 0) {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        } else if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        if (syntaxErrors || loadedWithErrors) {
            String toolTip = "<html><body>";
            if (syntaxErrors) {
                toolTip = toolTip + "<b>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"The cross reference table cantained some error and has been rebuilt") + ".";
            }
            if (loadedWithErrors) {
                toolTip = toolTip + "<b>" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"An error occured while loading the document") + ".";
            }
            toolTip = toolTip + "</body></html>";
            this.setToolTipText(toolTip);
        }
        return this;
    }
}

