/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.StringStyle;
import com.baselet.control.enums.FormatLabels;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class FormattedFont {
    private static Integer underline;
    private static Float bold;
    private static Float italic;
    private String string;
    private final AttributedString atrString;
    private final FontRenderContext fontRenderContext;
    private final TextLayout textLayout;

    public FormattedFont(String text, double fontSize, Font font, FontRenderContext fontRenderContext) {
        this.string = FormattedFont.setFormatAndRemoveLabels(text);
        this.atrString = new AttributedString(this.string);
        this.fontRenderContext = fontRenderContext;
        this.atrString.addAttribute(TextAttribute.FAMILY, font.getFamily());
        this.atrString.addAttribute(TextAttribute.SIZE, fontSize);
        this.atrString.addAttribute(TextAttribute.WEIGHT, bold);
        this.atrString.addAttribute(TextAttribute.POSTURE, italic);
        this.atrString.addAttribute(TextAttribute.UNDERLINE, underline, 0, this.string.length());
        this.textLayout = new TextLayout(this.getAttributedCharacterIterator(), fontRenderContext);
    }

    public String getString() {
        return this.string;
    }

    public void replaceFirstAndLastSpaceWithDot() {
        if (this.string.startsWith(" ")) {
            this.string = "." + this.string.substring(1);
        }
        if (this.string.endsWith(" ")) {
            this.string = String.valueOf(this.string.substring(this.string.length() - 1)) + ".";
        }
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public AttributedCharacterIterator getAttributedCharacterIterator() {
        return this.atrString.getIterator();
    }

    private static String setFormatAndRemoveLabels(String s) {
        StringStyle style = StringStyle.analyzeFormatLabels(s);
        underline = style.getFormat().contains((Object)FormatLabels.UNDERLINE) ? TextAttribute.UNDERLINE_ON : Integer.valueOf(-1);
        bold = style.getFormat().contains((Object)FormatLabels.BOLD) ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR;
        italic = style.getFormat().contains((Object)FormatLabels.ITALIC) ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR;
        return style.getStringWithoutMarkup();
    }

    public double getWidth() {
        return this.textLayout.getVisibleAdvance();
    }

    public double getHeight() {
        return this.textLayout.getBounds().getHeight();
    }
}

