/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.elements;

import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.elementnew.plot.drawer.PlotDrawHandler;
import com.baselet.element.elementnew.plot.drawer.PlotGridDrawConfig;
import com.baselet.element.elementnew.plot.parser.DataSet;
import com.baselet.element.elementnew.plot.parser.ParserException;
import com.baselet.element.elementnew.plot.parser.PlotConstants;
import com.baselet.element.elementnew.plot.parser.PlotState;
import java.util.List;

public abstract class AbstractPlot {
    protected PlotDrawHandler plot;
    protected PlotGridDrawConfig plotDrawConfig;
    protected PlotState plotState;
    private final Integer xPosition;
    private final Integer yPosition;

    public AbstractPlot(DrawHandler drawHandler, PlotGridDrawConfig plotGridDrawConfig, PlotState plotState, int n, int n2) {
        this.plotDrawConfig = plotGridDrawConfig;
        this.plotState = plotState;
        this.xPosition = n;
        this.yPosition = n2;
        this.plot = new PlotDrawHandler(drawHandler, plotGridDrawConfig.getRealSize());
        this.setupAxis();
        this.setupAbstractPlot();
    }

    public Integer getPlotLineNr() {
        return this.plotState.getPlotLineNr();
    }

    public Integer getXPosition() {
        return this.xPosition;
    }

    public Integer getYPosition() {
        return this.yPosition;
    }

    private void setupAxis() {
        this.plot.getAxisConfig().enableDescAxis(this.plotState.getValueListValidated(PlotConstants.AxisShow.getKeyDescAxis(), PlotConstants.toStringList(this.defaultDescAxisShow()), PlotConstants.toStringList(PlotConstants.AxisShow.values()), false));
        this.plot.getAxisConfig().enableValueAxis(this.plotState.getValueListValidated(PlotConstants.AxisShow.getKeyValueAxis(), PlotConstants.toStringList(this.defaultValueAxisShow()), PlotConstants.toStringList(PlotConstants.AxisShow.values()), false), this.plotState.getValueListValidated(PlotConstants.AxisList.getKey(), PlotConstants.toStringList(this.defaultValueAxisList()), PlotConstants.toStringList(PlotConstants.AxisList.values()), true));
    }

    private void setupAbstractPlot() {
        DataSet dataSet = this.plotState.getDataSet();
        dataSet.setInvert(this.plotState.getValueAsBoolean("data.invert", PlotConstants.DATA_INVERT_DEFAULT));
        String[] stringArray = dataSet.titleRow();
        String[] stringArray2 = dataSet.titleCol();
        Double[][] doubleArray = dataSet.data();
        List<String> list = this.plotState.getValueList("colors", PlotConstants.COLORS_DEFAULT);
        for (String string : list) {
            if (ColorOwn.forStringOrNull(string, ColorOwn.Transparency.FOREGROUND) != null) continue;
            throw new ParserException("Unknown color: " + string + "(line: " + this.plotState.getLine("colors") + ")");
        }
        if (doubleArray.length > this.getMaxAllowedValueRows()) {
            throw new ParserException("The dataset (line: " + this.plotState.getDataSet().getLineNr() + ") has too many rows for the plot (line: " + this.plotState.getPlotLineNr() + ")");
        }
        this.plot.setValues(stringArray, stringArray2, doubleArray, list);
        this.setMinMaxValue("value.min");
        this.setMinMaxValue("value.max");
    }

    private void setMinMaxValue(String string) {
        String string2 = this.plotState.getValue(string, null);
        if (string2 != null) {
            try {
                if (string.equals("value.min")) {
                    if (string2.equals("all")) {
                        this.plot.setMinValue(this.plotDrawConfig.getMinValue());
                    } else {
                        this.plot.setMinValue(Double.valueOf(string2));
                    }
                } else if (string.equals("value.max")) {
                    if (string2.equals("all")) {
                        this.plot.setMaxValue(this.plotDrawConfig.getMaxValue());
                    } else {
                        this.plot.setMaxValue(Double.valueOf(string2));
                    }
                }
            }
            catch (Exception exception) {
                throw new ParserException(string, string2, this.plotState.getLine(string), exception.getMessage());
            }
        }
    }

    protected void setPlotPosition(int n, int n2) {
        if (this.xPosition > n) {
            throw new ParserException("The x coordinate is invalid. PlotGrid width is too small");
        }
        if (this.yPosition > n2) {
            throw new ParserException("The y coordinate is invalid. PlotGrid height is too small");
        }
        double d = (double)this.plotDrawConfig.getRealSize().width / (double)n;
        double d2 = (double)this.plotDrawConfig.getRealSize().height / (double)n2;
        int n3 = (int)(d * (double)this.xPosition.intValue());
        int n4 = (int)(d * (double)(n - this.xPosition - 1));
        int n5 = (int)(d2 * (double)this.yPosition.intValue());
        int n6 = (int)(d2 * (double)(n2 - this.yPosition - 1));
        this.plot.getCanvas().setBorder(n3, n5, n4, n6, 15);
    }

    public abstract void plot(int var1, int var2);

    protected abstract List<PlotConstants.AxisShow> defaultDescAxisShow();

    protected abstract List<PlotConstants.AxisShow> defaultValueAxisShow();

    protected abstract List<PlotConstants.AxisList> defaultValueAxisList();

    protected abstract int getMaxAllowedValueRows();
}

