/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.plugin;

import com.baselet.control.Main;
import com.baselet.control.config.handler.ConfigHandler;
import com.baselet.control.enums.Program;
import com.baselet.control.enums.RuntimeType;
import com.baselet.control.util.Path;
import com.baselet.gui.CurrentGui;
import com.baselet.plugin.gui.EclipseGUI;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MainPlugin
extends AbstractUIPlugin {
    private static String pluginId;
    private static MainPlugin plugin;

    public static String getPluginId() {
        return pluginId;
    }

    public MainPlugin() {
        Program.getInstance().setRuntimeType(RuntimeType.ECLIPSE_PLUGIN);
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initHomeProgramPath();
        Main.getInstance().initLogger();
        this.readBundleManifestInfo();
        ConfigHandler.loadConfig();
        Main.getInstance().init(new EclipseGUI(Main.getInstance()));
    }

    private void initHomeProgramPath() throws IOException {
        String path = null;
        URL homeURL = MainPlugin.getURL();
        path = FileLocator.toFileURL((URL)homeURL).toString().substring("file:/".length());
        if (File.separator.equals("/")) {
            path = "/" + path;
        }
        Path.setHomeProgram(path);
    }

    private void readBundleManifestInfo() {
        Dictionary headers = MainPlugin.getDefault().getBundle().getHeaders();
        pluginId = MainPlugin.getDefault().getBundle().getSymbolicName();
        Program.getInstance().init((String)headers.get("Bundle-Version"));
    }

    public void stop(BundleContext context) throws Exception {
        CurrentGui.getInstance().getGui().closeWindow();
        plugin = null;
        super.stop(context);
    }

    public static MainPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return MainPlugin.imageDescriptorFromPlugin((String)pluginId, (String)path);
    }

    public static URL getURL() {
        return FileLocator.find((Bundle)MainPlugin.getDefault().getBundle(), (IPath)new org.eclipse.core.runtime.Path("/"), null);
    }
}

