/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.ascan.ActiveScan;
import org.zaproxy.zap.extension.ascan.ActiveScanTableModel;
import org.zaproxy.zap.extension.ascan.AttackScan;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.ScanProgressDialog;
import org.zaproxy.zap.model.ScanController;
import org.zaproxy.zap.model.ScanListenner2;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.ScanPanel2;
import org.zaproxy.zap.view.table.HistoryReferencesTable;

public class ActiveScanPanel
extends ScanPanel2<ActiveScan, ScanController<ActiveScan>>
implements ScanListenner2,
ScannerListener {
    private static final Logger LOGGER = Logger.getLogger(ActiveScanPanel.class);
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final String PANEL_NAME = "ascan";
    public static final String MESSAGE_CONTAINER_NAME = "ActiveScanMessageContainer";
    private static final ActiveScanTableModel EMPTY_RESULTS_MODEL = new ActiveScanTableModel();
    private ExtensionActiveScan extension;
    private JScrollPane jScrollPane;
    private HistoryReferencesTable messagesTable;
    private JButton policyButton = null;
    private JButton scanButton = null;
    private JButton progressButton;
    private JLabel numRequests;

    public ActiveScanPanel(ExtensionActiveScan extensionActiveScan) {
        super(PANEL_NAME, new ImageIcon(ActiveScanPanel.class.getResource("/resource/icon/16/093.png")), extensionActiveScan, null);
        this.extension = extensionActiveScan;
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8 | 1, false));
        this.setMnemonic(Constant.messages.getChar("ascan.panel.mnemonic"));
    }

    @Override
    protected int addToolBarElements(JToolBar jToolBar, ScanPanel2.Location location, int n) {
        if (ScanPanel2.Location.start.equals((Object)location)) {
            jToolBar.add((Component)this.getPolicyManagerButton(), this.getGBC(n++, 0));
        }
        if (ScanPanel2.Location.beforeProgressBar.equals((Object)location)) {
            jToolBar.add((Component)this.getProgressButton(), this.getGBC(n++, 0));
        }
        if (ScanPanel2.Location.afterProgressBar.equals((Object)location)) {
            jToolBar.add((Component)new JLabel(Constant.messages.getString("ascan.toolbar.requests.label")), this.getGBC(n++, 0));
            jToolBar.add((Component)this.getNumRequests(), this.getGBC(n++, 0));
        }
        return n;
    }

    private JButton getPolicyManagerButton() {
        if (this.policyButton == null) {
            this.policyButton = new JButton();
            this.policyButton.setToolTipText(Constant.messages.getString("menu.analyse.scanPolicy"));
            this.policyButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ActiveScanPanel.class.getResource("/resource/icon/fugue/equalizer.png"))));
            this.policyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActiveScanPanel.this.extension.showPolicyManagerDialog();
                }
            });
        }
        return this.policyButton;
    }

    @Override
    public JButton getNewScanButton() {
        if (this.scanButton == null) {
            this.scanButton = new JButton(Constant.messages.getString("ascan.toolbar.button.new"));
            this.scanButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ActiveScanPanel.class.getResource("/resource/icon/16/093.png"))));
            this.scanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActiveScanPanel.this.extension.showCustomScanDialog(null);
                }
            });
        }
        return this.scanButton;
    }

    private JButton getProgressButton() {
        if (this.progressButton == null) {
            this.progressButton = new JButton();
            this.progressButton.setEnabled(false);
            this.progressButton.setToolTipText(Constant.messages.getString("ascan.toolbar.button.progress"));
            this.progressButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ActiveScanPanel.class.getResource("/resource/icon/fugue/system-monitor.png"))));
            this.progressButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActiveScanPanel.this.showScanProgressDialog();
                }
            });
        }
        return this.progressButton;
    }

    private JLabel getNumRequests() {
        if (this.numRequests == null) {
            this.numRequests = new JLabel();
        }
        return this.numRequests;
    }

    private void showScanProgressDialog() {
        ActiveScan activeScan = (ActiveScan)this.getSelectedScanner();
        if (activeScan != null) {
            ScanProgressDialog scanProgressDialog = new ScanProgressDialog((Frame)View.getSingleton().getMainFrame(), activeScan.getDisplayName(), this.extension);
            scanProgressDialog.setActiveScan(activeScan);
            scanProgressDialog.setVisible(true);
        }
    }

    @Override
    public void clearFinishedScans() {
        if (this.extension.getScannerParam().isPromptToClearFinishedScans()) {
            int n = View.getSingleton().showConfirmDontPromptDialog(View.getSingleton().getMainFrame(), Constant.messages.getString("ascan.toolbar.confirm.clear"));
            if (View.getSingleton().isDontPromptLastDialogChosen()) {
                this.extension.getScannerParam().setPromptToClearFinishedScans(false);
            }
            if (n != 0) {
                return;
            }
        }
        super.clearFinishedScans();
    }

    @Override
    protected JScrollPane getWorkPanel() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView((Component)((Object)this.getMessagesTable()));
        }
        return this.jScrollPane;
    }

    private void resetMessagesTable() {
        this.getMessagesTable().setModel(EMPTY_RESULTS_MODEL);
    }

    private HistoryReferencesTable getMessagesTable() {
        if (this.messagesTable == null) {
            this.messagesTable = new HistoryReferencesTable(EMPTY_RESULTS_MODEL);
            this.messagesTable.setName(MESSAGE_CONTAINER_NAME);
            this.messagesTable.setAutoCreateColumnsFromModel(false);
        }
        return this.messagesTable;
    }

    @Override
    public void switchView(final ActiveScan activeScan) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ActiveScanPanel.this.switchView(activeScan);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                LOGGER.error((Object)("Failed to switch view: " + exception.getMessage()), (Throwable)exception);
            }
            return;
        }
        if (activeScan != null) {
            this.getMessagesTable().setModel(activeScan.getMessagesTableModel());
            this.getNumRequests().setText(Integer.toString(activeScan.getTotalRequests()));
            this.getProgressButton().setEnabled(true);
            if (activeScan instanceof AttackScan) {
                this.getProgressBar().setEnabled(false);
                this.getProgressButton().setEnabled(false);
                this.getPauseScanButton().setEnabled(false);
                this.getStopScanButton().setEnabled(false);
            }
        } else {
            this.resetMessagesTable();
            this.getNumRequests().setText("");
            this.getProgressButton().setEnabled(false);
        }
    }

    @Override
    public void alertFound(Alert alert) {
        ExtensionAlert extensionAlert = (ExtensionAlert)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAlert");
        if (extensionAlert != null) {
            extensionAlert.alertFound(alert, alert.getHistoryRef());
        }
    }

    @Override
    public void hostComplete(int n, String string) {
        this.scanFinshed(n, string);
    }

    @Override
    public void hostNewScan(int n, String string, HostProcess hostProcess) {
    }

    @Override
    public void hostProgress(int n, String string, String string2, int n2) {
        this.scanProgress(n, string, n2, 100);
        this.updateRequestCount();
    }

    @Override
    public void scannerComplete(int n) {
        this.scanFinshed(n, this.getName());
    }

    private void updateRequestCount() {
        ActiveScan activeScan = (ActiveScan)this.getSelectedScanner();
        if (activeScan != null) {
            this.getNumRequests().setText(Integer.toString(activeScan.getTotalRequests()));
        }
    }

    @Override
    public void notifyNewMessage(HttpMessage httpMessage) {
    }

    @Override
    public void reset() {
        super.reset();
        this.resetMessagesTable();
        this.getProgressButton().setEnabled(false);
    }

    @Override
    protected int getNumberOfScansToShow() {
        return this.extension.getScannerParam().getMaxScansInUI();
    }
}

