/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.lang;

import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.extension.lang.LangImporter;

public class LangImporterUnitTest {
    @Test
    public void shouldIncludeMessagesAndVulnerabilitiesFiles() {
        String[] stringArray = new String[]{"Messages.properties", "Messages_en.properties", "Messages_en_GB.properties", "Messages_ar_SA.properties", "Messages_fil_PH.properties", "Messages_zh_CN.properties", "vulnerabilities.xml", "vulnerabilities_en.xml", "vulnerabilities_en_GB.xml", "vulnerabilities_ar_SA.xml", "vulnerabilities_fil_PH.xml", "vulnerabilities_zh_CN.xml"};
        Pattern pattern = LangImporter.createIncludedFilesPattern();
        for (String string : stringArray) {
            Assert.assertThat((String)string, (Object)pattern.matcher(string).matches(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
        }
    }

    @Test
    public void shouldNotMatchOtherFilesThanMessagesAndVulnerabilitiesFiles() {
        String[] stringArray = new String[]{"Vulnerabilities.xml", "Vulnerabilities_en_GB.xml", "OtherFile_ar_SA.properties", "messages.properties"};
        Pattern pattern = LangImporter.createIncludedFilesPattern();
        for (String string : stringArray) {
            Assert.assertThat((String)string, (Object)pattern.matcher(string).matches(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        }
    }
}

