/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsoleManager;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.util.XmlXpathHelper;

public class AfterSuiteEvent
extends AbstractTestEvent {
    public AfterSuiteEvent(GradleTestsExecutionConsoleManager consoleManager) {
        super(consoleManager);
    }

    @Override
    public void process(XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        final String testId = this.getTestId(eventXml);
        final TestEventResult result = this.getTestEventResultType(eventXml);
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                SMTestProxy testProxy = AfterSuiteEvent.this.findTestProxy(testId);
                if (testProxy == null) {
                    return;
                }
                switch (result) {
                    case SUCCESS: {
                        testProxy.setFinished();
                        break;
                    }
                    case FAILURE: {
                        testProxy.setTestFailed("", null, false);
                        break;
                    }
                    case SKIPPED: {
                        testProxy.setTestIgnored(null, null);
                        break;
                    }
                }
                AfterSuiteEvent.this.getResultsViewer().onSuiteFinished(testProxy);
            }
        });
    }
}

