/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.frameworkSupport;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BuildScriptDataBuilder {
    @NotNull
    private final VirtualFile myBuildScriptFile;
    private final Set<String> plugins;
    private final Set<String> repositories;
    private final Set<String> dependencies;
    private final Set<String> properties;
    private final Set<String> buildScriptRepositories;
    private final Set<String> buildScriptDependencies;
    private final Set<String> other;

    public BuildScriptDataBuilder(@NotNull VirtualFile buildScriptFile) {
        if (buildScriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildScriptFile", "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder", "<init>"));
        }
        this.plugins = ContainerUtil.newTreeSet();
        this.repositories = ContainerUtil.newTreeSet();
        this.dependencies = ContainerUtil.newTreeSet();
        this.properties = ContainerUtil.newTreeSet();
        this.buildScriptRepositories = ContainerUtil.newTreeSet();
        this.buildScriptDependencies = ContainerUtil.newTreeSet();
        this.other = ContainerUtil.newTreeSet();
        this.myBuildScriptFile = buildScriptFile;
    }

    @NotNull
    public VirtualFile getBuildScriptFile() {
        VirtualFile virtualFile = this.myBuildScriptFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder", "getBuildScriptFile"));
        }
        return virtualFile;
    }

    public String build() {
        ArrayList lines = ContainerUtil.newArrayList();
        Function<String, String> padding = new Function<String, String>(){

            public String fun(String s) {
                return StringUtil.isNotEmpty((String)s) ? "    " + s : "";
            }
        };
        this.addBuildscriptLines(lines, padding);
        if (!this.plugins.isEmpty()) {
            lines.addAll(this.plugins);
            lines.add("");
        }
        if (!this.properties.isEmpty()) {
            lines.addAll(this.properties);
            lines.add("");
        }
        if (!this.repositories.isEmpty()) {
            lines.add("repositories {");
            lines.addAll(ContainerUtil.map(this.repositories, (Function)padding));
            lines.add("}");
            lines.add("");
        }
        if (!this.dependencies.isEmpty()) {
            lines.add("dependencies {");
            lines.addAll(ContainerUtil.map(this.dependencies, (Function)padding));
            lines.add("}");
            lines.add("");
        }
        if (!this.other.isEmpty()) {
            lines.addAll(this.other);
        }
        return StringUtil.join((Collection)lines, (String)"\n");
    }

    private void addBuildscriptLines(@NotNull List<String> lines, @NotNull Function<String, String> padding) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder", "addBuildscriptLines"));
        }
        if (padding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "padding", "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder", "addBuildscriptLines"));
        }
        if (!this.buildScriptRepositories.isEmpty() || !this.buildScriptDependencies.isEmpty()) {
            lines.add("buildscript {");
            List buildScriptLines = ContainerUtil.newSmartList();
            if (!this.buildScriptRepositories.isEmpty()) {
                buildScriptLines.add("repositories {");
                buildScriptLines.addAll(ContainerUtil.map(this.buildScriptRepositories, padding));
                buildScriptLines.add("}");
            }
            if (!this.buildScriptDependencies.isEmpty()) {
                buildScriptLines.add("dependencies {");
                buildScriptLines.addAll(ContainerUtil.map(this.buildScriptDependencies, padding));
                buildScriptLines.add("}");
            }
            lines.addAll(ContainerUtil.map((Collection)buildScriptLines, padding));
            lines.add("}");
            lines.add("");
        }
    }

    public BuildScriptDataBuilder addBuildscriptRepositoriesDefinition(@NotNull String definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder", "addBuildscriptRepositoriesDefinition"));
        }
        this.buildScriptRepositories.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addBuildscriptDependencyNotation(@NotNull String notation) {
        if (notation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notation", "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder", "addBuildscriptDependencyNotation"));
        }
        this.buildScriptDependencies.add(notation.trim());
        return this;
    }

    public BuildScriptDataBuilder addPluginDefinition(@NotNull String definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder", "addPluginDefinition"));
        }
        this.plugins.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addRepositoriesDefinition(@NotNull String definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder", "addRepositoriesDefinition"));
        }
        this.repositories.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addDependencyNotation(@NotNull String notation) {
        if (notation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notation", "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder", "addDependencyNotation"));
        }
        this.dependencies.add(notation.trim());
        return this;
    }

    public BuildScriptDataBuilder addPropertyDefinition(@NotNull String definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder", "addPropertyDefinition"));
        }
        this.properties.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addOther(@NotNull String definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder", "addOther"));
        }
        this.other.add(definition.trim());
        return this;
    }
}

