/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgVcs;

@com.intellij.openapi.components.State(name="hg4idea.settings", storages={@Storage(file="$WORKSPACE_FILE$")})
public class HgProjectSettings
implements PersistentStateComponent<State>,
DvcsSyncSettings {
    @NotNull
    private final HgGlobalSettings myAppSettings;
    @NotNull
    private final Project myProject;
    private State myState;

    public HgProjectSettings(@NotNull Project project, @NotNull HgGlobalSettings appSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/HgProjectSettings", "<init>"));
        }
        if (appSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appSettings", "org/zmlx/hg4idea/HgProjectSettings", "<init>"));
        }
        this.myState = new State();
        this.myProject = project;
        this.myAppSettings = appSettings;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
        if (state.CHECK_INCOMING_OUTGOING == null) {
            state.CHECK_INCOMING_OUTGOING = state.myCheckIncoming || state.myCheckOutgoing;
        }
    }

    public static HgProjectSettings getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/HgProjectSettings", "getInstance"));
        }
        return (HgProjectSettings)PeriodicalTasksCloser.getInstance().safeGetService(project, HgProjectSettings.class);
    }

    @Nullable
    public String getRecentRootPath() {
        return this.myState.RECENT_HG_ROOT_PATH;
    }

    public void setRecentRootPath(@NotNull String recentRootPath) {
        if (recentRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recentRootPath", "org/zmlx/hg4idea/HgProjectSettings", "setRecentRootPath"));
        }
        this.myState.RECENT_HG_ROOT_PATH = recentRootPath;
    }

    public boolean isCheckIncomingOutgoing() {
        return this.myState.CHECK_INCOMING_OUTGOING != null && this.myState.CHECK_INCOMING_OUTGOING != false;
    }

    public boolean isWhitespacesIgnoredInAnnotations() {
        return this.myState.myIgnoreWhitespacesInAnnotations;
    }

    @NotNull
    public DvcsSyncSettings.Value getSyncSetting() {
        DvcsSyncSettings.Value value = this.myState.ROOT_SYNC;
        if (value == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgProjectSettings", "getSyncSetting"));
        }
        return value;
    }

    public void setSyncSetting(@NotNull DvcsSyncSettings.Value syncSetting) {
        if (syncSetting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncSetting", "org/zmlx/hg4idea/HgProjectSettings", "setSyncSetting"));
        }
        this.myState.ROOT_SYNC = syncSetting;
    }

    public void setCheckIncomingOutgoing(boolean checkIncomingOutgoing) {
        this.myState.CHECK_INCOMING_OUTGOING = checkIncomingOutgoing;
    }

    public void setIgnoreWhitespacesInAnnotations(boolean ignoreWhitespacesInAnnotations) {
        if (this.myState.myIgnoreWhitespacesInAnnotations != ignoreWhitespacesInAnnotations) {
            this.myState.myIgnoreWhitespacesInAnnotations = ignoreWhitespacesInAnnotations;
            ((VcsAnnotationRefresher)this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).configurationChanged(HgVcs.getKey());
        }
    }

    public String getHgExecutable() {
        return this.myAppSettings.getHgExecutable();
    }

    public void setHgExecutable(String text) {
        this.myAppSettings.setHgExecutable(text);
    }

    @NotNull
    public HgGlobalSettings getGlobalSettings() {
        HgGlobalSettings hgGlobalSettings = this.myAppSettings;
        if (hgGlobalSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgProjectSettings", "getGlobalSettings"));
        }
        return hgGlobalSettings;
    }

    public static class State {
        public boolean myCheckIncoming = true;
        public boolean myCheckOutgoing = true;
        public Boolean CHECK_INCOMING_OUTGOING = null;
        public boolean myIgnoreWhitespacesInAnnotations = true;
        public String RECENT_HG_ROOT_PATH = null;
        public DvcsSyncSettings.Value ROOT_SYNC = DvcsSyncSettings.Value.NOT_DECIDED;
    }
}

