/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.VcsBackgroundTask;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgAddCommand;
import org.zmlx.hg4idea.command.HgCopyCommand;
import org.zmlx.hg4idea.command.HgMoveCommand;
import org.zmlx.hg4idea.command.HgRemoveCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.util.HgUtil;

public class HgVFSListener
extends VcsVFSListener {
    private final VcsDirtyScopeManager dirtyScopeManager;
    private static final Logger LOG = Logger.getInstance(HgVFSListener.class);

    protected HgVFSListener(Project project, HgVcs vcs) {
        super(project, (AbstractVcs)vcs);
        this.dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
    }

    protected String getAddTitle() {
        return HgVcsMessages.message("hg4idea.add.title", new Object[0]);
    }

    protected String getSingleFileAddTitle() {
        return HgVcsMessages.message("hg4idea.add.single.title", new Object[0]);
    }

    protected String getSingleFileAddPromptTemplate() {
        return HgVcsMessages.message("hg4idea.add.body", new Object[0]);
    }

    protected void executeAdd(final List<VirtualFile> addedFiles, final Map<VirtualFile, VirtualFile> copyFromMap) {
        Iterator<Map.Entry<VirtualFile, VirtualFile>> it = copyFromMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<VirtualFile, VirtualFile> entry = it.next();
            VirtualFile rootFrom = HgUtil.getHgRootOrNull(this.myProject, entry.getKey());
            VirtualFile rootTo = HgUtil.getHgRootOrNull(this.myProject, entry.getValue());
            if (rootTo != null && rootTo.equals(rootFrom)) continue;
            it.remove();
        }
        it = addedFiles.iterator();
        while (it.hasNext()) {
            if (HgUtil.getHgRootOrNull(this.myProject, (VirtualFile)it.next()) != null) continue;
            it.remove();
        }
        final Map<VirtualFile, Collection<VirtualFile>> sortedFiles = HgUtil.sortByHgRoots(this.myProject, addedFiles);
        final HashSet untrackedFiles = new HashSet();
        new Task.Backgroundable(this.myProject, HgVcsMessages.message("hg4idea.progress.checking.ignored", new Object[0]), false){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "org/zmlx/hg4idea/HgVFSListener$1", "run"));
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    VirtualFile repo = (VirtualFile)e.getKey();
                    Collection files = (Collection)e.getValue();
                    pi.setText(repo.getPresentableUrl());
                    try {
                        untrackedFiles.addAll(new HgStatusCommand.Builder(false).unknown(true).removed(true).build(this.myProject).getHgUntrackedFiles(repo, new ArrayList<VirtualFile>(files)));
                    }
                    catch (VcsException ex) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ((HgVcs)HgVFSListener.this.myVcs).showMessageInConsole(ex.getMessage(), ConsoleViewContentType.ERROR_OUTPUT.getAttributes());
                            }
                        });
                    }
                }
                addedFiles.retainAll(untrackedFiles);
                if (!addedFiles.isEmpty() || !copyFromMap.isEmpty()) {
                    AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            HgVFSListener.this.originalExecuteAdd(addedFiles, copyFromMap);
                        }
                    });
                }
            }
        }.queue();
    }

    private void originalExecuteAdd(List<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copiedFiles) {
        super.executeAdd(addedFiles, copiedFiles);
    }

    protected void performAdding(final Collection<VirtualFile> addedFiles, final Map<VirtualFile, VirtualFile> copyFromMap) {
        new Task.ConditionalModal(this.myProject, HgVcsMessages.message("hg4idea.add.progress", new Object[0]), false, VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption()){

            public void run(@NotNull ProgressIndicator aProgressIndicator) {
                if (aProgressIndicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aProgressIndicator", "org/zmlx/hg4idea/HgVFSListener$2", "run"));
                }
                ArrayList<VirtualFile> adds = new ArrayList<VirtualFile>();
                HashMap<VirtualFile, VirtualFile> copies = new HashMap<VirtualFile, VirtualFile>();
                LOG.assertTrue(this.myProject != null, (Object)"Project is null");
                ArrayList<VirtualFile> unversionedAndIgnoredFiles = new ArrayList<VirtualFile>();
                Map<VirtualFile, Collection<VirtualFile>> sortedSourceFilesByRepos = HgUtil.sortByHgRoots(this.myProject, copyFromMap.values());
                HgStatusCommand statusCommand = new HgStatusCommand.Builder(false).unknown(true).ignored(true).build(this.myProject);
                for (Map.Entry<VirtualFile, Collection<VirtualFile>> entry : sortedSourceFilesByRepos.entrySet()) {
                    Set<HgChange> changes = statusCommand.execute(entry.getKey(), ContainerUtil.map(entry.getValue(), (Function)new Function<VirtualFile, FilePath>(){

                        public FilePath fun(VirtualFile virtualFile) {
                            return VcsUtil.getFilePath((VirtualFile)virtualFile);
                        }
                    }));
                    for (HgChange change : changes) {
                        unversionedAndIgnoredFiles.add(change.afterFile().toFilePath().getVirtualFile());
                    }
                }
                copyFromMap.values().removeAll(unversionedAndIgnoredFiles);
                for (VirtualFile virtualFile : addedFiles) {
                    if (virtualFile.isDirectory()) continue;
                    VirtualFile copyFrom = (VirtualFile)copyFromMap.get(virtualFile);
                    if (copyFrom != null) {
                        copies.put(copyFrom, virtualFile);
                        continue;
                    }
                    adds.add(virtualFile);
                }
                if (!adds.isEmpty()) {
                    new HgAddCommand(this.myProject).execute(adds);
                }
                if (!copies.isEmpty()) {
                    for (Map.Entry<Object, Collection<Object>> entry : copies.entrySet()) {
                        new HgCopyCommand(this.myProject).execute((VirtualFile)entry.getKey(), (VirtualFile)entry.getValue());
                    }
                }
                for (VirtualFile virtualFile : addedFiles) {
                    HgVFSListener.this.dirtyScopeManager.fileDirty(virtualFile);
                }
            }
        }.queue();
    }

    protected String getDeleteTitle() {
        return HgVcsMessages.message("hg4idea.remove.multiple.title", new Object[0]);
    }

    protected String getSingleFileDeleteTitle() {
        return HgVcsMessages.message("hg4idea.remove.single.title", new Object[0]);
    }

    protected String getSingleFileDeletePromptTemplate() {
        return HgVcsMessages.message("hg4idea.remove.single.body", new Object[0]);
    }

    protected VcsVFSListener.VcsDeleteType needConfirmDeletion(VirtualFile file) {
        return ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).getUnversionedFiles().contains(file) ? VcsVFSListener.VcsDeleteType.IGNORE : VcsVFSListener.VcsDeleteType.CONFIRM;
    }

    protected void executeDelete() {
        final ArrayList<FilePath> filesToDelete = new ArrayList<FilePath>(this.myDeletedWithoutConfirmFiles);
        final ArrayList<FilePath> filesToConfirmDeletion = new ArrayList<FilePath>(this.myDeletedFiles);
        this.myDeletedWithoutConfirmFiles.clear();
        this.myDeletedFiles.clear();
        this.skipNotUnderHg(filesToDelete);
        this.skipNotUnderHg(filesToConfirmDeletion);
        Iterator it = filesToConfirmDeletion.iterator();
        while (it.hasNext()) {
            FilePath filePath = (FilePath)it.next();
            Change fileChange = ChangeListManager.getInstance((Project)this.myProject).getChange(filePath);
            if (fileChange == null || !fileChange.getFileStatus().equals(FileStatus.ADDED)) continue;
            filesToDelete.add(filePath);
            it.remove();
        }
        new Task.ConditionalModal(this.myProject, HgVcsMessages.message("hg4idea.remove.progress", new Object[0]), false, VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/HgVFSListener$3", "run"));
                }
                if (HgVFSListener.this.myRemoveOption.getValue() != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                    if (HgVFSListener.this.myRemoveOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || filesToConfirmDeletion.isEmpty()) {
                        filesToDelete.addAll(filesToConfirmDeletion);
                    } else {
                        final AtomicReference filePaths = new AtomicReference();
                        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                filePaths.set(HgVFSListener.this.selectFilePathsToDelete(filesToConfirmDeletion));
                            }
                        }, indicator.getModalityState());
                        if (filePaths.get() != null) {
                            filesToDelete.addAll((Collection)filePaths.get());
                        }
                    }
                }
                if (!filesToDelete.isEmpty()) {
                    HgVFSListener.this.performDeletion(filesToDelete);
                }
            }
        }.queue();
    }

    private void skipNotUnderHg(Collection<FilePath> filesToFilter) {
        Iterator<FilePath> iter = filesToFilter.iterator();
        while (iter.hasNext()) {
            FilePath filePath = iter.next();
            if (HgUtil.getHgRootOrNull(this.myProject, filePath) != null) continue;
            iter.remove();
        }
    }

    protected void performDeletion(List<FilePath> filesToDelete) {
        ArrayList<HgFile> deletes = new ArrayList<HgFile>();
        for (FilePath filePath : filesToDelete) {
            VirtualFile root;
            if (filePath.isDirectory() || (root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath)) == null) continue;
            deletes.add(new HgFile(root, filePath));
        }
        if (!deletes.isEmpty()) {
            new HgRemoveCommand(this.myProject).execute(deletes);
        }
        for (HgFile hgFile : deletes) {
            this.dirtyScopeManager.fileDirty(hgFile.toFilePath());
        }
    }

    protected void performMoveRename(List<VcsVFSListener.MovedFileInfo> movedFiles) {
        new VcsBackgroundTask<VcsVFSListener.MovedFileInfo>(this.myProject, HgVcsMessages.message("hg4idea.move.progress", new Object[0]), VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption(), movedFiles){

            protected void process(VcsVFSListener.MovedFileInfo file) throws VcsException {
                FilePath source = VcsUtil.getFilePath((String)file.myOldPath);
                FilePath target = VcsUtil.getFilePath((String)file.myNewPath);
                VirtualFile sourceRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)source);
                VirtualFile targetRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)target);
                if (sourceRoot != null && targetRoot != null) {
                    new HgMoveCommand(this.myProject).execute(new HgFile(sourceRoot, source), new HgFile(targetRoot, target));
                }
                HgVFSListener.this.dirtyScopeManager.fileDirty(source);
                HgVFSListener.this.dirtyScopeManager.fileDirty(target);
            }
        }.queue();
    }

    protected boolean isDirectoryVersioningSupported() {
        return false;
    }
}

