/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.action.HgProcessStateAction;
import org.zmlx.hg4idea.command.HgGraftCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgContinueGraftAction
extends HgProcessStateAction {
    public HgContinueGraftAction() {
        super(Repository.State.GRAFTING);
    }

    @Override
    protected void execute(final @NotNull Project project, @NotNull Collection<HgRepository> repositories, final @Nullable HgRepository selectedRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/action/HgContinueGraftAction", "execute"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/action/HgContinueGraftAction", "execute"));
        }
        new Task.Backgroundable(project, "Continue Grafting..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/action/HgContinueGraftAction$1", "run"));
                }
                if (selectedRepo != null) {
                    HgGraftCommand graftCommand = new HgGraftCommand(project, selectedRepo);
                    HgCommandResult result = graftCommand.continueGrafting();
                    if (HgErrorUtil.isAbort(result)) {
                        new HgCommandResultNotifier(project).notifyError(result, "Hg Error", "Couldn't continue grafting");
                    }
                    HgErrorUtil.markDirtyAndHandleErrors(project, selectedRepo.getRoot());
                }
            }
        }.queue();
    }
}

