/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgResolveCommand;
import org.zmlx.hg4idea.command.HgRevertCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRollbackEnvironment
implements RollbackEnvironment {
    private final Project project;

    public HgRollbackEnvironment(Project project) {
        this.project = project;
    }

    public String getRollbackOperationName() {
        return HgVcsMessages.message("hg4idea.revert", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChanges(List<Change> changes, List<VcsException> vcsExceptions, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/zmlx/hg4idea/provider/HgRollbackEnvironment", "rollbackChanges"));
        }
        if (changes == null || changes.isEmpty()) {
            return;
        }
        ArrayList<FilePath> toDelete = new ArrayList<FilePath>();
        LinkedList<FilePath> filePaths = new LinkedList<FilePath>();
        for (Change change : changes) {
            ContentRevision contentRevision = Change.Type.DELETED == change.getType() ? change.getBeforeRevision() : change.getAfterRevision();
            if (contentRevision == null) continue;
            filePaths.add(contentRevision.getFile());
            if (Change.Type.MOVED != change.getType()) continue;
            toDelete.add(contentRevision.getFile());
        }
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.project);
        try {
            this.revert(filePaths);
            for (FilePath file : toDelete) {
                listener.accept(file);
                try {
                    File ioFile = file.getIOFile();
                    if (!ioFile.exists() || ioFile.delete()) continue;
                    vcsExceptions.add(new VcsException("Unable to delete file: " + file));
                }
                catch (Exception e) {
                    vcsExceptions.add(new VcsException("Unable to delete file: " + file, (Throwable)e));
                }
            }
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.project, (AccessToken)token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMissingFileDeletion(List<FilePath> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.project);
        try {
            this.revert(files);
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.project, (AccessToken)token);
        }
    }

    public void rollbackModifiedWithoutCheckout(List<VirtualFile> files, List<VcsException> exceptions, RollbackProgressListener listener) {
    }

    public List<VcsException> rollbackMissingFileDeletion(List<FilePath> files) {
        if (files == null || files.isEmpty()) {
            return null;
        }
        this.revert(files);
        return null;
    }

    public void rollbackIfUnchanged(VirtualFile file) {
    }

    private void revert(@NotNull List<FilePath> filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "org/zmlx/hg4idea/provider/HgRollbackEnvironment", "revert"));
        }
        block0: for (Map.Entry<VirtualFile, Collection<FilePath>> entry : HgUtil.groupFilePathsByHgRoots(this.project, filePaths).entrySet()) {
            VirtualFile repo = entry.getKey();
            Collection<FilePath> files = entry.getValue();
            HgRevisionNumber revisionNumber = new HgWorkingCopyRevisionsCommand(this.project).firstParent(repo);
            for (List chunk : VcsFileUtil.chunkPaths((VirtualFile)repo, files)) {
                HgCommandResult revertResult = new HgRevertCommand(this.project).execute(repo, chunk, revisionNumber, false);
                if (HgErrorUtil.hasUncommittedChangesConflict(revertResult)) {
                    String message = String.format("<html>Revert failed due to uncommitted merge.<br>Would you like to discard all changes for repository <it><b>%s</b></it>?</html>", repo.getPresentableName());
                    int exitCode = HgUpdateCommand.showDiscardChangesConfirmation(this.project, message);
                    if (exitCode != 0) continue block0;
                    HgUpdateCommand updateCommand = new HgUpdateCommand(this.project, repo);
                    updateCommand.setClean(true);
                    updateCommand.setRevision(".");
                    updateCommand.execute();
                    continue block0;
                }
                new HgResolveCommand(this.project).markResolved(repo, files);
            }
        }
    }
}

