/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.iptc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.BinaryInputStream;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.formats.jpeg.iptc.IPTCBlock;
import org.apache.sanselan.formats.jpeg.iptc.IPTCConstants;
import org.apache.sanselan.formats.jpeg.iptc.IPTCRecord;
import org.apache.sanselan.formats.jpeg.iptc.IPTCType;
import org.apache.sanselan.formats.jpeg.iptc.IPTCTypeLookup;
import org.apache.sanselan.formats.jpeg.iptc.PhotoshopApp13Data;
import org.apache.sanselan.util.Debug;
import org.apache.sanselan.util.ParamMap;

public class IPTCParser
extends BinaryFileParser
implements IPTCConstants {
    private static final int APP13_BYTE_ORDER = 77;

    public IPTCParser() {
        this.setByteOrder(77);
    }

    public boolean isPhotoshopJpegSegment(byte[] segmentData) {
        if (!this.compareByteArrays(segmentData, 0, PHOTOSHOP_IDENTIFICATION_STRING, 0, PHOTOSHOP_IDENTIFICATION_STRING.length)) {
            return false;
        }
        int index = PHOTOSHOP_IDENTIFICATION_STRING.length;
        if (index + CONST_8BIM.length > segmentData.length) {
            return false;
        }
        return this.compareByteArrays(segmentData, index, CONST_8BIM, 0, CONST_8BIM.length);
    }

    public PhotoshopApp13Data parsePhotoshopSegment(byte[] bytes, Map params) throws ImageReadException, IOException {
        boolean strict = ParamMap.getParamBoolean(params, "STRICT", false);
        boolean verbose = ParamMap.getParamBoolean(params, "VERBOSE", false);
        return this.parsePhotoshopSegment(bytes, verbose, strict);
    }

    public PhotoshopApp13Data parsePhotoshopSegment(byte[] bytes, boolean verbose, boolean strict) throws ImageReadException, IOException {
        ArrayList records = new ArrayList();
        List allBlocks = this.parseAllBlocks(bytes, verbose, strict);
        for (int i = 0; i < allBlocks.size(); ++i) {
            IPTCBlock block = (IPTCBlock)allBlocks.get(i);
            if (!block.isIPTCBlock()) continue;
            records.addAll(this.parseIPTCBlock(block.blockData, verbose));
        }
        return new PhotoshopApp13Data(records, allBlocks);
    }

    protected List parseIPTCBlock(byte[] bytes, boolean verbose) throws ImageReadException, IOException {
        ArrayList<IPTCRecord> elements = new ArrayList<IPTCRecord>();
        int index = 0;
        while (index + 1 < bytes.length) {
            int tagMarker = 0xFF & bytes[index++];
            if (verbose) {
                Debug.debug("tagMarker", tagMarker + " (0x" + Integer.toHexString(tagMarker) + ")");
            }
            if (tagMarker != 28) {
                if (verbose) {
                    System.out.println("Unexpected record tag marker in IPTC data.");
                }
                return elements;
            }
            int recordNumber = 0xFF & bytes[index++];
            if (verbose) {
                Debug.debug("recordNumber", recordNumber + " (0x" + Integer.toHexString(recordNumber) + ")");
            }
            if (recordNumber != 2) continue;
            int recordType = 0xFF & bytes[index];
            if (verbose) {
                Debug.debug("recordType", recordType + " (0x" + Integer.toHexString(recordType) + ")");
            }
            int recordSize = this.convertByteArrayToShort("recordSize", ++index, bytes);
            index += 2;
            boolean extendedDataset = recordSize > Short.MAX_VALUE;
            int dataFieldCountLength = recordSize & Short.MAX_VALUE;
            if (extendedDataset && verbose) {
                Debug.debug("extendedDataset. dataFieldCountLength: " + dataFieldCountLength);
            }
            if (extendedDataset) {
                return elements;
            }
            byte[] recordData = this.readBytearray("recordData", bytes, index, recordSize);
            index += recordSize;
            if (recordType == 0) {
                if (!verbose) continue;
                System.out.println("ignore record version record! " + elements.size());
                continue;
            }
            String value = new String(recordData, "ISO-8859-1");
            IPTCType iptcType = IPTCTypeLookup.getIptcType(recordType);
            IPTCRecord element = new IPTCRecord(iptcType, value);
            elements.add(element);
        }
        return elements;
    }

    protected List parseAllBlocks(byte[] bytes, boolean verbose, boolean strict) throws ImageReadException, IOException {
        byte[] imageResourceBlockSignature;
        ArrayList<IPTCBlock> blocks = new ArrayList<IPTCBlock>();
        BinaryInputStream bis = new BinaryInputStream(bytes, 77);
        byte[] idString = bis.readByteArray(PHOTOSHOP_IDENTIFICATION_STRING.length, "App13 Segment missing identification string");
        if (!this.compareByteArrays(idString, PHOTOSHOP_IDENTIFICATION_STRING)) {
            throw new ImageReadException("Not a Photoshop App13 Segment");
        }
        while (null != (imageResourceBlockSignature = bis.readByteArray(CONST_8BIM.length, "App13 Segment missing identification string", false, false))) {
            byte[] blockNameBytes;
            if (!this.compareByteArrays(imageResourceBlockSignature, CONST_8BIM)) {
                throw new ImageReadException("Invalid Image Resource Block Signature");
            }
            int blockType = bis.read2ByteInteger("Image Resource Block missing type");
            if (verbose) {
                Debug.debug("blockType", blockType + " (0x" + Integer.toHexString(blockType) + ")");
            }
            int blockNameLength = bis.read1ByteInteger("Image Resource Block missing name length");
            if (verbose && blockNameLength > 0) {
                Debug.debug("blockNameLength", blockNameLength + " (0x" + Integer.toHexString(blockNameLength) + ")");
            }
            if (blockNameLength == 0) {
                bis.read1ByteInteger("Image Resource Block has invalid name");
                blockNameBytes = new byte[]{};
            } else {
                blockNameBytes = bis.readByteArray(blockNameLength, "Invalid Image Resource Block name", verbose, strict);
                if (null == blockNameBytes) break;
                if (blockNameLength % 2 == 0) {
                    bis.read1ByteInteger("Image Resource Block missing padding byte");
                }
            }
            int blockSize = bis.read4ByteInteger("Image Resource Block missing size");
            if (verbose) {
                Debug.debug("blockSize", blockSize + " (0x" + Integer.toHexString(blockSize) + ")");
            }
            if (blockSize > bytes.length) {
                throw new ImageReadException("Invalid Block Size : " + blockSize + " > " + bytes.length);
            }
            byte[] blockData = bis.readByteArray(blockSize, "Invalid Image Resource Block data", verbose, strict);
            if (null == blockData) break;
            blocks.add(new IPTCBlock(blockType, blockNameBytes, blockData));
            if (blockSize % 2 == 0) continue;
            bis.read1ByteInteger("Image Resource Block missing padding byte");
        }
        return blocks;
    }

    public byte[] writePhotoshopApp13Segment(PhotoshopApp13Data data) throws IOException, ImageWriteException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BinaryOutputStream bos = new BinaryOutputStream(os);
        bos.write(PHOTOSHOP_IDENTIFICATION_STRING);
        List blocks = data.getRawBlocks();
        for (int i = 0; i < blocks.size(); ++i) {
            IPTCBlock block = (IPTCBlock)blocks.get(i);
            bos.write(CONST_8BIM);
            if (block.blockType < 0 || block.blockType > 65535) {
                throw new ImageWriteException("Invalid IPTC block type.");
            }
            bos.write2ByteInteger(block.blockType);
            if (block.blockNameBytes.length > 255) {
                throw new ImageWriteException("IPTC block name is too long: " + block.blockNameBytes.length);
            }
            bos.write(block.blockNameBytes.length);
            bos.write(block.blockNameBytes);
            if (block.blockNameBytes.length % 2 == 0) {
                bos.write(0);
            }
            if (block.blockData.length > Short.MAX_VALUE) {
                throw new ImageWriteException("IPTC block data is too long: " + block.blockData.length);
            }
            bos.write4ByteInteger(block.blockData.length);
            bos.write(block.blockData);
            if (block.blockData.length % 2 != 1) continue;
            bos.write(0);
        }
        bos.flush();
        return os.toByteArray();
    }

    public byte[] writeIPTCBlock(List elements) throws ImageWriteException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputStream bos = new BinaryOutputStream(baos, this.getByteOrder());
        bos.write(28);
        bos.write(2);
        bos.write(IPTCParser.IPTC_TYPE_RECORD_VERSION.type);
        bos.write2Bytes(2);
        bos.write2Bytes(2);
        elements = new ArrayList(elements);
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                IPTCRecord e1 = (IPTCRecord)o1;
                IPTCRecord e2 = (IPTCRecord)o2;
                return e2.iptcType.type - e1.iptcType.type;
            }
        };
        Collections.sort(elements, comparator);
        for (int i = 0; i < elements.size(); ++i) {
            IPTCRecord element = (IPTCRecord)elements.get(i);
            if (element.iptcType.type == IPTCParser.IPTC_TYPE_RECORD_VERSION.type) continue;
            bos.write(28);
            bos.write(2);
            if (element.iptcType.type < 0 || element.iptcType.type > 255) {
                throw new ImageWriteException("Invalid record type: " + element.iptcType.type);
            }
            bos.write(element.iptcType.type);
            byte[] recordData = element.value.getBytes("ISO-8859-1");
            if (!new String(recordData, "ISO-8859-1").equals(element.value)) {
                throw new ImageWriteException("Invalid record value, not ISO-8859-1");
            }
            bos.write2Bytes(recordData.length);
            bos.write(recordData);
        }
        byte[] blockData = baos.toByteArray();
        return blockData;
    }
}

