/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.util;

import java.io.UnsupportedEncodingException;
import org.apache.sanselan.common.BinaryConstants;

public abstract class UnicodeUtils
implements BinaryConstants {
    public static final int CHAR_ENCODING_CODE_ISO_8859_1 = 0;
    public static final int CHAR_ENCODING_CODE_UTF_16_BIG_ENDIAN_WITH_BOM = 1;
    public static final int CHAR_ENCODING_CODE_UTF_16_LITTLE_ENDIAN_WITH_BOM = 2;
    public static final int CHAR_ENCODING_CODE_UTF_16_BIG_ENDIAN_NO_BOM = 3;
    public static final int CHAR_ENCODING_CODE_UTF_16_LITTLE_ENDIAN_NO_BOM = 4;
    public static final int CHAR_ENCODING_CODE_UTF_8 = 5;
    public static final int CHAR_ENCODING_CODE_AMBIGUOUS = -1;

    private UnicodeUtils() {
    }

    public static final boolean isValidISO_8859_1(String s) {
        try {
            String roundtrip = new String(s.getBytes("ISO-8859-1"), "ISO-8859-1");
            return s.equals(roundtrip);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error parsing string.", e);
        }
    }

    private static int findFirstDoubleByteTerminator(byte[] bytes, int index) {
        for (int i = index; i < bytes.length - 1; i += 2) {
            int c1 = 0xFF & bytes[index];
            int c2 = 0xFF & bytes[index + 1];
            if (c1 != 0 || c2 != 0) continue;
            return i;
        }
        return -1;
    }

    public final int findEndWithTerminator(byte[] bytes, int index) throws UnicodeException {
        return this.findEnd(bytes, index, true);
    }

    public final int findEndWithoutTerminator(byte[] bytes, int index) throws UnicodeException {
        return this.findEnd(bytes, index, false);
    }

    protected abstract int findEnd(byte[] var1, int var2, boolean var3) throws UnicodeException;

    public static UnicodeUtils getInstance(int charEncodingCode) throws UnicodeException {
        switch (charEncodingCode) {
            case 0: {
                return new UnicodeMetricsASCII();
            }
            case 5: {
                return new UnicodeMetricsUTF8();
            }
            case 1: 
            case 2: {
                return new UnicodeMetricsUTF16WithBOM();
            }
            case 3: {
                return new UnicodeMetricsUTF16NoBOM(77);
            }
            case 4: {
                return new UnicodeMetricsUTF16NoBOM(73);
            }
        }
        throw new UnicodeException("Unknown char encoding code: " + charEncodingCode);
    }

    private static class UnicodeMetricsUTF16WithBOM
    extends UnicodeMetricsUTF16 {
        public UnicodeMetricsUTF16WithBOM() {
            super(0);
        }

        @Override
        public int findEnd(byte[] bytes, int index, boolean includeTerminator) throws UnicodeException {
            if (index >= bytes.length - 1) {
                throw new UnicodeException("Missing BOM.");
            }
            int c1 = 0xFF & bytes[index++];
            int c2 = 0xFF & bytes[index++];
            if (c1 == 255 && c2 == 254) {
                this.byteOrder = 1;
            } else if (c1 == 254 && c2 == 255) {
                this.byteOrder = 0;
            } else {
                throw new UnicodeException("Invalid byte order mark.");
            }
            return super.findEnd(bytes, index, includeTerminator);
        }
    }

    private static class UnicodeMetricsUTF16NoBOM
    extends UnicodeMetricsUTF16 {
        public UnicodeMetricsUTF16NoBOM(int byteOrder) {
            super(byteOrder);
        }
    }

    private static abstract class UnicodeMetricsUTF16
    extends UnicodeUtils {
        protected static final int BYTE_ORDER_BIG_ENDIAN = 0;
        protected static final int BYTE_ORDER_LITTLE_ENDIAN = 1;
        protected int byteOrder = 0;

        public UnicodeMetricsUTF16(int byteOrder) {
            this.byteOrder = byteOrder;
        }

        public boolean isValid(byte[] bytes, int index, boolean mayHaveTerminator, boolean mustHaveTerminator) throws UnicodeException {
            while (true) {
                int msb1;
                if (index == bytes.length) {
                    return !mustHaveTerminator;
                }
                if (index >= bytes.length - 1) {
                    return false;
                }
                int c1 = 0xFF & bytes[index++];
                int c2 = 0xFF & bytes[index++];
                int n = msb1 = this.byteOrder == 0 ? c1 : c2;
                if (c1 == 0 && c2 == 0) {
                    return mayHaveTerminator;
                }
                if (msb1 < 216) continue;
                if (msb1 >= 220) {
                    return false;
                }
                if (index >= bytes.length - 1) {
                    return false;
                }
                int c3 = 0xFF & bytes[index++];
                int c4 = 0xFF & bytes[index++];
                int msb2 = this.byteOrder == 0 ? c3 : c4;
                if (msb2 < 220) break;
            }
            return false;
        }

        @Override
        public int findEnd(byte[] bytes, int index, boolean includeTerminator) throws UnicodeException {
            while (true) {
                int msb1;
                if (index == bytes.length) {
                    return bytes.length;
                }
                if (index > bytes.length - 1) {
                    throw new UnicodeException("Terminator not found.");
                }
                int c1 = 0xFF & bytes[index++];
                int c2 = 0xFF & bytes[index++];
                int n = msb1 = this.byteOrder == 0 ? c1 : c2;
                if (c1 == 0 && c2 == 0) {
                    return includeTerminator ? index : index - 2;
                }
                if (msb1 < 216) continue;
                if (index > bytes.length - 1) {
                    throw new UnicodeException("Terminator not found.");
                }
                int c3 = 0xFF & bytes[index++];
                int c4 = 0xFF & bytes[index++];
                int msb2 = this.byteOrder == 0 ? c3 : c4;
                if (msb2 < 220) break;
            }
            throw new UnicodeException("Invalid code point.");
        }
    }

    private static class UnicodeMetricsUTF8
    extends UnicodeUtils {
        private UnicodeMetricsUTF8() {
        }

        @Override
        public int findEnd(byte[] bytes, int index, boolean includeTerminator) throws UnicodeException {
            block12: {
                while (true) {
                    int c4;
                    int c3;
                    int c2;
                    int c1;
                    if (index == bytes.length) {
                        return bytes.length;
                    }
                    if (index > bytes.length) {
                        throw new UnicodeException("Terminator not found.");
                    }
                    if ((c1 = 0xFF & bytes[index++]) == 0) {
                        return includeTerminator ? index : index - 1;
                    }
                    if (c1 <= 127) continue;
                    if (c1 <= 223) {
                        if (index >= bytes.length) {
                            throw new UnicodeException("Invalid unicode.");
                        }
                        if ((c2 = 0xFF & bytes[index++]) >= 128 && c2 <= 191) continue;
                        throw new UnicodeException("Invalid code point.");
                    }
                    if (c1 <= 239) {
                        if (index >= bytes.length - 1) {
                            throw new UnicodeException("Invalid unicode.");
                        }
                        if ((c2 = 0xFF & bytes[index++]) < 128 || c2 > 191) {
                            throw new UnicodeException("Invalid code point.");
                        }
                        if ((c3 = 0xFF & bytes[index++]) >= 128 && c3 <= 191) continue;
                        throw new UnicodeException("Invalid code point.");
                    }
                    if (c1 > 244) break block12;
                    if (index >= bytes.length - 2) {
                        throw new UnicodeException("Invalid unicode.");
                    }
                    if ((c2 = 0xFF & bytes[index++]) < 128 || c2 > 191) {
                        throw new UnicodeException("Invalid code point.");
                    }
                    if ((c3 = 0xFF & bytes[index++]) < 128 || c3 > 191) {
                        throw new UnicodeException("Invalid code point.");
                    }
                    if ((c4 = 0xFF & bytes[index++]) < 128 || c4 > 191) break;
                }
                throw new UnicodeException("Invalid code point.");
            }
            throw new UnicodeException("Invalid code point.");
        }
    }

    private static class UnicodeMetricsASCII
    extends UnicodeUtils {
        private UnicodeMetricsASCII() {
        }

        @Override
        public int findEnd(byte[] bytes, int index, boolean includeTerminator) throws UnicodeException {
            for (int i = index; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                return includeTerminator ? i + 1 : i;
            }
            return bytes.length;
        }
    }

    public static class UnicodeException
    extends Exception {
        public UnicodeException(String message) {
            super(message);
        }
    }
}

