/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPath2TokenTypes;
import org.intellij.lang.xpath.XPathElementType;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.context.functions.Parameter;
import org.intellij.lang.xpath.psi.XPath2ElementVisitor;
import org.intellij.lang.xpath.psi.XPath2If;
import org.intellij.lang.xpath.psi.XPath2QuantifiedExpr;
import org.intellij.lang.xpath.psi.XPath2SequenceType;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathBinaryExpression;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFilterExpression;
import org.intellij.lang.xpath.psi.XPathFunction;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.psi.XPathLocationPath;
import org.intellij.lang.xpath.psi.XPathParenthesizedExpression;
import org.intellij.lang.xpath.psi.XPathPredicate;
import org.intellij.lang.xpath.psi.XPathPrefixExpression;
import org.intellij.lang.xpath.psi.XPathStep;
import org.intellij.lang.xpath.psi.XPathType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeUtil {
    private ExpectedTypeUtil() {
    }

    @NotNull
    public static XPathType getExpectedType(XPathExpression expression) {
        XPathExpression parentExpr = (XPathExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, XPathExpression.class);
        if (parentExpr != null) {
            ExpectedTypeVisitor visitor = new ExpectedTypeVisitor(expression);
            parentExpr.accept(visitor);
            XPathType xPathType = ExpectedTypeUtil.mapType(expression, visitor.getExpectedType());
            if (xPathType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/ExpectedTypeUtil", "getExpectedType"));
            }
            return xPathType;
        }
        XPathType xPathType = ExpectedTypeUtil.mapType(expression, expression.getXPathContext().getExpectedType(expression));
        if (xPathType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/ExpectedTypeUtil", "getExpectedType"));
        }
        return xPathType;
    }

    private static XPathType matchingType(XPathExpression lOperand, XPathElementType op) {
        XPathType type = ExpectedTypeUtil.mapType(lOperand, lOperand.getType());
        if (op == XPathTokenTypes.PLUS) {
            if (XPathType.isAssignable(XPath2Type.NUMERIC, type)) {
                return XPath2Type.NUMERIC;
            }
            if (XPathType.isAssignable(XPath2Type.DATE, type) || XPathType.isAssignable(XPath2Type.TIME, type) || XPathType.isAssignable(XPath2Type.DATETIME, type)) {
                return XPath2Type.DURATION;
            }
            if (XPathType.isAssignable(XPath2Type.DURATION, type)) {
                return XPathType.ChoiceType.create(XPath2Type.DURATION, XPath2Type.DATE, XPath2Type.TIME, XPath2Type.DATETIME);
            }
        } else if (op == XPathTokenTypes.MINUS) {
            if (XPathType.isAssignable(XPath2Type.NUMERIC, type)) {
                return XPath2Type.NUMERIC;
            }
            if (XPathType.isAssignable(XPath2Type.DATE, type) || XPathType.isAssignable(XPath2Type.TIME, type) || XPathType.isAssignable(XPath2Type.DATETIME, type)) {
                return XPathType.ChoiceType.create(type, XPath2Type.DURATION);
            }
            if (XPathType.isAssignable(XPath2Type.DURATION, type)) {
                return XPath2Type.DURATION;
            }
        } else if (op == XPathTokenTypes.MULT) {
            if (XPathType.isAssignable(XPath2Type.NUMERIC, type)) {
                return XPathType.ChoiceType.create(XPath2Type.NUMERIC, XPath2Type.DURATION);
            }
            if (XPath2Type.DURATION.isAssignableFrom(type)) {
                return XPath2Type.NUMERIC;
            }
        } else {
            if (op == XPath2TokenTypes.IDIV || op == XPathTokenTypes.MOD) {
                return XPath2Type.NUMERIC;
            }
            if (op == XPathTokenTypes.DIV) {
                if (XPathType.isAssignable(XPath2Type.NUMERIC, type)) {
                    return XPath2Type.NUMERIC;
                }
                if (XPath2Type.DURATION.isAssignableFrom(type)) {
                    return XPathType.ChoiceType.create(XPath2Type.NUMERIC, XPath2Type.DURATION);
                }
            }
        }
        return XPathType.UNKNOWN;
    }

    public static XPathType mapType(XPathExpression context, XPathType type) {
        return context.getXPathVersion() == XPathVersion.V2 ? XPath2Type.mapType(type) : type;
    }

    public static XPathType getPredicateType(XPathExpression expression) {
        return expression.getType() == XPathType.NUMBER ? XPathType.NUMBER : XPathType.BOOLEAN;
    }

    @Nullable
    private static Parameter findParameterDecl(XPathExpression[] argumentList, XPathExpression expr, Parameter[] parameters) {
        for (int i = 0; i < argumentList.length; ++i) {
            XPathExpression arg = argumentList[i];
            if (arg != expr) continue;
            if (i < parameters.length) {
                return parameters[i];
            }
            if (parameters.length <= 0) continue;
            Parameter last = parameters[parameters.length - 1];
            if (last.kind != Parameter.Kind.VARARG) continue;
            return last;
        }
        return null;
    }

    public static boolean isExplicitConversion(XPathExpression expression) {
        if (!((expression = ExpectedTypeUtil.unparenthesize(expression)) instanceof XPathFunctionCall)) {
            return false;
        }
        XPathFunctionCall call = (XPathFunctionCall)expression;
        if (call.getArgumentList().length != 1) {
            return false;
        }
        if (call.getQName().getPrefix() != null) {
            QName funcName;
            XPathType type = call.getType();
            if (type instanceof XPath2SequenceType) {
                type = ((XPath2SequenceType)type).getType();
            }
            return type instanceof XPath2Type && Comparing.equal((Object)(funcName = expression.getXPathContext().getQName(call)), (Object)((XPath2Type)type).getQName());
        }
        return XPathType.fromString(call.getFunctionName()) != XPathType.UNKNOWN;
    }

    @Nullable
    public static XPathExpression unparenthesize(XPathExpression expression) {
        while (expression instanceof XPathParenthesizedExpression) {
            expression = ((XPathParenthesizedExpression)expression).getExpression();
        }
        return expression;
    }

    private static class ExpectedTypeVisitor
    extends XPath2ElementVisitor {
        private final XPathExpression myExpression;
        private XPathType myExpectedType = XPathType.UNKNOWN;

        public ExpectedTypeVisitor(XPathExpression expression) {
            this.myExpression = expression;
        }

        @Override
        public void visitXPathPrefixExpression(XPathPrefixExpression o) {
            this.myExpectedType = XPathType.NUMBER;
        }

        @Override
        public void visitXPathBinaryExpression(XPathBinaryExpression parent) {
            if (this.myExpression == parent.getROperand()) {
                XPathElementType op = parent.getOperator();
                XPathExpression lop = parent.getLOperand();
                if (op == XPathTokenTypes.AND || op == XPathTokenTypes.OR) {
                    this.myExpectedType = XPathType.BOOLEAN;
                } else if (XPath2TokenTypes.NUMBER_OPERATIONS.contains((IElementType)op)) {
                    this.myExpectedType = ExpectedTypeVisitor.isXPath1(this.myExpression) ? XPathType.NUMBER : ExpectedTypeUtil.matchingType(lop, op);
                } else if (XPath2TokenTypes.COMP_OPS.contains((IElementType)op)) {
                    if (lop != null && lop.getType() != XPathType.NODESET) {
                        this.myExpectedType = lop.getType();
                        if (this.myExpectedType == XPathType.BOOLEAN) {
                            if (!ExpectedTypeVisitor.isXPath1(this.myExpression)) {
                                this.myExpectedType = XPath2Type.BOOLEAN_STRICT;
                            }
                        } else if (this.myExpectedType == XPath2Type.BOOLEAN) {
                            this.myExpectedType = XPath2Type.BOOLEAN_STRICT;
                        }
                    } else {
                        this.myExpectedType = XPathType.UNKNOWN;
                    }
                } else {
                    this.myExpectedType = XPath2TokenTypes.INTERSECT_EXCEPT.contains((IElementType)op) ? XPath2SequenceType.create(XPath2Type.NODE, XPath2SequenceType.Cardinality.ZERO_OR_MORE) : (op == XPath2TokenTypes.TO ? XPath2Type.INTEGER : XPathType.UNKNOWN);
                }
            } else {
                super.visitXPathBinaryExpression(parent);
            }
        }

        @Override
        public void visitXPathFunctionCall(XPathFunctionCall call) {
            Parameter p;
            Function functionDecl;
            XPathFunction xpathFunction = call.resolve();
            if (xpathFunction != null && (functionDecl = xpathFunction.getDeclaration()) != null && (p = ExpectedTypeUtil.findParameterDecl(call.getArgumentList(), this.myExpression, functionDecl.getParameters())) != null) {
                this.myExpectedType = p.type == XPath2Type.BOOLEAN ? XPath2Type.BOOLEAN_STRICT : p.type;
            }
        }

        @Override
        public void visitXPathFilterExpression(XPathFilterExpression filterExpression) {
            XPathExpression filteredExpression = filterExpression.getExpression();
            if (filteredExpression == this.myExpression) {
                this.myExpectedType = ExpectedTypeVisitor.isXPath1(this.myExpression) ? XPathType.NODESET : XPath2Type.SEQUENCE;
                return;
            }
            assert (filterExpression.getPredicate().getPredicateExpression() == this.myExpression);
            this.myExpectedType = ExpectedTypeUtil.getPredicateType(this.myExpression);
        }

        @Override
        public void visitXPathStep(XPathStep step) {
            XPathPredicate[] predicates;
            for (XPathPredicate predicate : predicates = step.getPredicates()) {
                if (predicate.getPredicateExpression() != this.myExpression) continue;
                this.myExpectedType = ExpectedTypeUtil.getPredicateType(this.myExpression);
                return;
            }
            this.myExpectedType = ExpectedTypeVisitor.isXPath1(step) ? XPathType.NODESET : (step.getStep() != null ? XPath2Type.SEQUENCE : XPath2Type.NODE);
        }

        @Override
        public void visitXPathLocationPath(XPathLocationPath expression) {
            this.myExpectedType = ExpectedTypeVisitor.isXPath1(this.myExpression) ? XPathType.NODESET : XPath2Type.SEQUENCE;
        }

        @Override
        public void visitXPath2If(XPath2If expression) {
            if (this.myExpression == expression.getCondition()) {
                this.myExpectedType = XPath2Type.BOOLEAN;
            }
        }

        @Override
        public void visitXPath2QuantifiedExpr(XPath2QuantifiedExpr expression) {
            if (this.myExpression == expression.getTest()) {
                this.myExpectedType = XPath2Type.BOOLEAN;
            }
        }

        public XPathType getExpectedType() {
            return this.myExpectedType;
        }

        private static boolean isXPath1(XPathExpression expression) {
            return expression.getXPathVersion() == XPathVersion.V1;
        }
    }
}

