/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithXslAttribute
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Replace with 'xsl:attribute'" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/intentions/ReplaceWithXslAttribute", "getText"));
        }
        return "Replace with 'xsl:attribute'";
    }

    @NotNull
    public String getFamilyName() {
        if ("Replace with xsl:attribute" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/intentions/ReplaceWithXslAttribute", "getFamilyName"));
        }
        return "Replace with xsl:attribute";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/intentions/ReplaceWithXslAttribute", "isAvailable"));
        }
        if (!XsltSupport.isXsltFile(file)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class, (boolean)false);
        if (attr == null || attr.getValueElement() == null) {
            return false;
        }
        if (XsltSupport.isXsltTag(attr.getParent())) {
            return false;
        }
        ASTNode node = attr.getNode();
        if (node == null) {
            return false;
        }
        ASTNode nameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
        if (nameNode == null) {
            return false;
        }
        return nameNode.getTextRange().contains(offset);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/intentions/ReplaceWithXslAttribute", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class, (boolean)false);
        assert (attr != null);
        XmlAttributeValue valueElement = attr.getValueElement();
        assert (valueElement != null);
        String s = attr.getValueTextRange().substring(valueElement.getText());
        ArrayList<Pair> chunks = new ArrayList<Pair>();
        StringBuilder builder = new StringBuilder(s.length());
        PsiFile[] files = XsltSupport.getFiles(attr);
        int i = 0;
        int j = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '{' && j < files.length) {
                if (i < s.length() - 1 && s.charAt(i) != '{') {
                    PsiFile f = files[j++];
                    if (builder.length() > 0) {
                        chunks.add(Pair.create((Object)builder.toString(), (Object)Boolean.FALSE));
                        builder.setLength(0);
                    }
                    chunks.add(Pair.create((Object)f.getText(), (Object)Boolean.TRUE));
                    if (s.charAt(i += f.getTextLength()) != '}') continue;
                    ++i;
                    continue;
                }
                builder.append(c);
                ++i;
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            chunks.add(Pair.create((Object)builder.toString(), (Object)Boolean.FALSE));
        }
        XmlTag parent = attr.getParent();
        XmlTag attrTag = parent.createChildTag("attribute", "http://www.w3.org/1999/XSL/Transform", null, false);
        attrTag.setAttribute("name", attr.getName());
        String value = attr.getNamespace();
        if (value.length() > 0) {
            attrTag.setAttribute("namespace", value);
        }
        for (Pair chunk : chunks) {
            XmlTag child;
            if (((Boolean)chunk.second).booleanValue()) {
                child = parent.createChildTag("value-of", "http://www.w3.org/1999/XSL/Transform", null, false);
                child.setAttribute("select", (String)chunk.first);
            } else {
                child = parent.createChildTag("text", "http://www.w3.org/1999/XSL/Transform", null, false);
                child.add((PsiElement)XmlElementFactory.getInstance((Project)child.getProject()).createDisplayText((String)chunk.first));
            }
            attrTag.add((PsiElement)child);
        }
        PsiElement child = XsltCodeInsightUtil.findFirstRealTagChild(parent);
        if (child != null) {
            parent.addBefore((PsiElement)attrTag, child);
        } else {
            parent.add((PsiElement)attrTag);
        }
        attr.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

