/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.ClassAwareSuiteMethod;
import com.intellij.junit4.IdeaSuite;
import com.intellij.junit4.IdeaSuite48;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.SuiteMethodBuilder;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class JUnit46ClassesRequestBuilder {
    private JUnit46ClassesRequestBuilder() {
    }

    public static Request getClassesRequest(String suiteName, Class[] classes, Map classMethods, Class category) {
        boolean canUseSuiteMethod = JUnit46ClassesRequestBuilder.canUseSuiteMethod(classMethods);
        try {
            IdeaSuite suite;
            if (category != null) {
                try {
                    Class.forName("org.junit.experimental.categories.Categories");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Categories are not available");
                }
            }
            if (canUseSuiteMethod) {
                try {
                    Class.forName("org.junit.experimental.categories.Categories");
                    suite = new IdeaSuite48(JUnit46ClassesRequestBuilder.collectWrappedRunners(classes), suiteName, category);
                }
                catch (ClassNotFoundException e) {
                    suite = new IdeaSuite(JUnit46ClassesRequestBuilder.collectWrappedRunners(classes), suiteName);
                }
            } else {
                AllDefaultPossibilitiesBuilder builder = new AllDefaultPossibilitiesBuilder(canUseSuiteMethod);
                try {
                    Class.forName("org.junit.experimental.categories.Categories");
                    suite = new IdeaSuite48((RunnerBuilder)builder, classes, suiteName, category);
                }
                catch (ClassNotFoundException e) {
                    suite = new IdeaSuite((RunnerBuilder)builder, classes, suiteName);
                }
            }
            return Request.runner((Runner)suite);
        }
        catch (InitializationError e) {
            throw new RuntimeException(e);
        }
    }

    private static List collectWrappedRunners(Class[] classes) throws InitializationError {
        ArrayList<ClassAwareSuiteMethod> runners = new ArrayList<ClassAwareSuiteMethod>();
        ArrayList<Class> nonSuiteClasses = new ArrayList<Class>();
        SuiteMethodBuilder suiteMethodBuilder = new SuiteMethodBuilder();
        int length = classes.length;
        for (int i = 0; i < length; ++i) {
            Class aClass = classes[i];
            if (suiteMethodBuilder.hasSuiteMethod(aClass)) {
                try {
                    runners.add(new ClassAwareSuiteMethod(aClass));
                }
                catch (Throwable throwable) {
                    runners.add((ClassAwareSuiteMethod)new ErrorReportingRunner(aClass, throwable));
                }
                continue;
            }
            nonSuiteClasses.add(aClass);
        }
        runners.addAll(new AllDefaultPossibilitiesBuilder(false).runners(null, nonSuiteClasses.toArray(new Class[nonSuiteClasses.size()])));
        return runners;
    }

    private static boolean canUseSuiteMethod(Map classMethods) {
        Iterator iterator = classMethods.keySet().iterator();
        while (iterator.hasNext()) {
            Object className = iterator.next();
            Set methods = (Set)classMethods.get(className);
            if (methods == null) {
                return true;
            }
            Iterator iterator1 = methods.iterator();
            while (iterator1.hasNext()) {
                String methodName = (String)iterator1.next();
                if (!"suite".equals(methodName)) continue;
                return true;
            }
        }
        return classMethods.isEmpty();
    }
}

