/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="AndroidLayouts", storages={@Storage(id="AndroidLayouts", file="$WORKSPACE_FILE$")})
public class ConfigurationStateManager
implements PersistentStateComponent<State> {
    private final Map<VirtualFile, ConfigurationFileState> myFileToState = new HashMap();
    private ConfigurationProjectState myProjectState = new ConfigurationProjectState();

    @NotNull
    public static ConfigurationStateManager get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/configurations/ConfigurationStateManager", "get"));
        }
        ConfigurationStateManager configurationStateManager = (ConfigurationStateManager)ServiceManager.getService((Project)project, ConfigurationStateManager.class);
        if (configurationStateManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationStateManager", "get"));
        }
        return configurationStateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ConfigurationFileState getConfigurationState(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/configurations/ConfigurationStateManager", "getConfigurationState"));
        }
        Map<VirtualFile, ConfigurationFileState> map = this.myFileToState;
        synchronized (map) {
            return this.myFileToState.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurationState(@NotNull VirtualFile file, @NotNull ConfigurationFileState state) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/configurations/ConfigurationStateManager", "setConfigurationState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/configurations/ConfigurationStateManager", "setConfigurationState"));
        }
        Map<VirtualFile, ConfigurationFileState> map = this.myFileToState;
        synchronized (map) {
            this.myFileToState.put(file, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigurationState(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/configurations/ConfigurationStateManager", "removeConfigurationState"));
        }
        Map<VirtualFile, ConfigurationFileState> map = this.myFileToState;
        synchronized (map) {
            this.myFileToState.remove(file);
        }
    }

    @NotNull
    public ConfigurationProjectState getProjectState() {
        ConfigurationProjectState configurationProjectState = this.myProjectState;
        if (configurationProjectState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationStateManager", "getProjectState"));
        }
        return configurationProjectState;
    }

    void setProjectState(@NotNull ConfigurationProjectState projectState) {
        if (projectState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectState", "com/android/tools/idea/configurations/ConfigurationStateManager", "setProjectState"));
        }
        this.myProjectState = projectState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        HashMap urlToState = new HashMap();
        Map<VirtualFile, ConfigurationFileState> map = this.myFileToState;
        synchronized (map) {
            for (Map.Entry<VirtualFile, ConfigurationFileState> entry : this.myFileToState.entrySet()) {
                urlToState.put(entry.getKey().getUrl(), entry.getValue());
            }
        }
        State state = new State();
        state.setUrlToStateMap((Map<String, ConfigurationFileState>)urlToState);
        state.setProjectState(this.myProjectState);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(State state) {
        this.myProjectState = state.getProjectState();
        Map<VirtualFile, ConfigurationFileState> map = this.myFileToState;
        synchronized (map) {
            this.myFileToState.clear();
            for (Map.Entry<String, ConfigurationFileState> entry : state.getUrlToStateMap().entrySet()) {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(entry.getKey());
                if (file == null) continue;
                this.myFileToState.put(file, entry.getValue());
            }
        }
    }

    public static class State {
        private ConfigurationProjectState myProjectState;
        private Map<String, ConfigurationFileState> myUrlToStateMap = new HashMap();

        @Tag(value="shared")
        @Property(surroundWithTag=false)
        public ConfigurationProjectState getProjectState() {
            return this.myProjectState;
        }

        public void setProjectState(ConfigurationProjectState projectState) {
            this.myProjectState = projectState;
        }

        @Tag(value="layouts")
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundValueWithTag=false, surroundKeyWithTag=false, keyAttributeName="url", entryTagName="layout")
        public Map<String, ConfigurationFileState> getUrlToStateMap() {
            return this.myUrlToStateMap;
        }

        public void setUrlToStateMap(Map<String, ConfigurationFileState> urlToState) {
            this.myUrlToStateMap = urlToState;
        }
    }
}

