/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.HashSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentationController {
    @NotNull
    private final JTextPane myView;
    @NotNull
    private Map<String, String> myDocumentationCache;
    @NotNull
    private Set<String> myRequestInProgress;
    private String myTargetUrl;

    public DocumentationController(@NotNull JTextPane textPane) {
        if (textPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textPane", "com/android/tools/idea/editors/gfxtrace/controllers/DocumentationController", "<init>"));
        }
        this.myDocumentationCache = new HashMap<String, String>();
        this.myRequestInProgress = new HashSet();
        this.myView = textPane;
        this.myView.setBorder(BorderFactory.createLineBorder(JBColor.border()));
    }

    public void setDocumentation(final @Nullable String url) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myView.setText(null);
        if (url == null || url.isEmpty()) {
            return;
        }
        this.myTargetUrl = url;
        final String cachedCopy = this.myDocumentationCache.get(url);
        if (cachedCopy == null) {
            if (this.myRequestInProgress.contains(url)) {
                return;
            }
            this.myRequestInProgress.add(url);
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                boolean problemEncountered = false;
                String validCopy = cachedCopy;
                if (validCopy == null) {
                    try {
                        URLConnection connection = new URL(url).openConnection();
                        InputStream response = connection.getInputStream();
                        Scanner s = new Scanner(response).useDelimiter("\\A");
                        validCopy = s.hasNext() ? s.next() : "";
                    }
                    catch (MalformedURLException e) {
                        problemEncountered = true;
                    }
                    catch (IOException e) {
                        problemEncountered = true;
                    }
                }
                final String documentation = validCopy;
                final boolean error = problemEncountered;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (error) {
                            DocumentationController.this.myRequestInProgress.remove(url);
                        } else if (url.equals(DocumentationController.this.myTargetUrl)) {
                            DocumentationController.this.myView.setText(documentation);
                        }
                        DocumentationController.this.myDocumentationCache.put(url, documentation);
                    }
                });
            }
        });
    }
}

