/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.schema;

import com.android.tools.idea.editors.gfxtrace.rpc.AtomInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.AtomStream;
import com.android.tools.idea.editors.gfxtrace.rpc.ParameterInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.Schema;
import com.android.tools.idea.editors.gfxtrace.schema.Atom;
import com.android.tools.idea.editors.gfxtrace.schema.Parameter;
import com.android.tools.idea.editors.gfxtrace.schema.Unpack;
import com.android.tools.rpclib.binary.Decoder;
import gnu.trove.TIntIntHashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class AtomReader {
    private final Schema mSchema;
    private final byte[] mData;
    private final List<Segment> mAtomSegments;
    private final TIntIntHashMap atomTypeToIndex;

    public AtomReader(AtomStream stream, Schema schema) throws IOException {
        this.mSchema = schema;
        this.mData = stream.getData();
        this.mAtomSegments = new ArrayList<Segment>();
        this.atomTypeToIndex = new TIntIntHashMap(schema.getAtoms().length);
        AtomInfo[] atomInfos = schema.getAtoms();
        for (int i = 0; i < atomInfos.length; ++i) {
            assert (!this.atomTypeToIndex.containsValue(i));
            this.atomTypeToIndex.put((int)atomInfos[i].getType(), i);
        }
        this.calculateAtomInfos();
    }

    public int count() {
        return this.mAtomSegments.size();
    }

    private Atom unpack(Decoder decoder) throws IOException {
        short type = decoder.uint16();
        int contextId = decoder.int32();
        assert (contextId >= 0);
        if (!this.atomTypeToIndex.containsKey((int)type)) {
            throw new RuntimeException("Atom type " + type + " not found in schema.");
        }
        AtomInfo atomInfo = this.mSchema.getAtoms()[this.atomTypeToIndex.get((int)type)];
        Parameter[] parameters = new Parameter[atomInfo.getParameters().length];
        for (int i = 0; i < parameters.length; ++i) {
            ParameterInfo parameterInfo = atomInfo.getParameters()[i];
            Object value = Unpack.Type(atomInfo.getParameters()[i].getType(), decoder);
            parameters[i] = new Parameter(parameterInfo, value);
        }
        return new Atom(contextId, atomInfo, parameters);
    }

    public Atom read(long index) throws IOException {
        assert (index <= Integer.MAX_VALUE);
        Segment segment = this.mAtomSegments.get((int)index);
        ByteArrayInputStream stream = new ByteArrayInputStream(this.mData, segment.mOffset, segment.mSize);
        Decoder decoder = new Decoder((InputStream)stream);
        return this.unpack(decoder);
    }

    private void calculateAtomInfos() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.mData);
        Decoder decoder = new Decoder((InputStream)stream);
        int total = stream.available();
        long count = decoder.uint32();
        int i = 0;
        while ((long)i < count) {
            int remains = stream.available();
            int offset = total - remains;
            this.unpack(decoder);
            int size = remains - stream.available();
            this.mAtomSegments.add(new Segment(offset, size));
            ++i;
        }
    }

    private static class Segment {
        private final int mOffset;
        private final int mSize;

        private Segment(int offset, int size) {
            this.mOffset = offset;
            this.mSize = size;
        }
    }
}

