/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.tools.idea.editors.navigation.NavigationEditorUtils;
import com.android.tools.idea.editors.navigation.macros.CodeTemplate;
import com.android.tools.idea.editors.navigation.macros.MultiMatch;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import java.util.IdentityHashMap;
import java.util.Map;

public class Macros {
    private static final String CREATE_INTENT = "void macro(Context context, Class activityClass) { new android.content.Intent(context, activityClass); }";
    private static final String DEFINE_INNER_CLASS = "void macro(Class $Interface, Void $method, Class $Type, Object $arg, final Statement $f) {    new $Interface() {        public void $method($Type $arg) {            $f.$();        }    };}";
    private static final String INSTALL_CLICK_LISTENER = "void macro(android.view.View $view, Statement $f) {    $view.setOnClickListener(new android.view.View.OnClickListener() {        @Override        public void onClick(android.view.View view) {            $f.$();        }    });}";
    private static final String INSTALL_MENU_ITEM_CLICK_LISTENER = "void macro(android.view.MenuItem $menuItem, final Statement $f, final boolean $consume) {    $menuItem.setOnMenuItemClickListener(new android.view.MenuItem.OnMenuItemClickListener() {        @Override        public boolean onMenuItemClick(android.view.MenuItem menuItem) {            $f.$();            return $consume;        }    });}";
    private static final String INSTALL_ITEM_CLICK_LISTENER = "void macro(ListView $listView, final Statement $f) {    $listView.setOnItemClickListener(new android.widget.AdapterView.OnItemClickListener() {        @Override        public void onItemClick(android.widget.AdapterView<?> parent, android.view.View view, int position, long id) {            $f.$$();        }    });}";
    private static final String FIND_MENU_ITEM = "void macro(Menu $menu, int $id) {    $menu.findItem(R.id.$id);}";
    private static final String FIND_VIEW_BY_ID_1 = "void macro(int $id) { findViewById(R.id.$id);}";
    private static final String FIND_VIEW_BY_ID_2 = "void macro(Object $finder, int $id) { $finder.findViewById(R.id.$id);}";
    public static final String FIND_FRAGMENT_BY_TAG = "void macro(void $fragmentManager, int $tag) { $fragmentManager.findFragmentByTag($tag);}";
    private static final String LAUNCH_ACTIVITY_WITH_ARG = "<T extends Serializable> void macro(Context context, Class activityClass, String name, T value) {    context.startActivity(new android.content.Intent(context, activityClass).putExtra(name, value));}";
    public final MultiMatch createIntent;
    public final MultiMatch installClickAndCallMacro;
    public final MultiMatch installItemClickAndCallMacro;
    public final MultiMatch installMenuItemClickAndCallMacro;
    public final MultiMatch defineInnerClassToLaunchActivityMacro;
    public final MultiMatch findMenuItem;
    public final MultiMatch findViewById1;
    public final MultiMatch findViewById2;
    public final MultiMatch findFragmentByTag;
    private static Map<Project, Macros> ourProjectToMacros = new IdentityHashMap<Project, Macros>();
    private final Project myProject;

    public static Macros getInstance(Project project) {
        Macros result = ourProjectToMacros.get(project);
        if (result == null) {
            result = new Macros(project);
            ourProjectToMacros.put(project, result);
        }
        return result;
    }

    public MultiMatch createMacro(String methodDefinition) {
        return new MultiMatch(CodeTemplate.fromMethod(this.getMethodFromText(methodDefinition)));
    }

    private PsiMethod getMethodFromText(String definition) {
        return NavigationEditorUtils.createMethodFromText(this.myProject, definition, null);
    }

    private Macros(Project project) {
        this.myProject = project;
        this.createIntent = this.createMacro(CREATE_INTENT);
        this.findMenuItem = this.createMacro(FIND_MENU_ITEM);
        this.findViewById1 = this.createMacro(FIND_VIEW_BY_ID_1);
        this.findViewById2 = this.createMacro(FIND_VIEW_BY_ID_2);
        this.findFragmentByTag = this.createMacro(FIND_FRAGMENT_BY_TAG);
        this.installClickAndCallMacro = this.createMacro(INSTALL_CLICK_LISTENER);
        this.installItemClickAndCallMacro = this.createMacro(INSTALL_ITEM_CLICK_LISTENER);
        this.installMenuItemClickAndCallMacro = this.createMacro(INSTALL_MENU_ITEM_CLICK_LISTENER);
        this.defineInnerClassToLaunchActivityMacro = this.createMacro(DEFINE_INNER_CLASS);
        this.defineInnerClassToLaunchActivityMacro.addSubMacro("$f", CodeTemplate.fromMethod(this.getMethodFromText(LAUNCH_ACTIVITY_WITH_ARG)));
    }
}

