/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

abstract class ResourceComponent
extends JPanel {
    private static final String COLOR_LIGHT = "6F6F6F";
    private static final String COLOR_DARCULA = "AAAAAA";
    private static final String LABEL_TEMPLATE = "<html><nobr><b><font color=\"#%1$s\">%2$s</font></b><font color=\"#9B9B9B\"> - %3$s</font>";
    private static final int DISTANCE_BETWEEN_ROWS = 20;
    private static final int LABEL_BUTTON_GAP = 8;
    private static final int BUTTON_VERTICAL_PADDINGS = 14;
    public static final int SUM_PADDINGS = 42;
    private final ResourceChooserButton myResourceChooserButton = new ResourceChooserButton();
    private final JLabel myNameLabel = new JLabel();

    public ResourceComponent() {
        super(new BorderLayout(0, 8));
        this.setBorder(BorderFactory.createMatteBorder(10, 0, 10, 0, this.getBackground()));
        this.add((Component)this.myNameLabel, "North");
        this.myResourceChooserButton.setBorder(null);
        this.myResourceChooserButton.setBackground((Color)JBColor.WHITE);
        this.myResourceChooserButton.setForeground(null);
        this.add((Component)this.myResourceChooserButton, "Center");
    }

    abstract int getIconCount();

    abstract Icon getIconAt(int var1);

    abstract void setIconHeight(int var1);

    public void configure(String name, String type, String value) {
        String firstColor = UIUtil.isUnderDarcula() ? COLOR_DARCULA : COLOR_LIGHT;
        this.myNameLabel.setText(String.format(LABEL_TEMPLATE, firstColor, name, type));
        this.myResourceChooserButton.setText(value);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myResourceChooserButton != null) {
            this.myResourceChooserButton.setFont(font);
        }
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu popup) {
        super.setComponentPopupMenu(popup);
        this.myResourceChooserButton.setComponentPopupMenu(popup);
    }

    public void addActionListener(ActionListener listener) {
        this.myResourceChooserButton.addActionListener(listener);
    }

    class ResourceChooserButton
    extends JButton {
        private static final int BETWEEN_STATES_PADDING = 2;
        private static final int STATES_PADDING = 6;
        private static final int ARC_SIZE = 10;

        ResourceChooserButton() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            GraphicsUtil.setupAAPainting((Graphics)g);
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(this.getBackground());
            g.fillRoundRect(0, 0, width - 1, height - 1, 10, 10);
            g.setColor((Color)Gray._170);
            g.drawRoundRect(0, 0, width - 1, height - 1, 10, 10);
            int xOffset = 2;
            for (int c = 0; c < ResourceComponent.this.getIconCount(); ++c) {
                Icon icon = ResourceComponent.this.getIconAt(c);
                icon.paintIcon(this, g, xOffset, 2);
                xOffset += icon.getIconWidth() + 2;
            }
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.getForeground());
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            g.drawString(this.getText(), xOffset += 4, yOffset);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            ResourceComponent.this.setIconHeight(height - 4);
        }
    }
}

