/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.entity;

import com.android.tools.idea.gradle.editor.entity.AbstractGradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDeclarationValueLocationAware;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDefinitionValueLocationAware;
import com.android.tools.idea.gradle.editor.metadata.GradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.value.GradleEditorEntityValueManager;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleGradleEditorEntity
extends AbstractGradleEditorEntity
implements GradleEntityDeclarationValueLocationAware,
GradleEntityDefinitionValueLocationAware {
    @NotNull
    private final String myName;
    @NotNull
    private final List<GradleEditorSourceBinding> myDefinitionValueSourceBindings;
    @NotNull
    private final GradleEditorEntityValueManager myValueManager;
    @NotNull
    private final GradleEditorSourceBinding myDeclarationValueLocation;
    @NotNull
    private String myCurrentValue;

    public AbstractSimpleGradleEditorEntity(@NotNull String name, @NotNull String currentValue, @NotNull Collection<GradleEditorSourceBinding> definitionValueSourceBindings, @NotNull GradleEditorSourceBinding entityLocation, @NotNull Set<GradleEditorEntityMetaData> metaData, @NotNull GradleEditorSourceBinding declarationValueLocation, @NotNull GradleEditorEntityValueManager valueManager, @Nullable String helpUrl) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "<init>"));
        }
        if (currentValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "<init>"));
        }
        if (definitionValueSourceBindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionValueSourceBindings", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "<init>"));
        }
        if (entityLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entityLocation", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "<init>"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "<init>"));
        }
        if (declarationValueLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationValueLocation", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "<init>"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "<init>"));
        }
        super(entityLocation, metaData, helpUrl);
        this.myName = name;
        this.myCurrentValue = currentValue;
        this.myDefinitionValueSourceBindings = ImmutableList.copyOf(definitionValueSourceBindings);
        this.myDeclarationValueLocation = declarationValueLocation;
        this.myValueManager = valueManager;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "getName"));
        }
        return string;
    }

    @NotNull
    public String getCurrentValue() {
        String string = this.myCurrentValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "getCurrentValue"));
        }
        return string;
    }

    @Override
    @NotNull
    public GradleEditorSourceBinding getDeclarationValueLocation() {
        GradleEditorSourceBinding gradleEditorSourceBinding = this.myDeclarationValueLocation;
        if (gradleEditorSourceBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "getDeclarationValueLocation"));
        }
        return gradleEditorSourceBinding;
    }

    @Override
    @Nullable
    public GradleEditorSourceBinding getDefinitionValueLocation() {
        return this.myDefinitionValueSourceBindings.size() == 1 ? this.myDefinitionValueSourceBindings.get(0) : null;
    }

    @Nullable
    public String changeValue(@NotNull String newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "changeValue"));
        }
        if (newValue.equals(this.getCurrentValue())) {
            return null;
        }
        List<GradleEditorSourceBinding> sourceBindings = this.getDefinitionValueSourceBindings();
        if (sourceBindings.size() != 1) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: expected the entity to hold only one source binding but it has %d (%s)", newValue, this, sourceBindings.size(), sourceBindings);
        }
        GradleEditorSourceBinding binding = sourceBindings.get(0);
        RangeMarker rangeMarker = binding.getRangeMarker();
        if (!rangeMarker.isValid()) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: source file binding is incorrect", newValue, this);
        }
        this.myCurrentValue = newValue;
        rangeMarker.getDocument().replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)newValue);
        return null;
    }

    @NotNull
    public List<GradleEditorSourceBinding> getDefinitionValueSourceBindings() {
        List<GradleEditorSourceBinding> list = this.myDefinitionValueSourceBindings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "getDefinitionValueSourceBindings"));
        }
        return list;
    }

    @NotNull
    public GradleEditorEntityValueManager getValueManager() {
        GradleEditorEntityValueManager gradleEditorEntityValueManager = this.myValueManager;
        if (gradleEditorEntityValueManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/AbstractSimpleGradleEditorEntity", "getValueManager"));
        }
        return gradleEditorEntityValueManager;
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myDeclarationValueLocation);
        for (GradleEditorSourceBinding sourceBinding : this.myDefinitionValueSourceBindings) {
            Disposer.dispose((Disposable)sourceBinding);
        }
    }

    public String toString() {
        String value;
        List<GradleEditorSourceBinding> bindings = this.getDefinitionValueSourceBindings();
        if (bindings.isEmpty()) {
            value = "<undefined>";
        } else if (bindings.size() > 1) {
            value = "<ref>";
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(bindings.get(0).getFile());
            RangeMarker rangeMarker = bindings.get(0).getRangeMarker();
            value = document == null ? "<unexpected!>" : '[' + document.getCharsSequence().subSequence(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()).toString() + ']';
        }
        return this.getName() + " " + value;
    }
}

