/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProperties {
    @NonNls
    private static final String PROXY_HOST_PROPERTY_NAME = "systemProp.http.proxyHost";
    @NonNls
    private static final String PROXY_PORT_PROPERTY_NAME = "systemProp.http.proxyPort";
    @NonNls
    private static final String PROXY_USER_PROPERTY_NAME = "systemProp.http.proxyUser";
    @NonNls
    private static final String PROXY_PASSWORD_PROPERTY_NAME = "systemProp.http.proxyPassword";
    @NonNls
    private static final String PROXY_EXCEPTIONS_PROPERTY_NAME = "systemProp.http.nonProxyHosts";
    @NonNls
    private static final String JVM_ARGS_PROPERTY_NAME = "org.gradle.jvmargs";
    @NotNull
    private final File myPath;
    private final Properties myProperties;

    public GradleProperties(@NotNull Project project) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleProperties", "<init>"));
        }
        this(new File(Projects.getBaseDirPath(project), "gradle.properties"));
    }

    @VisibleForTesting
    GradleProperties(@NotNull File path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/util/GradleProperties", "<init>"));
        }
        this.myPath = path;
        this.myProperties = PropertiesUtil.getProperties(this.myPath);
    }

    @VisibleForTesting
    String getProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/util/GradleProperties", "getProperty"));
        }
        return this.myProperties.getProperty(name);
    }

    @NotNull
    public ProxySettings getProxySettings() {
        ProxySettings proxySettings = new ProxySettings(this.myProperties);
        if (proxySettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleProperties", "getProxySettings"));
        }
        return proxySettings;
    }

    public void setProxySettings(@NotNull ProxySettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/android/tools/idea/gradle/util/GradleProperties", "setProxySettings"));
        }
        this.myProperties.setProperty(PROXY_HOST_PROPERTY_NAME, settings.getHost());
        this.myProperties.setProperty(PROXY_PORT_PROPERTY_NAME, String.valueOf(settings.myPort));
        if (StringUtil.isEmpty((String)settings.myUser)) {
            this.myProperties.remove(PROXY_USER_PROPERTY_NAME);
            this.myProperties.remove(PROXY_PASSWORD_PROPERTY_NAME);
        } else {
            this.myProperties.setProperty(PROXY_USER_PROPERTY_NAME, settings.myUser);
            this.myProperties.setProperty(PROXY_PASSWORD_PROPERTY_NAME, Strings.nullToEmpty((String)settings.myPassword));
        }
        if (StringUtil.isEmpty((String)settings.myExceptions)) {
            this.myProperties.remove(PROXY_EXCEPTIONS_PROPERTY_NAME);
        } else {
            this.myProperties.setProperty(PROXY_EXCEPTIONS_PROPERTY_NAME, settings.myExceptions);
        }
    }

    public void save() throws IOException {
        PropertiesUtil.savePropertiesToFile(this.myProperties, this.myPath, GradleProperties.getHeaderComment());
    }

    @NotNull
    private static String getHeaderComment() {
        Object[] lines = new String[]{"# Project-wide Gradle settings.", "", "# For more details on how to configure your build environment visit", "# http://www.gradle.org/docs/current/userguide/build_environment.html", "", "# Specifies the JVM arguments used for the daemon process.", "# The setting is particularly useful for tweaking memory settings.", "# Default value: -Xmx10248m -XX:MaxPermSize=256m", "# org.gradle.jvmargs=-Xmx2048m -XX:MaxPermSize=512m -XX:+HeapDumpOnOutOfMemoryError -Dfile.encoding=UTF-8", "", "# When configured, Gradle will run in incubating parallel mode.", "# This option should only be used with decoupled projects. More details, visit", "# http://www.gradle.org/docs/current/userguide/multi_project_builds.html#sec:decoupled_projects", "# org.gradle.parallel=true"};
        String string = Joiner.on((String)SystemProperties.getLineSeparator()).join(lines);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleProperties", "getHeaderComment"));
        }
        return string;
    }

    public void setJvmArgs(@NotNull String jvmArgs) {
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/util/GradleProperties", "setJvmArgs"));
        }
        this.myProperties.setProperty(JVM_ARGS_PROPERTY_NAME, jvmArgs);
    }

    @Nullable
    public String getJvmArgs() {
        return this.myProperties.getProperty(JVM_ARGS_PROPERTY_NAME);
    }

    public static class ProxySettings {
        @Nullable
        private String myHost;
        @Nullable
        private String myExceptions;
        @Nullable
        private String myUser;
        @Nullable
        private String myPassword;
        private int myPort;

        public ProxySettings(@NotNull Properties properties) {
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/gradle/util/GradleProperties$ProxySettings", "<init>"));
            }
            this.myPort = 80;
            this.myHost = properties.getProperty(GradleProperties.PROXY_HOST_PROPERTY_NAME);
            String portValue = properties.getProperty(GradleProperties.PROXY_PORT_PROPERTY_NAME);
            if (StringUtil.isNotEmpty((String)portValue)) {
                try {
                    this.myPort = Integer.parseInt(portValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Nullable
        public String getHost() {
            return this.myHost;
        }

        public void copyFrom(@NotNull HttpConfigurable ideProxySettings) {
            if (ideProxySettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProxySettings", "com/android/tools/idea/gradle/util/GradleProperties$ProxySettings", "copyFrom"));
            }
            this.myHost = ideProxySettings.PROXY_HOST;
            this.myPort = ideProxySettings.PROXY_PORT;
            if (ideProxySettings.PROXY_AUTHENTICATION) {
                this.myUser = ideProxySettings.PROXY_LOGIN;
                this.myPassword = ideProxySettings.getPlainProxyPassword();
            }
            this.myExceptions = ideProxySettings.PROXY_EXCEPTIONS;
        }

        public int getPort() {
            return this.myPort;
        }
    }
}

