/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildTypeContainer;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.model.ManifestInfo;
import com.intellij.openapi.module.Module;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleInfo {
    @NotNull
    private final AndroidFacet myFacet;

    private AndroidModuleInfo(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/model/AndroidModuleInfo", "<init>"));
        }
        this.myFacet = facet;
    }

    @NotNull
    public static AndroidModuleInfo create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/model/AndroidModuleInfo", "create"));
        }
        AndroidModuleInfo androidModuleInfo = new AndroidModuleInfo(facet);
        if (androidModuleInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "create"));
        }
        return androidModuleInfo;
    }

    @NotNull
    public static AndroidModuleInfo get(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/model/AndroidModuleInfo", "get"));
        }
        AndroidModuleInfo androidModuleInfo = facet.getAndroidModuleInfo();
        if (androidModuleInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "get"));
        }
        return androidModuleInfo;
    }

    @Nullable
    public static AndroidModuleInfo get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/model/AndroidModuleInfo", "get"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? facet.getAndroidModuleInfo() : null;
    }

    @Nullable
    public String getPackage() {
        IdeaAndroidProject project = this.myFacet.getIdeaAndroidProject();
        if (project != null) {
            return project.computePackageName();
        }
        return ManifestInfo.get(this.myFacet.getModule(), false).getPackage();
    }

    @NotNull
    public AndroidVersion getRuntimeMinSdkVersion() {
        ApiVersion minSdkVersion;
        IdeaAndroidProject project = this.myFacet.getIdeaAndroidProject();
        if (project != null && (minSdkVersion = project.getSelectedVariant().getMergedFlavor().getMinSdkVersion()) != null) {
            AndroidVersion androidVersion = new AndroidVersion(minSdkVersion.getApiLevel(), minSdkVersion.getCodename());
            if (androidVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "getRuntimeMinSdkVersion"));
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = ManifestInfo.get(this.myFacet.getModule(), false).getMinSdkVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "getRuntimeMinSdkVersion"));
        }
        return androidVersion;
    }

    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion minSdkVersion;
        IdeaAndroidProject project = this.myFacet.getIdeaAndroidProject();
        if (project != null && (minSdkVersion = project.getConfigMinSdkVersion()) != null) {
            AndroidVersion androidVersion = minSdkVersion;
            if (androidVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "getMinSdkVersion"));
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = ManifestInfo.get(this.myFacet.getModule(), false).getMinSdkVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "getMinSdkVersion"));
        }
        return androidVersion;
    }

    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        ApiVersion targetSdkVersion;
        IdeaAndroidProject project = this.myFacet.getIdeaAndroidProject();
        if (project != null && (targetSdkVersion = project.getSelectedVariant().getMergedFlavor().getTargetSdkVersion()) != null) {
            AndroidVersion androidVersion = new AndroidVersion(targetSdkVersion.getApiLevel(), targetSdkVersion.getCodename());
            if (androidVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "getTargetSdkVersion"));
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = ManifestInfo.get(this.myFacet.getModule(), false).getTargetSdkVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "getTargetSdkVersion"));
        }
        return androidVersion;
    }

    @Nullable
    public AndroidVersion getBuildSdkVersion() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
        if (platform != null) {
            return platform.getApiVersion();
        }
        return null;
    }

    @Nullable
    public Boolean isDebuggable() {
        BuildTypeContainer buildTypeContainer;
        IdeaAndroidProject project = this.myFacet.getIdeaAndroidProject();
        if (project != null && (buildTypeContainer = project.findBuildType(project.getSelectedVariant().getBuildType())) != null) {
            return buildTypeContainer.getBuildType().isDebuggable();
        }
        return ManifestInfo.get(this.myFacet.getModule(), false).getApplicationDebuggable();
    }

    @Nullable
    public static AndroidVersion getBuildSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            return moduleInfo.getBuildSdkVersion();
        }
        return null;
    }

    public static int getBuildSdkApiLevel(@Nullable Module module) {
        AndroidVersion version = AndroidModuleInfo.getBuildSdkVersion(module);
        return version != null ? version.getApiLevel() : -1;
    }

    @NotNull
    public static AndroidVersion getTargetSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            AndroidVersion androidVersion = moduleInfo.getTargetSdkVersion();
            if (androidVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "getTargetSdkVersion"));
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = AndroidVersion.DEFAULT;
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "getTargetSdkVersion"));
        }
        return androidVersion;
    }

    @NotNull
    public static AndroidVersion getMinSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            AndroidVersion androidVersion = moduleInfo.getMinSdkVersion();
            if (androidVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "getMinSdkVersion"));
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = AndroidVersion.DEFAULT;
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/AndroidModuleInfo", "getMinSdkVersion"));
        }
        return androidVersion;
    }
}

