/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.ddmlib.Client;
import com.android.tools.chartlib.TimelineData;
import com.android.tools.idea.monitor.TimelineEventListener;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeviceSampler
implements Runnable {
    public static final int TYPE_UNREACHABLE = 0;
    public static final int TYPE_DATA = 1;
    public static final int TYPE_TIMEOUT = 2;
    public static final int INHERITED_TYPE_START = 3;
    @NotNull
    protected final TimelineData myData;
    @NotNull
    protected final List<TimelineEventListener> myListeners;
    protected int mySampleFrequencyMs;
    @Nullable
    protected volatile Future<?> myExecutingTask;
    @Nullable
    protected volatile Client myClient;
    @NotNull
    private final Semaphore myDataSemaphore;
    protected volatile boolean myRunning;

    public DeviceSampler(@NotNull TimelineData data, int sampleFrequencyMs) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/monitor/DeviceSampler", "<init>"));
        }
        this.myListeners = Lists.newLinkedList();
        this.myData = data;
        this.mySampleFrequencyMs = sampleFrequencyMs;
        this.myDataSemaphore = new Semaphore(0, true);
    }

    public void start() {
        if (this.myExecutingTask == null && this.myClient != null) {
            this.myRunning = true;
            this.myExecutingTask = ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
            this.myClient.setHeapInfoUpdateEnabled(true);
            for (TimelineEventListener listener : this.myListeners) {
                listener.onStart();
            }
        }
    }

    public void stop() {
        if (this.myExecutingTask != null) {
            this.myRunning = false;
            this.myDataSemaphore.release();
            this.myData.clear();
            try {
                this.myExecutingTask.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            if (this.myClient != null) {
                this.myClient.setHeapInfoUpdateEnabled(false);
            }
            this.myExecutingTask = null;
            for (TimelineEventListener listener : this.myListeners) {
                listener.onStop();
            }
        }
    }

    public void setClient(@Nullable Client client) {
        if (client != this.myClient) {
            this.stop();
            this.myClient = client;
            this.myData.clear();
            this.start();
        }
    }

    public void addListener(TimelineEventListener listener) {
        this.myListeners.add(listener);
    }

    public boolean isRunning() {
        return this.myExecutingTask != null && this.myRunning;
    }

    protected void forceSample() {
        this.myDataSemaphore.release();
    }

    @Override
    public void run() {
        long timeToWait = this.mySampleFrequencyMs;
        while (this.myRunning) {
            try {
                long start = System.currentTimeMillis();
                boolean acquired = this.myDataSemaphore.tryAcquire(timeToWait, TimeUnit.MILLISECONDS);
                if (this.myRunning) {
                    this.sample(acquired);
                }
                if ((timeToWait -= System.currentTimeMillis() - start) > 0L) continue;
                timeToWait = this.mySampleFrequencyMs;
            }
            catch (InterruptedException e) {
                this.myRunning = false;
            }
        }
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getDescription();

    protected abstract void sample(boolean var1) throws InterruptedException;
}

