/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure;

import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.DispatchRunnable;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.tools.idea.structure.AndroidProjectStructureConfigurable;
import com.android.tools.idea.structure.ProjectConfigurationError;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSdksConfigurable
extends BaseConfigurable {
    private static final String CHOOSE_VALID_JDK_DIRECTORY_ERR = "Please choose a valid JDK directory.";
    private static final String CHOOSE_VALID_SDK_DIRECTORY_ERR = "Please choose a valid Android SDK directory.";
    private static final String CHOOSE_VALID_NDK_DIRECTORY_ERR = "Please choose a valid Android NDK directory.";
    private static final Logger LOG = Logger.getInstance(DefaultSdksConfigurable.class);
    @Nullable
    private final AndroidProjectStructureConfigurable myHost;
    @Nullable
    private final Project myProject;
    private String myOriginalJdkHomePath;
    private String myOriginalNdkHomePath;
    private String myOriginalSdkHomePath;
    private HyperlinkLabel myNdkDownloadHyperlinkLabel;
    private HyperlinkLabel myNdkResetHyperlinkLabel;
    private TextFieldWithBrowseButton mySdkLocationTextField;
    private TextFieldWithBrowseButton myNdkLocationTextField;
    private TextFieldWithBrowseButton myJdkLocationTextField;
    private JPanel myWholePanel;
    private JPanel myNdkDownloadPanel;
    private AsyncProcessIcon myNdkCheckProcessIcon;
    private DetailsComponent myDetailsComponent;

    public DefaultSdksConfigurable(@Nullable AndroidProjectStructureConfigurable host, @Nullable Project project) {
        this.myHost = host;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myWholePanel.setPreferredSize(new Dimension(700, 500));
        this.myDetailsComponent = new DetailsComponent();
        this.myDetailsComponent.setContent((JComponent)this.myWholePanel);
        this.myDetailsComponent.setText(new String[]{"SDK Location"});
        if (this.myProject == null || this.myProject.isDefault()) {
            this.myNdkLocationTextField.setEnabled(false);
        }
        final CardLayout layout = (CardLayout)this.myNdkDownloadPanel.getLayout();
        layout.show(this.myNdkDownloadPanel, "loading");
        final SdkState sdkState = SdkState.getInstance(AndroidSdkUtils.tryToChooseAndroidSdk());
        sdkState.loadAsync(SdkState.DEFAULT_EXPIRATION_PERIOD_MS, false, null, new DispatchRunnable(){

            @Override
            public void doRun() {
                if (!sdkState.getPackages().getRemotePkgInfos().get((Object)PkgType.PKG_NDK).isEmpty()) {
                    layout.show(DefaultSdksConfigurable.this.myNdkDownloadPanel, "link");
                } else {
                    DefaultSdksConfigurable.this.myNdkDownloadPanel.setVisible(false);
                }
            }
        }, new DispatchRunnable(){

            @Override
            public void doRun() {
                DefaultSdksConfigurable.this.myNdkDownloadPanel.setVisible(false);
            }
        }, false);
    }

    public void disposeUIResources() {
    }

    public void reset() {
        this.myOriginalSdkHomePath = DefaultSdksConfigurable.getDefaultSdkPath();
        this.myOriginalNdkHomePath = this.getDefaultNdkPath();
        this.myOriginalJdkHomePath = DefaultSdksConfigurable.getDefaultJdkPath();
        this.mySdkLocationTextField.setText(this.myOriginalSdkHomePath);
        this.myNdkLocationTextField.setText(this.myOriginalNdkHomePath);
        this.myJdkLocationTextField.setText(this.myOriginalJdkHomePath);
    }

    public void apply() throws ConfigurationException {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                IdeSdks.setJdkPath(DefaultSdksConfigurable.this.getJdkLocation());
                IdeSdks.setAndroidSdkPath(DefaultSdksConfigurable.this.getSdkLocation(), DefaultSdksConfigurable.this.myProject);
                DefaultSdksConfigurable.this.saveAndroidNdkPath();
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    RunAndroidSdkManagerAction.updateInWelcomePage(DefaultSdksConfigurable.this.myDetailsComponent.getComponent());
                }
            }
        });
    }

    private void saveAndroidNdkPath() {
        if (this.myProject == null || this.myProject.isDefault()) {
            return;
        }
        try {
            LocalProperties localProperties = new LocalProperties(this.myProject);
            localProperties.setAndroidNdkPath(this.getNdkLocation());
            localProperties.save();
        }
        catch (IOException e) {
            LOG.info(String.format("Unable to update local.properties file in project '%1$s'.", this.myProject.getName()), (Throwable)e);
            String cause = e.getMessage();
            if (Strings.isNullOrEmpty((String)cause)) {
                cause = "[Unknown]";
            }
            String msg = String.format("Unable to update local.properties file in project '%1$s'.\n\nCause: %2$s\n\nPlease manually update the file's '%3$s' property value to \n'%4$s'\nand sync the project with Gradle files.", this.myProject.getName(), cause, "ndk.dir", this.getNdkLocation().getPath());
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Android Ndk Update");
        }
    }

    private void createUIComponents() {
        this.myNdkCheckProcessIcon = new AsyncProcessIcon("NDK check progress");
        this.createSdkLocationTextField();
        this.createJdkLocationTextField();
        this.createNdkLocationTextField();
        this.createNdkDownloadLink();
        this.createNdkResetLink();
    }

    private void createSdkLocationTextField() {
        this.mySdkLocationTextField = this.createTextFieldWithBrowseButton("Choose Android SDK Location", CHOOSE_VALID_SDK_DIRECTORY_ERR, new Function<File, SdkPaths.ValidationResult>(){

            public SdkPaths.ValidationResult fun(File file) {
                return SdkPaths.validateAndroidSdk(file, false);
            }
        });
    }

    private void createNdkLocationTextField() {
        this.myNdkLocationTextField = this.createTextFieldWithBrowseButton("Choose Android NDK Location", CHOOSE_VALID_NDK_DIRECTORY_ERR, new Function<File, SdkPaths.ValidationResult>(){

            public SdkPaths.ValidationResult fun(File file) {
                return SdkPaths.validateAndroidNdk(file, false);
            }
        });
    }

    private TextFieldWithBrowseButton createTextFieldWithBrowseButton(String title, final String errorMessagae, final Function<File, SdkPaths.ValidationResult> validation) {
        final FileChooserDescriptor descriptor = DefaultSdksConfigurable.createSingleFolderDescriptor(title, new Function<File, Void>(){

            public Void fun(File file) {
                SdkPaths.ValidationResult validationResult = (SdkPaths.ValidationResult)validation.fun((Object)file);
                if (!validationResult.success) {
                    String msg = validationResult.message;
                    if (StringUtil.isEmpty((String)msg)) {
                        msg = errorMessagae;
                    }
                    throw new IllegalArgumentException(msg);
                }
                return null;
            }
        });
        final JTextField textField = new JTextField(10);
        this.installValidationListener(textField);
        return new TextFieldWithBrowseButton(textField, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile chosen;
                VirtualFile suggestedDir = null;
                File ndkLocation = DefaultSdksConfigurable.this.getNdkLocation();
                if (ndkLocation.isDirectory()) {
                    suggestedDir = VfsUtil.findFileByIoFile((File)ndkLocation, (boolean)false);
                }
                if ((chosen = FileChooser.chooseFile((FileChooserDescriptor)descriptor, null, (VirtualFile)suggestedDir)) != null) {
                    File f = VfsUtilCore.virtualToIoFile((VirtualFile)chosen);
                    textField.setText(f.getPath());
                }
            }
        });
    }

    private void createNdkResetLink() {
        this.myNdkResetHyperlinkLabel = new HyperlinkLabel();
        this.myNdkResetHyperlinkLabel.setHyperlinkText("", "Select", " default NDK");
        this.myNdkResetHyperlinkLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                DefaultSdksConfigurable.this.myNdkLocationTextField.setText(IdeSdks.getAndroidNdkPath().getPath());
            }
        });
    }

    private void createNdkDownloadLink() {
        this.myNdkDownloadHyperlinkLabel = new HyperlinkLabel();
        this.myNdkDownloadHyperlinkLabel.setHyperlinkText("", "Download", " Android NDK.");
        this.myNdkDownloadHyperlinkLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                ImmutableList requested = ImmutableList.of((Object)PkgDesc.Builder.newNdk((FullRevision)FullRevision.NOT_SPECIFIED).create());
                SdkQuickfixWizard wizard = new SdkQuickfixWizard(null, null, (List<IPkgDesc>)requested);
                wizard.init();
                if (wizard.showAndGet()) {
                    File ndk = IdeSdks.getAndroidNdkPath();
                    if (ndk != null) {
                        DefaultSdksConfigurable.this.myNdkLocationTextField.setText(ndk.getPath());
                    }
                    DefaultSdksConfigurable.this.validateState();
                }
            }
        });
    }

    private void createJdkLocationTextField() {
        JTextField textField = new JTextField(10);
        this.myJdkLocationTextField = new TextFieldWithBrowseButton(textField, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultSdksConfigurable.this.chooseJdkLocation();
            }
        });
        this.installValidationListener(textField);
    }

    public void chooseJdkLocation() {
        VirtualFile chosen;
        this.myJdkLocationTextField.getTextField().requestFocus();
        VirtualFile suggestedDir = null;
        File jdkLocation = this.getJdkLocation();
        if (jdkLocation.isDirectory()) {
            suggestedDir = VfsUtil.findFileByIoFile((File)jdkLocation, (boolean)false);
        }
        if ((chosen = FileChooser.chooseFile((FileChooserDescriptor)DefaultSdksConfigurable.createSingleFolderDescriptor("Choose JDK Location", new Function<File, Void>(){

            public Void fun(File file) {
                if (!DefaultSdksConfigurable.this.validateAndUpdateJdkPath(file)) {
                    throw new IllegalArgumentException(DefaultSdksConfigurable.CHOOSE_VALID_JDK_DIRECTORY_ERR);
                }
                return null;
            }
        }), null, (VirtualFile)suggestedDir)) != null) {
            File f = VfsUtilCore.virtualToIoFile((VirtualFile)chosen);
            this.myJdkLocationTextField.setText(f.getPath());
        }
    }

    private void installValidationListener(@NotNull JTextField textField) {
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/android/tools/idea/structure/DefaultSdksConfigurable", "installValidationListener"));
        }
        if (this.myHost != null) {
            textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    DefaultSdksConfigurable.this.myHost.requestValidation();
                }
            });
        }
    }

    @NotNull
    private static FileChooserDescriptor createSingleFolderDescriptor(@NotNull String title, final @NotNull Function<File, Void> validation) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/structure/DefaultSdksConfigurable", "createSingleFolderDescriptor"));
        }
        if (validation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validation", "com/android/tools/idea/structure/DefaultSdksConfigurable", "createSingleFolderDescriptor"));
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                for (VirtualFile virtualFile : files) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    validation.fun((Object)file);
                }
            }
        };
        if (SystemInfo.isMac) {
            descriptor.withShowHiddenFiles(true);
        }
        descriptor.setTitle(title);
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "createSingleFolderDescriptor"));
        }
        return fileChooserDescriptor;
    }

    public String getDisplayName() {
        return "SDK Location";
    }

    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myDetailsComponent.getComponent();
    }

    @NotNull
    public JComponent getContentPanel() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "getContentPanel"));
        }
        return jPanel;
    }

    public boolean isModified() {
        return !this.myOriginalSdkHomePath.equals(this.getSdkLocation().getPath()) || !this.myOriginalNdkHomePath.equals(this.getNdkLocation().getPath()) || !this.myOriginalJdkHomePath.equals(this.getJdkLocation().getPath());
    }

    @Nullable
    private static Sdk getFirstDefaultAndroidSdk(boolean create) {
        List<Sdk> allAndroidSdks = IdeSdks.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        if (!create) {
            return null;
        }
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData == null) {
            return null;
        }
        List<Sdk> sdks = IdeSdks.createAndroidSdkPerAndroidTarget(sdkData.getLocation());
        return !sdks.isEmpty() ? sdks.get(0) : null;
    }

    @NotNull
    private static String getDefaultSdkPath() {
        String sdkHome;
        File path = IdeSdks.getAndroidSdkPath();
        if (path != null) {
            String string = path.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "getDefaultSdkPath"));
            }
            return string;
        }
        Sdk sdk = DefaultSdksConfigurable.getFirstDefaultAndroidSdk(true);
        if (sdk != null && (sdkHome = sdk.getHomePath()) != null) {
            String string = FileUtilRt.toSystemDependentName((String)sdkHome);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "getDefaultSdkPath"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "getDefaultSdkPath"));
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private String getDefaultNdkPath() {
        if (this.myProject != null && !this.myProject.isDefault()) {
            String string;
            try {
                File androidNdkPath = new LocalProperties(this.myProject).getAndroidNdkPath();
                if (androidNdkPath == null) return "";
                string = androidNdkPath.getPath();
            }
            catch (IOException e) {
                LOG.info(String.format("Unable to read local.properties file in project '%1$s'.", this.myProject.getName()), (Throwable)e);
                return "";
            }
            if (string != null) return string;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "getDefaultNdkPath"));
        }
        File path = IdeSdks.getAndroidNdkPath();
        if (path == null) return "";
        String string = path.getPath();
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "getDefaultNdkPath"));
    }

    @NotNull
    private static String getDefaultJdkPath() {
        File javaHome = IdeSdks.getJdkPath();
        String string = javaHome != null ? javaHome.getPath() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "getDefaultJdkPath"));
        }
        return string;
    }

    @NotNull
    private File getSdkLocation() {
        String sdkLocation = this.mySdkLocationTextField.getText();
        File file = new File(FileUtilRt.toSystemDependentName((String)sdkLocation));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "getSdkLocation"));
        }
        return file;
    }

    @NotNull
    private File getNdkLocation() {
        String ndkLocation = this.myNdkLocationTextField.getText();
        File file = new File(FileUtilRt.toSystemDependentName((String)ndkLocation));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "getNdkLocation"));
        }
        return file;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JTextField jTextField = this.mySdkLocationTextField.getTextField();
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "getPreferredFocusedComponent"));
        }
        return jTextField;
    }

    public boolean validate() throws ConfigurationException {
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            throw new ConfigurationException(msg);
        }
        if (!this.validateAndUpdateJdkPath(this.getJdkLocation())) {
            throw new ConfigurationException(CHOOSE_VALID_JDK_DIRECTORY_ERR);
        }
        msg = this.validateAndroidNdkPath();
        if (msg != null) {
            throw new ConfigurationException(msg);
        }
        return true;
    }

    @NotNull
    public List<ProjectConfigurationError> validateState() {
        ProjectConfigurationError error;
        ArrayList errors = Lists.newArrayList();
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            error = new ProjectConfigurationError(msg, this.mySdkLocationTextField.getTextField());
            errors.add(error);
        }
        if (!this.validateAndUpdateJdkPath(this.getJdkLocation())) {
            error = new ProjectConfigurationError(CHOOSE_VALID_JDK_DIRECTORY_ERR, this.myJdkLocationTextField.getTextField());
            errors.add(error);
        }
        if ((msg = this.validateAndroidNdkPath()) != null) {
            error = new ProjectConfigurationError(msg, this.myNdkLocationTextField.getTextField());
            errors.add(error);
        }
        ArrayList arrayList = errors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "validateState"));
        }
        return arrayList;
    }

    @Nullable
    private String validateAndroidSdkPath() {
        SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(this.getSdkLocation(), false);
        if (!validationResult.success) {
            String msg = validationResult.message;
            if (StringUtil.isEmpty((String)msg)) {
                msg = CHOOSE_VALID_SDK_DIRECTORY_ERR;
            }
            return msg;
        }
        return null;
    }

    @Nullable
    private String validateAndroidNdkPath() {
        this.hideNdkQuickfixLink();
        if (!this.myNdkLocationTextField.getText().isEmpty()) {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidNdk(this.getNdkLocation(), false);
            if (!validationResult.success) {
                this.showNdkQuickfixLink();
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_NDK_DIRECTORY_ERR;
                }
                return msg;
            }
        } else if (this.myNdkLocationTextField.isVisible()) {
            this.showNdkQuickfixLink();
        }
        return null;
    }

    private void showNdkQuickfixLink() {
        if (IdeSdks.getAndroidNdkPath() == null) {
            this.myNdkDownloadPanel.setVisible(true);
        } else {
            this.myNdkResetHyperlinkLabel.setVisible(true);
        }
    }

    private void hideNdkQuickfixLink() {
        this.myNdkResetHyperlinkLabel.setVisible(false);
        this.myNdkDownloadPanel.setVisible(false);
    }

    @NotNull
    private File getJdkLocation() {
        String jdkLocation = this.myJdkLocationTextField.getText();
        File file = new File(FileUtilRt.toSystemDependentName((String)jdkLocation));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/DefaultSdksConfigurable", "getJdkLocation"));
        }
        return file;
    }

    private boolean validateAndUpdateJdkPath(@NotNull File file) {
        File potentialPath;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/structure/DefaultSdksConfigurable", "validateAndUpdateJdkPath"));
        }
        if (JavaSdk.checkForJdk((File)file)) {
            return true;
        }
        if (SystemInfo.isMac && (potentialPath = new File(file, "/Contents/Home")).isDirectory() && JavaSdk.checkForJdk((File)potentialPath)) {
            this.myJdkLocationTextField.setText(potentialPath.getPath());
            return true;
        }
        return false;
    }

    public static boolean isNeeded() {
        String jdkPath = DefaultSdksConfigurable.getDefaultJdkPath();
        String sdkPath = DefaultSdksConfigurable.getDefaultSdkPath();
        boolean validJdk = !jdkPath.isEmpty() && JavaSdk.checkForJdk((File)new File(jdkPath));
        boolean validSdk = !sdkPath.isEmpty() && IdeSdks.isValidAndroidSdkPath(new File(sdkPath));
        return !validJdk || !validSdk;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(14, 4, 4, 4), -1, 10, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html><b>Android SDK location:</b><br> The directory where the Android SDK is located. This location will be used for new projects, and for existing projects that do not have a local.properties file with a sdk.dir property.</html>");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 7, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.mySdkLocationTextField;
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, new Dimension(215, -1), null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html><b>JDK location:</b><br> The directory where the Java Development Kit (JDK) is located.</html>");
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 2, 8, 0, 7, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(3, 0, 1, 2, 0, 3, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myJdkLocationTextField;
        jPanel4.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, new Dimension(215, -1), null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("<html><b>Android NDK location:</b><br> The directory where the Android NDK is located. This location will be saved as ndk.dir property in the local.properties file.</html>");
        jPanel2.add((Component)jLabel3, new GridConstraints(4, 0, 1, 2, 8, 0, 7, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(5, 0, 1, 2, 0, 3, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.myNdkLocationTextField;
        jPanel5.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, new Dimension(215, -1), null, null));
        HyperlinkLabel hyperlinkLabel = this.myNdkResetHyperlinkLabel;
        jPanel5.add((Component)hyperlinkLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myNdkDownloadPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        HyperlinkLabel hyperlinkLabel2 = this.myNdkDownloadHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel2, "link");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, "loading");
        AsyncProcessIcon asyncProcessIcon = this.myNdkCheckProcessIcon;
        jPanel6.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Checking availability...");
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

