/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.grid;

import com.intellij.android.designer.designSurface.layout.GridLayoutOperation;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.grid.RadCaptionColumn;
import com.intellij.android.designer.model.layout.grid.RadGridLayoutComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.IGroupDeleteComponent;
import com.intellij.designer.model.RadComponent;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class RadCaptionGridColumn
extends RadCaptionColumn<RadGridLayoutComponent>
implements IGroupDeleteComponent {
    public RadCaptionGridColumn(EditableArea mainArea, RadGridLayoutComponent container, int index, int offset, int width, boolean empty) {
        super(mainArea, container, index, offset, width, empty);
    }

    public void delete(List<RadComponent> columns) throws Exception {
        ArrayList<RadComponent> deletedComponents = new ArrayList<RadComponent>();
        GridInfo gridInfo = ((RadGridLayoutComponent)this.myContainer).getVirtualGridInfo();
        RadComponent[][] components = ((RadGridLayoutComponent)this.myContainer).getGridComponents(false);
        for (RadComponent column : columns) {
            RadCaptionGridColumn.delete(deletedComponents, gridInfo, components, (RadCaptionGridColumn)column);
        }
        for (int i = 0; i < components.length; ++i) {
            RadComponent[] rowComponents = components[i];
            RadComponent[] newRowComponents = new RadComponent[rowComponents.length - columns.size()];
            components[i] = newRowComponents;
            int index = 0;
            for (int j = 0; j < rowComponents.length; ++j) {
                boolean add = true;
                for (RadComponent column : columns) {
                    if (j != ((RadCaptionGridColumn)column).myIndex) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                newRowComponents[index++] = rowComponents[j];
            }
        }
        GridLayoutOperation.validateLayoutParams(components);
        this.deselect(deletedComponents);
    }

    private static void delete(List<RadComponent> deletedComponents, GridInfo gridInfo, RadComponent[][] components, RadCaptionGridColumn column) throws Exception {
        if (column.myIndex > 0) {
            GridLayoutOperation.shiftColumnSpan(gridInfo, column.myIndex - 1, -1);
        }
        for (RadComponent[] rowComponents : components) {
            RadComponent component = rowComponents[column.myIndex];
            if (component == null) continue;
            Rectangle cellIndex = RadGridLayoutComponent.getCellInfo(component);
            GridInfo.setNull(components, gridInfo.components, cellIndex.y, cellIndex.y + cellIndex.height, cellIndex.x, cellIndex.x + cellIndex.width);
            component.delete();
            deletedComponents.add(component);
        }
    }
}

