/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.annotations.NotNull;

public class StyleableDefinitionImpl
implements StyleableDefinition {
    private final String myName;
    private final List<StyleableDefinition> myParents;
    private final List<AttributeDefinition> myAttributes;
    private final List<StyleableDefinition> myChildren;

    public StyleableDefinitionImpl(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/StyleableDefinitionImpl", "<init>"));
        }
        this.myParents = new ArrayList<StyleableDefinition>();
        this.myAttributes = new ArrayList<AttributeDefinition>();
        this.myChildren = new ArrayList<StyleableDefinition>();
        this.myName = name;
    }

    public void addChild(@NotNull StyleableDefinition child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/android/dom/attrs/StyleableDefinitionImpl", "addChild"));
        }
        this.myChildren.add(child);
    }

    public void addParent(@NotNull StyleableDefinition parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/android/dom/attrs/StyleableDefinitionImpl", "addParent"));
        }
        this.myParents.add(parent);
    }

    @NotNull
    public List<StyleableDefinition> getParents() {
        List<StyleableDefinition> list = this.myParents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/StyleableDefinitionImpl", "getParents"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<StyleableDefinition> getChildren() {
        List<StyleableDefinition> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/StyleableDefinitionImpl", "getChildren"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/StyleableDefinitionImpl", "getName"));
        }
        return string;
    }

    public void addAttribute(@NotNull AttributeDefinition attrDef) {
        if (attrDef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrDef", "org/jetbrains/android/dom/attrs/StyleableDefinitionImpl", "addAttribute"));
        }
        this.myAttributes.add(attrDef);
    }

    @Override
    @NotNull
    public List<AttributeDefinition> getAttributes() {
        List<AttributeDefinition> list = Collections.unmodifiableList(this.myAttributes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/StyleableDefinitionImpl", "getAttributes"));
        }
        return list;
    }
}

