/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.DeclaredPermissionsLookup;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.client.api.JavaParser;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.ast.BinaryOperator;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.inspections.lint.LombokPsiParser;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceTypeInspection
extends BaseJavaLocalInspectionTool {
    private static final int VALID = 1001;
    private static final int INVALID = 1002;
    private static final int UNCERTAIN = 1003;
    private static final Key<Map<String, PsiExpression>> LITERAL_EXPRESSION_CACHE = Key.create((String)"TYPE_DEF_LITERAL_EXPRESSION");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/inspections/ResourceTypeInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/android/inspections/ResourceTypeInspection", "buildVisitor"));
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)holder.getFile());
        if (facet == null) {
            PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){};
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitCallExpression(PsiCallExpression callExpression) {
                ResourceTypeInspection.checkCall(callExpression, holder);
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                PsiExpression r = expression.getRExpression();
                if (r == null) {
                    return;
                }
                PsiExpression l = expression.getLExpression();
                if (!(l instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiElement resolved = ((PsiReferenceExpression)l).resolve();
                if (!(resolved instanceof PsiModifierListOwner)) {
                    return;
                }
                PsiModifierListOwner owner = (PsiModifierListOwner)resolved;
                PsiType type = expression.getType();
                ResourceTypeInspection.checkExpression(r, owner, type, holder);
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                PsiMethod method;
                PsiExpression value = statement.getReturnValue();
                if (value == null) {
                    return;
                }
                PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : LambdaUtil.getFunctionalInterfaceMethod((PsiElement)element);
                if (method == null) {
                    return;
                }
                ResourceTypeInspection.checkExpression(value, (PsiModifierListOwner)method, value.getType(), holder);
            }

            public void visitNameValuePair(PsiNameValuePair pair) {
                PsiAnnotationMemberValue value = pair.getValue();
                if (!(value instanceof PsiExpression)) {
                    return;
                }
                PsiReference ref = pair.getReference();
                if (ref == null) {
                    return;
                }
                PsiMethod method = (PsiMethod)ref.resolve();
                if (method == null) {
                    return;
                }
                ResourceTypeInspection.checkExpression((PsiExpression)value, (PsiModifierListOwner)method, method.getReturnType(), holder);
            }

            public void visitBinaryExpression(PsiBinaryExpression expression) {
                IElementType tokenType = expression.getOperationTokenType();
                if (tokenType != JavaTokenType.EQEQ && tokenType != JavaTokenType.NE) {
                    return;
                }
                PsiExpression l = expression.getLOperand();
                PsiExpression r = expression.getROperand();
                if (r == null) {
                    return;
                }
                this.checkBinary(l, r);
                this.checkBinary(r, l);
            }

            private void checkBinary(PsiExpression l, PsiExpression r) {
                PsiMethod method;
                if (l instanceof PsiReference) {
                    PsiElement resolved = ((PsiReference)l).resolve();
                    if (resolved instanceof PsiModifierListOwner) {
                        ResourceTypeInspection.checkExpression(r, (PsiModifierListOwner)resolved, ResourceTypeInspection.getType((PsiModifierListOwner)resolved), holder);
                    }
                } else if (l instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)l).resolveMethod()) != null) {
                    ResourceTypeInspection.checkExpression(r, (PsiModifierListOwner)method, method.getReturnType(), holder);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void checkExpression(PsiExpression expression, PsiModifierListOwner owner, @Nullable PsiType type, ProblemsHolder holder) {
        Constraints allowed = ResourceTypeInspection.getAllowedValues(owner, type, null);
        if (allowed == null) {
            return;
        }
        PsiElement scope = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression, null);
        if (scope == null) {
            scope = expression;
        }
        if (!ResourceTypeInspection.isAllowed(scope, expression, allowed, expression.getManager(), null)) {
            ResourceTypeInspection.registerProblem(expression, allowed, holder);
        }
    }

    private static void checkCall(@NotNull PsiCallExpression methodCall, @NotNull ProblemsHolder holder) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkCall"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkCall"));
        }
        PsiMethod method = methodCall.resolveMethod();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiExpressionList argumentList = methodCall.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            Constraints values = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)parameter, parameter.getType(), null);
            if (values == null) continue;
            if (i >= arguments.length) break;
            PsiExpression argument = arguments[i];
            if ((argument = PsiUtil.deparenthesizeExpression((PsiExpression)argument)) == null) continue;
            ResourceTypeInspection.checkMagicParameterArgument(parameter, argument, values, holder);
        }
        ResourceTypeInspection.checkMethodAnnotations(methodCall, holder, method);
    }

    private static void checkMethodAnnotations(PsiCallExpression methodCall, ProblemsHolder holder, PsiMethod method) {
        PsiAnnotation[] annotations;
        for (PsiAnnotation annotation : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)method)) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            if (!qualifiedName.startsWith("android.support.annotation.")) {
                PsiElement resolved;
                if (qualifiedName.startsWith("java.lang")) continue;
                PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
                PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
                if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
                PsiClass cls = (PsiClass)resolved;
                for (PsiAnnotation a : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)cls)) {
                    qualifiedName = a.getQualifiedName();
                    if (qualifiedName == null || !qualifiedName.endsWith("android.support.annotation.RequiresPermission")) continue;
                    ResourceTypeInspection.checkPermissionRequirement(methodCall, holder, method, a);
                }
                continue;
            }
            if ("android.support.annotation.RequiresPermission".equals(qualifiedName)) {
                ResourceTypeInspection.checkPermissionRequirement(methodCall, holder, method, annotation);
                continue;
            }
            if ("android.support.annotation.CheckResult".equals(qualifiedName)) {
                ResourceTypeInspection.checkReturnValueUsage(methodCall, holder, method);
                continue;
            }
            if (!qualifiedName.endsWith("Thread")) continue;
            ResourceTypeInspection.checkThreadAnnotation(methodCall, holder, method, qualifiedName);
        }
        PsiClass cls = method.getContainingClass();
        if (cls != null) {
            for (PsiAnnotation annotation : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)cls)) {
                PsiElement resolved;
                String qualifiedName = annotation.getQualifiedName();
                if (qualifiedName != null && qualifiedName.endsWith("Thread")) {
                    ResourceTypeInspection.checkThreadAnnotation(methodCall, holder, method, qualifiedName);
                    continue;
                }
                if (qualifiedName == null || qualifiedName.startsWith("java.lang")) continue;
                PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
                PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
                if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
                cls = (PsiClass)resolved;
                for (PsiAnnotation a : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)cls)) {
                    qualifiedName = a.getQualifiedName();
                    if (qualifiedName == null || !qualifiedName.endsWith("android.support.annotation.RequiresPermission")) continue;
                    ResourceTypeInspection.checkPermissionRequirement(methodCall, holder, method, a);
                }
            }
        }
    }

    private static void checkThreadAnnotation(PsiCallExpression methodCall, ProblemsHolder holder, PsiMethod method, String qualifiedName) {
        String threadContext = ResourceTypeInspection.getThreadContext(methodCall);
        if (threadContext != null && !SupportAnnotationDetector.isCompatibleThread((String)threadContext, (String)qualifiedName)) {
            String message = String.format("Method %1$s must be called from the %2$s thread, currently inferred thread is %3$s", method.getName(), SupportAnnotationDetector.describeThread((String)qualifiedName), SupportAnnotationDetector.describeThread((String)threadContext));
            holder.registerProblem((PsiElement)methodCall, message, new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static String getThreadContext(PsiCallExpression methodCall) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true);
        if (method != null) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)method)) {
                String qualifiedName = annotation.getQualifiedName();
                if (qualifiedName == null || !qualifiedName.startsWith("android.support.annotation.") || !qualifiedName.endsWith("Thread")) continue;
                return qualifiedName;
            }
            PsiClass cls = method.getContainingClass();
            if (cls != null) {
                for (PsiAnnotation annotation : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)cls)) {
                    String qualifiedName = annotation.getQualifiedName();
                    if (qualifiedName == null || !qualifiedName.startsWith("android.support.annotation.") || !qualifiedName.endsWith("Thread")) continue;
                    return qualifiedName;
                }
            }
        }
        return null;
    }

    private static void checkPermissionRequirement(PsiCallExpression methodCall, ProblemsHolder holder, PsiMethod method, PsiAnnotation annotation) {
        PermissionRequirement requirement = PermissionRequirement.create(null, (JavaParser.ResolvedAnnotation)LombokPsiParser.createResolvedAnnotation(annotation));
        if (!requirement.isConditional()) {
            Project project = methodCall.getProject();
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)methodCall);
            assert (facet != null);
            PermissionHolder lookup = DeclaredPermissionsLookup.getPermissionHolder(facet.getModule());
            if (!requirement.isSatisfied(lookup)) {
                if (requirement.isSatisfied(lookup = ResourceTypeInspection.addLocalPermissions(lookup, methodCall))) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                String methodName = containingClass != null ? containingClass.getName() + "." + method.getName() : method.getName();
                String message = SupportAnnotationDetector.getMissingPermissionMessage((PermissionRequirement)requirement, (String)methodName, (PermissionHolder)lookup);
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                ArrayList list = Lists.newArrayList();
                for (String permissionName : requirement.getMissingPermissions(lookup)) {
                    list.add(new AddPermissionFix(facet, permissionName));
                }
                if (!list.isEmpty()) {
                    fixes = list.toArray(new LocalQuickFix[list.size()]);
                }
                holder.registerProblem((PsiElement)methodCall, message, fixes);
            } else if (requirement.isRevocable(lookup) && AndroidModuleInfo.get(facet).getTargetSdkVersion().getFeatureLevel() >= 23) {
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                PsiClass securityException = psiFacade.findClass("java.lang.SecurityException", GlobalSearchScope.allScope((Project)project));
                if (securityException != null && ExceptionUtil.isHandled((PsiClassType)PsiTypesUtil.getClassType((PsiClass)securityException), (PsiElement)methodCall)) {
                    return;
                }
                PsiMethod methodNode = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true);
                if (methodNode != null) {
                    for (PsiMethodCallExpression call : PsiTreeUtil.collectElementsOfType((PsiElement)methodNode, (Class[])new Class[]{PsiMethodCallExpression.class})) {
                        String name = call.getMethodExpression().getReferenceName();
                        if (name == null || !name.endsWith("Permission") || !name.startsWith("check") && !name.startsWith("enforce")) continue;
                        return;
                    }
                    Set revocablePermissions = requirement.getRevocablePermissions(lookup);
                    AddCheckPermissionFix fix = new AddCheckPermissionFix(facet, requirement, methodCall, revocablePermissions);
                    holder.registerProblem((PsiElement)methodCall, SupportAnnotationDetector.getUnhandledPermissionMessage(), new LocalQuickFix[]{fix});
                }
            }
        }
    }

    private static PermissionHolder addLocalPermissions(PermissionHolder lookup, PsiCallExpression call) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class);
        if (method == null) {
            return lookup;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton("android.support.annotation.RequiresPermission"));
        if (annotation == null) {
            return lookup;
        }
        PermissionRequirement requirement = PermissionRequirement.create(null, (JavaParser.ResolvedAnnotation)LombokPsiParser.createResolvedAnnotation(annotation));
        return PermissionHolder.SetPermissionLookup.join((PermissionHolder)lookup, (PermissionRequirement)requirement);
    }

    private static void checkReturnValueUsage(PsiCallExpression methodCall, ProblemsHolder holder, PsiMethod method) {
        if (methodCall.getParent() instanceof PsiExpressionStatement) {
            String suggest;
            PsiLiteral literal;
            Object literalValue;
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"android.support.annotation.CheckResult"});
            if (annotation == null) {
                return;
            }
            String message = String.format("The result '%1$s' is not used", method.getName());
            PsiAnnotationMemberValue value = annotation.findAttributeValue("suggest");
            if (value instanceof PsiLiteral && (literalValue = (literal = (PsiLiteral)value).getValue()) instanceof String && !(suggest = (String)literalValue).isEmpty()) {
                String name = suggest;
                if (name.startsWith("#")) {
                    name = name.substring(1);
                }
                message = String.format("The result of '%1$s' is not used; did you mean to call '%2$s'?", method.getName(), name);
                if (suggest.startsWith("#") && methodCall instanceof PsiMethodCallExpression) {
                    holder.registerProblem((PsiElement)methodCall, message, new LocalQuickFix[]{new ReplaceCallFix((PsiMethodCallExpression)methodCall, suggest)});
                    return;
                }
            }
            holder.registerProblem((PsiElement)methodCall, message, new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static Constraints getAllowedValuesFromTypedef(@NotNull PsiType type, @NotNull PsiAnnotation magic, @NotNull PsiManager manager) {
        boolean canBeOred;
        PsiAnnotationMemberValue[] allowedValues;
        boolean isString;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/inspections/ResourceTypeInspection", "getAllowedValuesFromTypedef"));
        }
        if (magic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "magic", "org/jetbrains/android/inspections/ResourceTypeInspection", "getAllowedValuesFromTypedef"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "getAllowedValuesFromTypedef"));
        }
        boolean isInt = TypeConversionUtil.getTypeRank((PsiType)type) <= 5;
        boolean bl = isString = !isInt && type.equals(PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)manager.getProject())));
        if (isInt || isString) {
            PsiAnnotationMemberValue orValue;
            PsiAnnotationMemberValue intValues = magic.findAttributeValue("value");
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = allowedValues = intValues instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)intValues).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
            canBeOred = isInt ? (orValue = magic.findAttributeValue("flag")) instanceof PsiLiteral && Boolean.TRUE.equals(((PsiLiteral)orValue).getValue()) : false;
        } else {
            return null;
        }
        if (allowedValues.length != 0) {
            return new AllowedValues(allowedValues, canBeOred);
        }
        return null;
    }

    @Nullable
    public static ResourceType getResourceTypeFromAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/android/inspections/ResourceTypeInspection", "getResourceTypeFromAnnotation"));
        }
        String resourceTypeName = Character.toLowerCase(qualifiedName.charAt("android.support.annotation.".length())) + qualifiedName.substring("android.support.annotation.".length() + 1, qualifiedName.length() - "Res".length());
        return ResourceType.getEnum((String)resourceTypeName);
    }

    @Nullable
    public static Constraints getAllowedValues(@NotNull PsiModifierListOwner element, @Nullable PsiType type, @Nullable Set<PsiClass> visited) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/inspections/ResourceTypeInspection", "getAllowedValues"));
        }
        PsiAnnotation[] annotations = ResourceTypeInspection.getAllAnnotations(element);
        PsiManager manager = element.getManager();
        ArrayList resourceTypes = null;
        for (PsiAnnotation annotation : annotations) {
            PsiJavaCodeReferenceElement ref;
            PsiElement resolved;
            Constraints values;
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            if (qualifiedName.startsWith("android.support.annotation.")) {
                if ("android.support.annotation.IntDef".equals(qualifiedName) || "android.support.annotation.StringDef".equals(qualifiedName)) {
                    if (type != null && (values = ResourceTypeInspection.getAllowedValuesFromTypedef(type, annotation, manager)) != null) {
                        return values;
                    }
                } else {
                    ResourceType resourceType;
                    if ("android.support.annotation.IntRange".equals(qualifiedName)) {
                        return new IntRangeConstraint(annotation);
                    }
                    if ("android.support.annotation.FloatRange".equals(qualifiedName)) {
                        return new FloatRangeConstraint(annotation);
                    }
                    if ("android.support.annotation.Size".equals(qualifiedName)) {
                        return new SizeConstraint(annotation);
                    }
                    if ("android.support.annotation.ColorInt".equals(qualifiedName)) {
                        return new ResourceTypeAllowedValues(Collections.<ResourceType>emptyList());
                    }
                    if (qualifiedName.endsWith("Res") && (resourceType = ResourceTypeInspection.getResourceTypeFromAnnotation(qualifiedName)) != null) {
                        if (resourceTypes == null) {
                            resourceTypes = Lists.newArrayList();
                        }
                        resourceTypes.add(resourceType);
                    }
                }
            }
            PsiElement psiElement = resolved = (ref = annotation.getNameReferenceElement()) == null ? null : ref.resolve();
            if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass aClass = (PsiClass)resolved;
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)aClass) || (values = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)aClass, type, (Set<PsiClass>)visited)) == null) continue;
            return values;
        }
        if (resourceTypes != null) {
            return new ResourceTypeAllowedValues(resourceTypes);
        }
        return null;
    }

    public static PsiAnnotation[] getAllAnnotations(final PsiModifierListOwner element) {
        return (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)element, (CachedValueProvider)new CachedValueProvider<PsiAnnotation[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiAnnotation[]> compute() {
                return CachedValueProvider.Result.create((Object)AnnotationUtil.getAllAnnotations((PsiModifierListOwner)element, (boolean)true, null), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    @Nullable
    private static PsiType getType(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/inspections/ResourceTypeInspection", "getType"));
        }
        return element instanceof PsiVariable ? ((PsiVariable)element).getType() : (element instanceof PsiMethod ? ((PsiMethod)element).getReturnType() : null);
    }

    private static void checkMagicParameterArgument(@NotNull PsiParameter parameter, @NotNull PsiExpression argument, @NotNull Constraints allowedValues, @NotNull ProblemsHolder holder) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkMagicParameterArgument"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkMagicParameterArgument"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkMagicParameterArgument"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/inspections/ResourceTypeInspection", "checkMagicParameterArgument"));
        }
        PsiManager manager = PsiManager.getInstance((Project)holder.getProject());
        if (!argument.getTextRange().isEmpty() && !ResourceTypeInspection.isAllowed(parameter.getDeclarationScope(), argument, allowedValues, manager, null)) {
            ResourceTypeInspection.registerProblem(argument, allowedValues, holder);
        }
    }

    private static void registerProblem(@NotNull PsiExpression argument, @NotNull Constraints allowedValues, @NotNull ProblemsHolder holder) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection", "registerProblem"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "registerProblem"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/inspections/ResourceTypeInspection", "registerProblem"));
        }
        if (allowedValues instanceof ResourceTypeAllowedValues) {
            List<ResourceType> types = ((ResourceTypeAllowedValues)allowedValues).types;
            String message = types.isEmpty() ? String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.getText()) : (types.size() == 1 ? "Expected resource of type " + types.get(0) : "Expected resource type to be one of " + Joiner.on((String)", ").join(types));
            holder.registerProblem((PsiElement)argument, message, new LocalQuickFix[0]);
            return;
        }
        if (allowedValues instanceof RangeAllowedValues) {
            String message = ((RangeAllowedValues)allowedValues).describe(argument);
            holder.registerProblem((PsiElement)argument, message, new LocalQuickFix[0]);
            return;
        }
        assert (allowedValues instanceof AllowedValues);
        AllowedValues typedef = (AllowedValues)allowedValues;
        String values = StringUtil.join((Object[])typedef.values, (Function)new Function<PsiAnnotationMemberValue, String>(){

            public String fun(PsiAnnotationMemberValue value) {
                PsiElement resolved;
                if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiVariable) {
                    return PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)resolved), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                }
                return value.getText();
            }
        }, (String)", ");
        String message = typedef.canBeOred ? "Must be one or more of: " + values : "Must be one of: " + values;
        holder.registerProblem((PsiElement)argument, message, new LocalQuickFix[0]);
    }

    private static boolean isAllowed(final @NotNull PsiElement scope, @NotNull PsiExpression argument, @NotNull Constraints allowedValues, final @NotNull PsiManager manager, final @Nullable Set<PsiExpression> visited) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "isAllowed"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection", "isAllowed"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isAllowed"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isAllowed"));
        }
        if (allowedValues instanceof ResourceTypeAllowedValues) {
            return ResourceTypeInspection.isResourceTypeAllowed(scope, argument, (ResourceTypeAllowedValues)allowedValues, manager, visited);
        }
        if (allowedValues instanceof RangeAllowedValues) {
            return ResourceTypeInspection.isInRange(scope, argument, (RangeAllowedValues)allowedValues, manager, visited);
        }
        assert (allowedValues instanceof AllowedValues);
        final AllowedValues a = (AllowedValues)allowedValues;
        if (ResourceTypeInspection.isGoodExpression(argument, a, scope, manager, visited)) {
            return true;
        }
        return ResourceTypeInspection.processValuesFlownTo(argument, scope, manager, new Processor<PsiExpression>(){

            public boolean process(PsiExpression expression) {
                return ResourceTypeInspection.isGoodExpression(expression, a, scope, manager, visited);
            }
        });
    }

    private static boolean isGoodExpression(@NotNull PsiExpression e, @NotNull AllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        Constraints allowedForRef;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/inspections/ResourceTypeInspection", "isGoodExpression"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isGoodExpression"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "isGoodExpression"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isGoodExpression"));
        }
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)e);
        if (expression == null) {
            return true;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            return true;
        }
        if (expression instanceof PsiConditionalExpression) {
            boolean thenAllowed;
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            boolean bl = thenAllowed = thenExpression == null || ResourceTypeInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited);
            if (!thenAllowed) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            return elseExpression == null || ResourceTypeInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited);
        }
        if (ResourceTypeInspection.isOneOf(expression, allowedValues, manager)) {
            return true;
        }
        if (allowedValues.canBeOred) {
            IElementType tokenType;
            PsiExpression zero = ResourceTypeInspection.getLiteralExpression(expression, manager, "0");
            if (ResourceTypeInspection.same((PsiElement)expression, (PsiElement)zero, manager)) {
                return true;
            }
            PsiExpression mOne = ResourceTypeInspection.getLiteralExpression(expression, manager, "-1");
            if (ResourceTypeInspection.same((PsiElement)expression, (PsiElement)mOne, manager)) {
                return true;
            }
            if (expression instanceof PsiPolyadicExpression && (JavaTokenType.OR.equals(tokenType = ((PsiPolyadicExpression)expression).getOperationTokenType()) || JavaTokenType.AND.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType))) {
                for (PsiExpression operand : ((PsiPolyadicExpression)expression).getOperands()) {
                    if (ResourceTypeInspection.isAllowed(scope, operand, allowedValues, manager, (Set<PsiExpression>)visited)) continue;
                    return false;
                }
                return true;
            }
            if (expression instanceof PsiPrefixExpression && JavaTokenType.TILDE.equals(((PsiPrefixExpression)expression).getOperationTokenType())) {
                PsiExpression operand = ((PsiPrefixExpression)expression).getOperand();
                return operand == null || ResourceTypeInspection.isAllowed(scope, operand, allowedValues, manager, (Set<PsiExpression>)visited);
            }
        }
        PsiElement resolved = null;
        if (expression instanceof PsiReference) {
            resolved = ((PsiReference)expression).resolve();
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)resolved, ResourceTypeInspection.getType((PsiModifierListOwner)resolved), null)) != null && allowedForRef.isSubsetOf(allowedValues, manager)) {
            return true;
        }
        return PsiType.NULL.equals((Object)expression.getType());
    }

    private static long getLongValue(@Nullable PsiAnnotationMemberValue value, long defaultValue) {
        Object o;
        PsiPrefixExpression exp;
        PsiExpression operand;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral) {
            Object o2 = ((PsiLiteral)value).getValue();
            if (o2 instanceof Number) {
                return ((Number)o2).longValue();
            }
        } else if (value instanceof PsiPrefixExpression && (operand = (exp = (PsiPrefixExpression)value).getOperand()) instanceof PsiLiteral && (o = ((PsiLiteral)operand).getValue()) instanceof Number) {
            return -((Number)o).longValue();
        }
        return defaultValue;
    }

    private static double getDoubleValue(@Nullable PsiAnnotationMemberValue value, double defaultValue) {
        Object o;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral && (o = ((PsiLiteral)value).getValue()) instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return defaultValue;
    }

    private static boolean getBooleanValue(@Nullable PsiAnnotationMemberValue value, boolean defaultValue) {
        Object o;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral && (o = ((PsiLiteral)value).getValue()) instanceof Boolean) {
            return (Boolean)o;
        }
        return defaultValue;
    }

    private static boolean isResourceTypeAllowed(final @NotNull PsiElement scope, @NotNull PsiExpression argument, final @NotNull ResourceTypeAllowedValues allowedValues, final @NotNull PsiManager manager, final @Nullable Set<PsiExpression> visited) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "isResourceTypeAllowed"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection", "isResourceTypeAllowed"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isResourceTypeAllowed"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isResourceTypeAllowed"));
        }
        int result = ResourceTypeInspection.isValidResourceTypeExpression(argument, allowedValues, scope, manager, visited);
        if (result == 1001) {
            return true;
        }
        if (result == 1002) {
            return false;
        }
        assert (result == 1003);
        final AtomicInteger b = new AtomicInteger();
        ResourceTypeInspection.processValuesFlownTo(argument, scope, manager, new Processor<PsiExpression>(){

            public boolean process(PsiExpression expression) {
                int goodExpression = ResourceTypeInspection.isValidResourceTypeExpression(expression, allowedValues, scope, manager, visited);
                b.set(goodExpression);
                return goodExpression == 1003;
            }
        });
        result = b.get();
        return result != 1002;
    }

    private static int isValidResourceTypeExpression(@NotNull PsiExpression e, @NotNull ResourceTypeAllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        PsiType type;
        Constraints allowedForRef;
        Object value;
        PsiPrefixExpression ppe;
        PsiExpression r;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidResourceTypeExpression"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidResourceTypeExpression"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidResourceTypeExpression"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidResourceTypeExpression"));
        }
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)e);
        if (expression == null) {
            return 1001;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            return 1001;
        }
        if (expression instanceof PsiConditionalExpression) {
            boolean thenAllowed;
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            boolean bl = thenAllowed = thenExpression == null || ResourceTypeInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited);
            if (!thenAllowed) {
                return 1002;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            return elseExpression == null || ResourceTypeInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited) ? 1001 : 1003;
        }
        if (expression instanceof PsiReferenceExpression) {
            String typeName;
            PsiReferenceExpression typeDef;
            PsiReferenceExpression refExpression = (PsiReferenceExpression)expression;
            PsiExpression qualifierExpression = refExpression.getQualifierExpression();
            if (qualifierExpression instanceof PsiReferenceExpression && (r = (typeDef = (PsiReferenceExpression)qualifierExpression).getQualifierExpression()) instanceof PsiReferenceExpression && "R".equals(((PsiReferenceExpression)r).getReferenceName()) && (typeName = typeDef.getReferenceName()) != null) {
                return allowedValues.isTypeAllowed(typeName) ? 1001 : 1002;
            }
        } else if (expression instanceof PsiLiteral) {
            Object value2;
            if (expression instanceof PsiLiteralExpression) {
                PsiElement outerMost;
                PsiElement parent = expression.getParent();
                if (parent instanceof PsiField && (parent = parent.getParent()) instanceof PsiClass && (outerMost = parent.getParent()) instanceof PsiClass && "R".equals(((PsiClass)outerMost).getName())) {
                    PsiClass typeClass = (PsiClass)parent;
                    String typeClassName = typeClass.getName();
                    return allowedValues.isTypeAllowed(typeClassName) ? 1001 : 1002;
                }
                if (allowedValues.types.isEmpty() && PsiType.INT.equals((Object)expression.getType())) {
                    return 1001;
                }
            }
            if ((value2 = ((PsiLiteral)expression).getValue()) instanceof Integer) {
                return (Integer)value2 == 0 ? 1001 : 1002;
            }
        } else if (expression instanceof PsiPrefixExpression && (ppe = (PsiPrefixExpression)expression).getOperationTokenType() == JavaTokenType.MINUS && ppe.getOperand() instanceof PsiLiteral && (value = ((PsiLiteral)ppe.getOperand()).getValue()) instanceof Integer) {
            return (Integer)value == 1 ? 1001 : 1002;
        }
        PsiElement resolved = null;
        if (expression instanceof PsiReference) {
            ResourceType type2;
            PsiField field;
            PsiClass containingClass;
            resolved = ((PsiReference)expression).resolve();
            if (resolved instanceof PsiField && (containingClass = (field = (PsiField)resolved).getContainingClass()) != null && (r = containingClass.getContainingClass()) != null && "R".equals(r.getName()) && (type2 = ResourceType.getEnum((String)containingClass.getName())) != null) {
                for (ResourceType t : allowedValues.types) {
                    if (t != type2) continue;
                    return 1001;
                }
                return 1002;
            }
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)resolved, type = ResourceTypeInspection.getType((PsiModifierListOwner)resolved), null)) instanceof ResourceTypeAllowedValues) {
            return allowedValues.isCompatibleWith((ResourceTypeAllowedValues)allowedForRef) ? 1001 : 1002;
        }
        return 1003;
    }

    private static boolean isInRange(final @NotNull PsiElement scope, @NotNull PsiExpression argument, final @NotNull RangeAllowedValues allowedValues, final @NotNull PsiManager manager, final @Nullable Set<PsiExpression> visited) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "isInRange"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection", "isInRange"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isInRange"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isInRange"));
        }
        int result = ResourceTypeInspection.isValidRangeExpression(argument, allowedValues, scope, manager, visited);
        if (result == 1001) {
            return true;
        }
        if (result == 1002) {
            return false;
        }
        assert (result == 1003);
        final AtomicInteger b = new AtomicInteger();
        ResourceTypeInspection.processValuesFlownTo(argument, scope, manager, new Processor<PsiExpression>(){

            public boolean process(PsiExpression expression) {
                int goodExpression = ResourceTypeInspection.isValidRangeExpression(expression, allowedValues, scope, manager, visited);
                b.set(goodExpression);
                return goodExpression == 1003;
            }
        });
        result = b.get();
        return result != 1002;
    }

    private static int isValidRangeExpression(@NotNull PsiExpression e, @NotNull RangeAllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        PsiType type;
        Constraints allowedForRef;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidRangeExpression"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidRangeExpression"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidRangeExpression"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isValidRangeExpression"));
        }
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)e);
        if (expression == null) {
            return 1001;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            return 1001;
        }
        if (expression instanceof PsiConditionalExpression) {
            boolean thenAllowed;
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            boolean bl = thenAllowed = thenExpression == null || ResourceTypeInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited);
            if (!thenAllowed) {
                return 1002;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            return elseExpression == null || ResourceTypeInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited) ? 1001 : 1003;
        }
        int valid = allowedValues.isValid(expression);
        if (valid != 1003) {
            return valid;
        }
        PsiElement resolved = null;
        if (expression instanceof PsiReference) {
            int fieldValid;
            PsiField field;
            resolved = ((PsiReference)expression).resolve();
            if (resolved instanceof PsiField && (field = (PsiField)resolved).getInitializer() != null && (fieldValid = allowedValues.isValid(field.getInitializer())) != 1003) {
                return fieldValid;
            }
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)resolved, type = ResourceTypeInspection.getType((PsiModifierListOwner)resolved), null)) instanceof RangeAllowedValues) {
            return allowedValues.isCompatibleWith((RangeAllowedValues)allowedForRef);
        }
        return 1003;
    }

    private static PsiExpression getLiteralExpression(@NotNull PsiExpression context, @NotNull PsiManager manager, @NotNull String text) {
        PsiExpression expression;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/ResourceTypeInspection", "getLiteralExpression"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "getLiteralExpression"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/android/inspections/ResourceTypeInspection", "getLiteralExpression"));
        }
        Map cache = (Map)LITERAL_EXPRESSION_CACHE.get((UserDataHolder)manager);
        if (cache == null) {
            cache = ContainerUtil.createConcurrentSoftValueMap();
            cache = (Map)manager.putUserDataIfAbsent(LITERAL_EXPRESSION_CACHE, (Object)cache);
        }
        if ((expression = (PsiExpression)cache.get(text)) == null) {
            expression = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(text, (PsiElement)context);
            cache.put(text, expression);
        }
        return expression;
    }

    private static boolean isOneOf(@NotNull PsiExpression expression, @NotNull AllowedValues allowedValues, @NotNull PsiManager manager) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/android/inspections/ResourceTypeInspection", "isOneOf"));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedValues", "org/jetbrains/android/inspections/ResourceTypeInspection", "isOneOf"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "isOneOf"));
        }
        for (PsiAnnotationMemberValue allowedValue : allowedValues.values) {
            if (!ResourceTypeInspection.same((PsiElement)allowedValue, (PsiElement)expression, manager)) continue;
            return true;
        }
        return false;
    }

    private static boolean same(@Nullable PsiElement e1, @Nullable PsiElement e2, @NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "same"));
        }
        if (e1 instanceof PsiLiteralExpression && e2 instanceof PsiLiteralExpression) {
            return Comparing.equal((Object)((PsiLiteralExpression)e1).getValue(), (Object)((PsiLiteralExpression)e2).getValue());
        }
        if (e1 instanceof PsiPrefixExpression && e2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)e1).getOperationTokenType() == ((PsiPrefixExpression)e2).getOperationTokenType()) {
            return ResourceTypeInspection.same((PsiElement)((PsiPrefixExpression)e1).getOperand(), (PsiElement)((PsiPrefixExpression)e2).getOperand(), manager);
        }
        if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
            e1 = ((PsiReference)e1).resolve();
            e2 = ((PsiReference)e2).resolve();
        }
        return manager.areElementsEquivalent(e2, e1);
    }

    private static boolean processValuesFlownTo(@NotNull PsiExpression argument, @NotNull PsiElement scope, @NotNull PsiManager manager, @NotNull Processor<PsiExpression> processor) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection", "processValuesFlownTo"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/inspections/ResourceTypeInspection", "processValuesFlownTo"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection", "processValuesFlownTo"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/android/inspections/ResourceTypeInspection", "processValuesFlownTo"));
        }
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.dataFlowToThis = true;
        params.scope = new AnalysisScope((SearchScope)new LocalSearchScope(scope), manager.getProject());
        SliceRootNode rootNode = new SliceRootNode(manager.getProject(), new DuplicateMap(), LanguageSlicing.getProvider((PsiElement)argument).createRootUsage((PsiElement)argument, params));
        Collection children = ((AbstractTreeNode)rootNode.getChildren().iterator().next()).getChildren();
        for (AbstractTreeNode child : children) {
            PsiElement element;
            SliceUsage usage = (SliceUsage)child.getValue();
            if (usage == null || !((element = usage.getElement()) instanceof PsiExpression) || processor.process((Object)((PsiExpression)element))) continue;
            return false;
        }
        return !children.isEmpty();
    }

    static class SizeConstraint
    extends RangeAllowedValues {
        final long exact;
        final long min;
        final long max;
        final long multiple;

        public SizeConstraint(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/android/inspections/ResourceTypeInspection$SizeConstraint", "<init>"));
            }
            PsiAnnotationMemberValue exactValue = annotation.findAttributeValue("value");
            PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("min");
            PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("max");
            PsiAnnotationMemberValue multipleValue = annotation.findDeclaredAttributeValue("multiple");
            this.exact = ResourceTypeInspection.getLongValue(exactValue, -1L);
            this.min = ResourceTypeInspection.getLongValue(fromValue, Long.MIN_VALUE);
            this.max = ResourceTypeInspection.getLongValue(toValue, Long.MAX_VALUE);
            this.multiple = ResourceTypeInspection.getLongValue(multipleValue, 1L);
        }

        @Override
        public int isValid(@NotNull PsiExpression argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection$SizeConstraint", "isValid"));
            }
            Number size = this.guessSize(argument);
            if (size == null) {
                return 1003;
            }
            int actual = size.intValue();
            if (this.exact != -1L ? this.exact != (long)actual : (long)actual < this.min || (long)actual > this.max || (long)actual % this.multiple != 0L) {
                return 1002;
            }
            return 1001;
        }

        @Override
        protected Number guessSize(@NotNull PsiExpression argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection$SizeConstraint", "guessSize"));
            }
            if (argument instanceof PsiNewExpression) {
                PsiNewExpression pne = (PsiNewExpression)argument;
                PsiArrayInitializerExpression initializer = pne.getArrayInitializer();
                if (initializer != null) {
                    return initializer.getInitializers().length;
                }
                PsiExpression[] dimensions = pne.getArrayDimensions();
                if (dimensions.length > 0) {
                    PsiExpression dimension = dimensions[0];
                    return super.guessSize(dimension);
                }
            } else if (argument instanceof PsiLiteral) {
                PsiLiteral literal = (PsiLiteral)argument;
                Object o = literal.getValue();
                if (o instanceof String) {
                    return ((String)o).length();
                }
            } else if (argument instanceof PsiBinaryExpression) {
                Object v = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)argument, (boolean)false);
                if (v instanceof String) {
                    return ((String)v).length();
                }
            } else if (argument instanceof PsiReferenceExpression) {
                PsiLocalVariable variable;
                PsiExpression initializer;
                PsiReferenceExpression ref = (PsiReferenceExpression)argument;
                PsiElement resolved = ref.resolve();
                if (resolved instanceof PsiField) {
                    PsiField field = (PsiField)resolved;
                    PsiExpression initializer2 = field.getInitializer();
                    if (initializer2 != null) {
                        return this.guessSize(initializer2);
                    }
                } else if (resolved instanceof PsiLocalVariable && (initializer = (variable = (PsiLocalVariable)resolved).getInitializer()) != null) {
                    return this.guessSize(initializer);
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String describe(@NotNull PsiExpression argument) {
            Number actual;
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection$SizeConstraint", "describe"));
            }
            StringBuilder sb = new StringBuilder(20);
            if (argument.getType() != null && argument.getType().getCanonicalText().equals("java.lang.String")) {
                sb.append("Length");
            } else {
                sb.append("Size");
            }
            sb.append(" must be");
            if (this.exact != -1L) {
                sb.append(" exactly ");
                sb.append(Long.toString(this.exact));
                String string = sb.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$SizeConstraint", "describe"));
                }
                return string;
            }
            boolean continued = true;
            if (this.min != Long.MIN_VALUE && this.max != Long.MAX_VALUE) {
                sb.append(" at least ");
                sb.append(Long.toString(this.min));
                sb.append(" and at most ");
                sb.append(Long.toString(this.max));
            } else if (this.min != Long.MIN_VALUE) {
                sb.append(" at least ");
                sb.append(Long.toString(this.min));
            } else if (this.max != Long.MAX_VALUE) {
                sb.append(" at most ");
                sb.append(Long.toString(this.max));
            } else {
                continued = false;
            }
            if (this.multiple != 1L) {
                if (continued) {
                    sb.append(" and");
                }
                sb.append(" a multiple of ");
                sb.append(Long.toString(this.multiple));
            }
            if ((actual = this.guessSize(argument)) != null) {
                sb.append(" (was ").append(Integer.toString(actual.intValue())).append(')');
            }
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$SizeConstraint", "describe"));
            }
            return string;
        }

        @Override
        public int isCompatibleWith(@NotNull RangeAllowedValues other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/ResourceTypeInspection$SizeConstraint", "isCompatibleWith"));
            }
            if (other instanceof SizeConstraint) {
                SizeConstraint otherRange = (SizeConstraint)other;
                if ((this.exact != -1L || otherRange.exact != -1L) && this.exact != otherRange.exact) {
                    return 1002;
                }
                return otherRange.min > this.max || otherRange.max < this.min ? 1002 : 1001;
            }
            return 1003;
        }
    }

    static class FloatRangeConstraint
    extends RangeAllowedValues {
        final double from;
        final double to;
        final boolean fromInclusive;
        final boolean toInclusive;

        public FloatRangeConstraint(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/android/inspections/ResourceTypeInspection$FloatRangeConstraint", "<init>"));
            }
            PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("from");
            PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("to");
            PsiAnnotationMemberValue fromInclusiveValue = annotation.findDeclaredAttributeValue("fromInclusive");
            PsiAnnotationMemberValue toInclusiveValue = annotation.findDeclaredAttributeValue("toInclusive");
            this.from = ResourceTypeInspection.getDoubleValue(fromValue, Double.NEGATIVE_INFINITY);
            this.to = ResourceTypeInspection.getDoubleValue(toValue, Double.POSITIVE_INFINITY);
            this.fromInclusive = ResourceTypeInspection.getBooleanValue(fromInclusiveValue, true);
            this.toInclusive = ResourceTypeInspection.getBooleanValue(toInclusiveValue, true);
        }

        @Override
        public int isValid(@NotNull PsiExpression argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection$FloatRangeConstraint", "isValid"));
            }
            Number number = this.guessSize(argument);
            if (number != null) {
                double value = number.doubleValue();
                if (!((this.fromInclusive && value >= this.from || !this.fromInclusive && value > this.from) && (this.toInclusive && value <= this.to || !this.toInclusive && value < this.to))) {
                    return 1002;
                }
                return 1001;
            }
            return 1003;
        }

        @Override
        @NotNull
        public String describe(@NotNull PsiExpression argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection$FloatRangeConstraint", "describe"));
            }
            StringBuilder sb = new StringBuilder(20);
            if (this.from != Double.NEGATIVE_INFINITY) {
                if (this.to != Double.POSITIVE_INFINITY) {
                    sb.append("Value must be ");
                    if (this.fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(this.from));
                    sb.append(" and ");
                    if (this.toInclusive) {
                        sb.append('\u2264');
                    } else {
                        sb.append('<');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(this.to));
                } else {
                    sb.append("Value must be ");
                    if (this.fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(this.from));
                }
            } else if (this.to != Double.POSITIVE_INFINITY) {
                sb.append("Value must be ");
                if (this.toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(Double.toString(this.to));
            }
            Number actual = this.guessSize(argument);
            if (actual != null) {
                sb.append(" (was ");
                if (argument instanceof PsiLiteral) {
                    PsiLiteral literal = (PsiLiteral)argument;
                    sb.append(literal.getText());
                } else {
                    sb.append(Double.toString(actual.doubleValue()));
                }
                sb.append(')');
            }
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$FloatRangeConstraint", "describe"));
            }
            return string;
        }

        @Override
        public int isCompatibleWith(@NotNull RangeAllowedValues other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/ResourceTypeInspection$FloatRangeConstraint", "isCompatibleWith"));
            }
            if (other instanceof FloatRangeConstraint) {
                FloatRangeConstraint otherRange = (FloatRangeConstraint)other;
                return otherRange.from > this.to || otherRange.to < this.from ? 1002 : 1001;
            }
            if (other instanceof IntRangeConstraint) {
                IntRangeConstraint otherRange = (IntRangeConstraint)other;
                return (double)otherRange.from > this.to || (double)otherRange.to < this.from ? 1002 : 1001;
            }
            return 1003;
        }
    }

    static class IntRangeConstraint
    extends RangeAllowedValues {
        final long from;
        final long to;

        public IntRangeConstraint(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/android/inspections/ResourceTypeInspection$IntRangeConstraint", "<init>"));
            }
            PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("from");
            PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("to");
            this.from = ResourceTypeInspection.getLongValue(fromValue, Long.MIN_VALUE);
            this.to = ResourceTypeInspection.getLongValue(toValue, Long.MAX_VALUE);
        }

        @Override
        public int isValid(@NotNull PsiExpression argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection$IntRangeConstraint", "isValid"));
            }
            Number literalValue = this.guessSize(argument);
            if (literalValue != null) {
                long value = literalValue.longValue();
                return value >= this.from && value <= this.to ? 1001 : 1002;
            }
            return 1003;
        }

        @Override
        @NotNull
        public String describe(@NotNull PsiExpression argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection$IntRangeConstraint", "describe"));
            }
            StringBuilder sb = new StringBuilder(20);
            if (this.to == Long.MAX_VALUE) {
                sb.append("Value must be \u2265 ");
                sb.append(Long.toString(this.from));
            } else if (this.from == Long.MIN_VALUE) {
                sb.append("Value must be \u2264 ");
                sb.append(Long.toString(this.to));
            } else {
                sb.append("Value must be \u2265 ");
                sb.append(Long.toString(this.from));
                sb.append(" and \u2264 ");
                sb.append(Long.toString(this.to));
            }
            Number actual = this.guessSize(argument);
            if (actual != null) {
                sb.append(" (was ").append(Integer.toString(actual.intValue())).append(')');
            }
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$IntRangeConstraint", "describe"));
            }
            return string;
        }

        @Override
        public int isCompatibleWith(@NotNull RangeAllowedValues other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/ResourceTypeInspection$IntRangeConstraint", "isCompatibleWith"));
            }
            if (other instanceof IntRangeConstraint) {
                IntRangeConstraint otherRange = (IntRangeConstraint)other;
                return otherRange.from > this.to || otherRange.to < this.from ? 1002 : 1001;
            }
            if (other instanceof FloatRangeConstraint) {
                FloatRangeConstraint otherRange = (FloatRangeConstraint)other;
                return otherRange.from > (double)this.to || otherRange.to < (double)this.from ? 1002 : 1001;
            }
            return 1003;
        }
    }

    static class RangeAllowedValues
    extends Constraints {
        RangeAllowedValues() {
        }

        @NotNull
        public String describe(@NotNull PsiExpression argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection$RangeAllowedValues", "describe"));
            }
            assert (false);
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$RangeAllowedValues", "describe"));
            }
            return "";
        }

        public int isValid(@NotNull PsiExpression argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection$RangeAllowedValues", "isValid"));
            }
            return 1003;
        }

        @Nullable
        protected Number guessSize(@NotNull PsiExpression argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/ResourceTypeInspection$RangeAllowedValues", "guessSize"));
            }
            if (argument instanceof PsiLiteral) {
                PsiLiteral literal = (PsiLiteral)argument;
                Object v = literal.getValue();
                if (v instanceof Number) {
                    return (Number)v;
                }
            } else if (argument instanceof PsiBinaryExpression) {
                Object v = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)argument, (boolean)false);
                if (v instanceof Number) {
                    return (Number)v;
                }
            } else if (argument instanceof PsiReferenceExpression) {
                PsiLocalVariable variable;
                PsiExpression initializer;
                PsiReferenceExpression ref = (PsiReferenceExpression)argument;
                PsiElement resolved = ref.resolve();
                if (resolved instanceof PsiField) {
                    PsiField field = (PsiField)resolved;
                    PsiExpression initializer2 = field.getInitializer();
                    if (initializer2 != null) {
                        return this.guessSize(initializer2);
                    }
                } else if (resolved instanceof PsiLocalVariable && (initializer = (variable = (PsiLocalVariable)resolved).getInitializer()) != null) {
                    return this.guessSize(initializer);
                }
            }
            return null;
        }

        public int isCompatibleWith(@NotNull RangeAllowedValues other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/ResourceTypeInspection$RangeAllowedValues", "isCompatibleWith"));
            }
            return 1003;
        }
    }

    static class ResourceTypeAllowedValues
    extends Constraints {
        @NotNull
        final List<ResourceType> types;

        public ResourceTypeAllowedValues(@NotNull List<ResourceType> types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/android/inspections/ResourceTypeInspection$ResourceTypeAllowedValues", "<init>"));
            }
            this.types = types;
        }

        public boolean isTypeAllowed(@NotNull String typeName) {
            if (typeName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "org/jetbrains/android/inspections/ResourceTypeInspection$ResourceTypeAllowedValues", "isTypeAllowed"));
            }
            for (ResourceType type : this.types) {
                if (!type.getName().equals(typeName) && (type != ResourceType.DRAWABLE || !ResourceType.COLOR.getName().equals(typeName) && !ResourceType.MIPMAP.getName().equals(typeName))) continue;
                return true;
            }
            return false;
        }

        public boolean isCompatibleWith(@NotNull ResourceTypeAllowedValues other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/ResourceTypeInspection$ResourceTypeAllowedValues", "isCompatibleWith"));
            }
            if (other.types.isEmpty() && this.types.isEmpty()) {
                return true;
            }
            for (ResourceType t1 : other.types) {
                for (ResourceType t2 : this.types) {
                    if (t1 != t2) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class AllowedValues
    extends Constraints {
        final PsiAnnotationMemberValue[] values;
        final boolean canBeOred;

        private AllowedValues(@NotNull PsiAnnotationMemberValue[] values, boolean canBeOred) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/android/inspections/ResourceTypeInspection$AllowedValues", "<init>"));
            }
            this.values = values;
            this.canBeOred = canBeOred;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllowedValues a2 = (AllowedValues)o;
            if (this.canBeOred != a2.canBeOred) {
                return false;
            }
            THashSet v1 = new THashSet(Arrays.asList(this.values));
            THashSet v2 = new THashSet(Arrays.asList(a2.values));
            if (v1.size() != v2.size()) {
                return false;
            }
            block0: for (PsiAnnotationMemberValue value : v1) {
                for (PsiAnnotationMemberValue value2 : v2) {
                    if (!ResourceTypeInspection.same((PsiElement)value, (PsiElement)value2, value.getManager())) continue;
                    v2.remove(value2);
                    continue block0;
                }
            }
            return v2.isEmpty();
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.values);
            result = 31 * result + (this.canBeOred ? 1 : 0);
            return result;
        }

        @Override
        public boolean isSubsetOf(@NotNull Constraints other, @NotNull PsiManager manager) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/ResourceTypeInspection$AllowedValues", "isSubsetOf"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection$AllowedValues", "isSubsetOf"));
            }
            if (!(other instanceof AllowedValues)) {
                return false;
            }
            AllowedValues o = (AllowedValues)other;
            for (PsiAnnotationMemberValue value : this.values) {
                boolean found = false;
                for (PsiAnnotationMemberValue otherValue : o.values) {
                    if (!ResourceTypeInspection.same((PsiElement)value, (PsiElement)otherValue, manager)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }

    static class Constraints {
        Constraints() {
        }

        public boolean isSubsetOf(@NotNull Constraints other, @NotNull PsiManager manager) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/ResourceTypeInspection$Constraints", "isSubsetOf"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/ResourceTypeInspection$Constraints", "isSubsetOf"));
            }
            return false;
        }
    }

    private static class ReplaceCallFix
    implements LocalQuickFix {
        private final PsiMethodCallExpression myMethodCall;
        private final String mySuggest;

        public ReplaceCallFix(PsiMethodCallExpression methodCall, String suggest) {
            this.myMethodCall = methodCall;
            this.mySuggest = suggest;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = String.format("Call %1$s instead", this.getMethodName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$ReplaceCallFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace Calls" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$ReplaceCallFix", "getFamilyName"));
            }
            return "Replace Calls";
        }

        private String getMethodName() {
            assert (this.mySuggest.startsWith("#"));
            int start = 1;
            int parameters = this.mySuggest.indexOf(40, start);
            if (parameters == -1) {
                parameters = this.mySuggest.length();
            }
            return this.mySuggest.substring(start, parameters).trim();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            TextRange range;
            PsiReferenceExpression methodExpression;
            PsiElement referenceNameElement;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/ResourceTypeInspection$ReplaceCallFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/android/inspections/ResourceTypeInspection$ReplaceCallFix", "applyFix"));
            }
            if (!this.myMethodCall.isValid()) {
                return;
            }
            String name = this.getMethodName();
            PsiFile file = this.myMethodCall.getContainingFile();
            if (file == null || !FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
            if (document != null && (referenceNameElement = (methodExpression = this.myMethodCall.getMethodExpression()).getReferenceNameElement()) != null && (range = referenceNameElement.getTextRange()) != null) {
                if (name.startsWith("enforce") && methodExpression.getReferenceName() != null && methodExpression.getReferenceName().startsWith("check")) {
                    PsiExpressionList argumentList = this.myMethodCall.getArgumentList();
                    int offset = argumentList.getTextOffset() + argumentList.getTextLength() - 1;
                    document.insertString(offset, (CharSequence)", \"TODO: message if thrown\"");
                }
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)name);
            }
        }
    }

    private static class AddCheckPermissionFix
    implements LocalQuickFix {
        private final AndroidFacet myFacet;
        private final PermissionRequirement myRequirement;
        private final Set<String> myRevocablePermissions;
        private final PsiCallExpression myCall;

        public AddCheckPermissionFix(AndroidFacet facet, PermissionRequirement requirement, PsiCallExpression call, Set<String> revocablePermissions) {
            this.myFacet = facet;
            this.myRequirement = requirement;
            this.myCall = call;
            this.myRevocablePermissions = revocablePermissions;
        }

        @Nls
        @NotNull
        public String getName() {
            if ("Add Permission Check" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$AddCheckPermissionFix", "getName"));
            }
            return "Add Permission Check";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$AddCheckPermissionFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            BinaryOperator operator;
            HashMap permissionNames;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/ResourceTypeInspection$AddCheckPermissionFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/android/inspections/ResourceTypeInspection$AddCheckPermissionFix", "applyFix"));
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myCall, PsiStatement.class, (boolean)true);
            if (statement == null) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiClass manifest = facade.findClass("android.Manifest.permission", GlobalSearchScope.moduleWithLibrariesScope((Module)this.myFacet.getModule()));
            if (manifest != null) {
                PsiField[] fields = manifest.getFields();
                permissionNames = Maps.newHashMapWithExpectedSize((int)fields.length);
                for (PsiField field : fields) {
                    Object value;
                    PsiExpression initializer = field.getInitializer();
                    if (!(initializer instanceof PsiLiteralExpression) || !((value = ((PsiLiteralExpression)initializer).getValue()) instanceof String)) continue;
                    permissionNames.put((String)value, field);
                }
            } else {
                permissionNames = Collections.emptyMap();
            }
            if ((operator = this.myRequirement.getOperator()) == null || operator == BinaryOperator.LOGICAL_AND) {
                operator = BinaryOperator.LOGICAL_OR;
            } else if (operator == BinaryOperator.LOGICAL_OR) {
                operator = BinaryOperator.LOGICAL_AND;
            }
            PsiElementFactory factory = facade.getElementFactory();
            StringBuilder sb = new StringBuilder(200);
            sb.append("if (");
            boolean first = true;
            for (String permission : this.myRevocablePermissions) {
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                    sb.append(operator.getSymbol());
                    sb.append(' ');
                }
                sb.append("checkSelfPermission(");
                PsiField field = (PsiField)permissionNames.get(permission);
                if (field != null && field.getContainingClass() != null) {
                    sb.append(field.getContainingClass().getQualifiedName()).append('.').append(field.getName());
                } else {
                    sb.append('\"').append(permission).append('\"');
                }
                sb.append(") != android.content.pm.PackageManager.PERMISSION_GRANTED");
            }
            sb.append(") {\n");
            sb.append(" // TODO: Consider calling\n //    public void requestPermissions(@NonNull String[] permissions, int requestCode)\n // here to request the missing permissions, and then overriding\n //   public void onRequestPermissionsResult(int requestCode, String[] permissions,\n //                                          int[] grantResults)\n // to handle the case where the user grants the permission. See the documentation\n // for Activity#requestPermissions for more details.\n");
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myCall, PsiMethod.class, (boolean)true);
            if (method != null && !PsiType.VOID.equals((Object)method.getReturnType())) {
                sb.append("return TODO;\n");
            } else {
                sb.append("return;\n");
            }
            sb.append("}\n");
            String code = sb.toString();
            PsiStatement check = factory.createStatementFromText(code, (PsiElement)this.myCall);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)check);
            parent.addBefore((PsiElement)check, (PsiElement)statement);
            CodeStyleManager.getInstance((Project)project).reformatRange(parent, check.getTextOffset(), statement.getTextOffset() + statement.getTextLength());
        }
    }

    private static class AddPermissionFix
    implements LocalQuickFix {
        private final AndroidFacet myFacet;
        private final String myPermissionName;

        public AddPermissionFix(AndroidFacet facet, String permissionName) {
            this.myFacet = facet;
            this.myPermissionName = permissionName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = String.format("Add Permission %1$s", this.myPermissionName.substring(this.myPermissionName.lastIndexOf(46) + 1));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$AddPermissionFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Add Permissions" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/ResourceTypeInspection$AddPermissionFix", "getFamilyName"));
            }
            return "Add Permissions";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/ResourceTypeInspection$AddPermissionFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/android/inspections/ResourceTypeInspection$AddPermissionFix", "applyFix"));
            }
            VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(this.myFacet);
            if (manifestFile == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)this.myFacet.getModule().getProject(), (VirtualFile[])new VirtualFile[]{manifestFile})) {
                return;
            }
            Manifest manifest = AndroidUtils.loadDomElement(this.myFacet.getModule(), manifestFile, Manifest.class);
            if (manifest == null) {
                return;
            }
            XmlTag manifestTag = manifest.getXmlTag();
            if (manifestTag == null) {
                return;
            }
            XmlTag permissionTag = manifestTag.createChildTag("uses-permission", "", null, false);
            if (permissionTag != null) {
                XmlTag before = null;
                for (XmlTag tag : manifestTag.getSubTags()) {
                    String name;
                    String tagName = tag.getName();
                    if (tagName.equals("application")) {
                        before = tag;
                        break;
                    }
                    if (!tagName.equals("uses-permission") || (name = tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android")) == null || name.compareTo(this.myPermissionName) <= 0) continue;
                    before = tag;
                    break;
                }
                permissionTag = before == null ? manifestTag.addSubTag(permissionTag, false) : (XmlTag)manifestTag.addBefore((PsiElement)permissionTag, before);
                permissionTag.setAttribute("name", "http://schemas.android.com/apk/res/android", this.myPermissionName);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)permissionTag);
                DeclaredPermissionsLookup.getInstance(project).reset();
                FileDocumentManager.getInstance().saveAllDocuments();
                PsiFile containingFile = permissionTag.getContainingFile();
                if (containingFile != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                }
            }
        }
    }
}

