/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.checks.RegistrationDetector;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.CompilationUnit;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import org.jetbrains.android.inspections.lint.IntellijLintUtils;

public class IntellijRegistrationDetector
extends RegistrationDetector
implements Detector.JavaScanner {
    static final Implementation IMPLEMENTATION = new Implementation(IntellijRegistrationDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE));

    @Nullable
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(CompilationUnit.class);
    }

    @Nullable
    public AstVisitor createJavaVisitor(final @NonNull JavaContext context) {
        return new ForwardingAstVisitor(){

            public boolean visitCompilationUnit(CompilationUnit node) {
                IntellijRegistrationDetector.this.check(context);
                return true;
            }
        };
    }

    private void check(final JavaContext context) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile = IntellijLintUtils.getPsiFile((Context)context);
                if (!(psiFile instanceof PsiJavaFile)) {
                    return;
                }
                PsiJavaFile javaFile = (PsiJavaFile)psiFile;
                for (PsiClass clz : javaFile.getClasses()) {
                    IntellijRegistrationDetector.this.check(context, clz);
                }
            }
        });
    }

    private void check(JavaContext context, PsiClass clz) {
        for (PsiClass current = clz.getSuperClass(); current != null; current = current.getSuperClass()) {
            Collection registered;
            String internalName;
            String fqcn;
            if (clz.hasModifierProperty("abstract") || clz instanceof PsiAnonymousClass || (fqcn = current.getQualifiedName()) == null || !"android.app.Activity".equals(fqcn) && !"android.app.Service".equals(fqcn) && !"android.content.ContentProvider".equals(fqcn) || (internalName = IntellijLintUtils.getInternalName(clz)) == null) continue;
            String frameworkClass = ClassContext.getInternalName((String)fqcn);
            Collection collection = registered = this.mManifestRegistrations != null ? this.mManifestRegistrations.get((Object)frameworkClass) : null;
            if (registered != null && registered.contains(internalName)) break;
            IntellijRegistrationDetector.report(context, clz, frameworkClass);
            break;
        }
        for (PsiClass innerClass : clz.getInnerClasses()) {
            this.check(context, innerClass);
        }
    }

    private static void report(JavaContext context, PsiClass clz, String internalName) {
        if (IntellijLintUtils.isSuppressed((PsiElement)clz, clz.getContainingFile(), ISSUE)) {
            return;
        }
        String tag = IntellijRegistrationDetector.classToTag((String)internalName);
        Location location = IntellijLintUtils.getLocation(context.file, (PsiElement)clz);
        String fqcn = clz.getQualifiedName();
        if (fqcn == null) {
            fqcn = clz.getName();
        }
        context.report(ISSUE, location, String.format("The <%1$s> %2$s is not registered in the manifest", tag, fqcn), null);
    }
}

