/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParcelableQuickFix
implements AndroidLintQuickFix {
    private static final String CREATOR = "public static final android.os.Parcelable.Creator<%1$s> CREATOR = new android.os.Parcelable.Creator<%1$s>() {\n  @Override\n  public %1$s createFromParcel(android.os.Parcel in) {\n    return new %1$s(in);\n  }\n\n  @Override\n  public %1$s[] newArray(int size) {\n    return new %1$s[size];\n  }\n};\n";
    private static final String CONSTRUCTOR = "protected %1$s(android.os.Parcel in) {\n}\n";
    private static final String CONSTRUCTOR_WITH_SUPER = "protected %1$s(android.os.Parcel in) {\n  super(in);\n}\n";
    private static final String DESCRIBE_CONTENTS = "@Override\npublic int describeContents() {\n  return 0;\n}\n";
    private static final String WRITE_TO_PARCEL = "@Override\npublic void writeToParcel(android.os.Parcel dest, int flags) {\n}\n";
    private static final String WRITE_TO_PARCEL_WITH_SUPER = "@Override\npublic void writeToParcel(android.os.Parcel dest, int flags) {\n  super.writeToParcel(dest, flags);\n}\n";
    private static final String CLASS_T = "T";
    private static final String CLASS_T_ARRAY = "T[]";
    private final String myName;
    private final Operation myOperation;

    public ParcelableQuickFix(String name, Operation operation) {
        this.myName = name;
        this.myOperation = operation;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/ParcelableQuickFix", "getName"));
        }
        return string;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/ParcelableQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/ParcelableQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "org/jetbrains/android/inspections/lint/ParcelableQuickFix", "isApplicable"));
        }
        PsiClass parcelable = this.getClassOfSupportedElement(startElement);
        if (parcelable == null || ParcelableQuickFix.findParcelableFromImplementsList(parcelable) == null) {
            return false;
        }
        switch (this.myOperation) {
            case IMPLEMENT: {
                return parcelable.findFieldByName("CREATOR", false) == null;
            }
            case REIMPLEMENT: {
                return parcelable.findFieldByName("CREATOR", false) != null;
            }
            case REMOVE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/ParcelableQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/ParcelableQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/ParcelableQuickFix", "apply"));
        }
        PsiClass parcelable = this.getClassOfSupportedElement(startElement);
        if (parcelable == null) {
            return;
        }
        QuickFixWorker worker = new QuickFixWorker(parcelable);
        switch (this.myOperation) {
            case IMPLEMENT: {
                worker.implement();
                break;
            }
            case REMOVE: {
                worker.remove();
                break;
            }
            case REIMPLEMENT: {
                worker.reimplement();
            }
        }
    }

    @Nullable
    private PsiClass getClassOfSupportedElement(@NotNull PsiElement element) {
        PsiJavaCodeReferenceElement reference;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/inspections/lint/ParcelableQuickFix", "getClassOfSupportedElement"));
        }
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiClass) {
            return (PsiClass)element.getParent();
        }
        if (element instanceof PsiClass && this.myOperation != Operation.IMPLEMENT) {
            return (PsiClass)element;
        }
        if (element instanceof PsiJavaCodeReferenceElement && (reference = (PsiJavaCodeReferenceElement)element).getCanonicalText().equals("android.os.Parcelable") && reference.getParent() instanceof PsiReferenceList && reference.getParent().getParent() instanceof PsiClass) {
            return (PsiClass)reference.getParent().getParent();
        }
        return null;
    }

    @Nullable
    private static PsiElement findParcelableFromImplementsList(@NotNull PsiClass parcelable) {
        if (parcelable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parcelable", "org/jetbrains/android/inspections/lint/ParcelableQuickFix", "findParcelableFromImplementsList"));
        }
        PsiReferenceList implementsList = parcelable.getImplementsList();
        if (implementsList != null) {
            for (PsiJavaCodeReferenceElement element : implementsList.getReferenceElements()) {
                if (!"android.os.Parcelable".equals(element.getQualifiedName())) continue;
                return element;
            }
        }
        return null;
    }

    private static class QuickFixWorker {
        private final Project myProject;
        private final JavaPsiFacade myFacade;
        private final PsiElementFactory myFactory;
        private final PsiClass myParcelable;
        private final PsiClassType myParcelableType;
        private final PsiClassType myListType;
        private final PsiClass myList;
        private final PsiClassType myTType;
        private final PsiClassType myTArrayType;
        private final PsiClassType myTListType;
        private final Map<PsiType, FieldPersistence> myPersistenceMap;
        private final Set<String> myIgnoredMethods;

        private QuickFixWorker(@NotNull PsiClass parcelable) {
            if (parcelable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parcelable", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "<init>"));
            }
            this.myProject = parcelable.getProject();
            this.myFacade = JavaPsiFacade.getInstance((Project)this.myProject);
            this.myFactory = this.myFacade.getElementFactory();
            this.myParcelable = parcelable;
            this.myParcelableType = PsiType.getTypeByName((String)"android.os.Parcelable", (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myListType = PsiType.getTypeByName((String)"java.util.List", (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myList = this.myListType.resolve();
            assert (this.myList != null);
            this.myTType = PsiType.getTypeByName((String)ParcelableQuickFix.CLASS_T, (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myTArrayType = PsiType.getTypeByName((String)ParcelableQuickFix.CLASS_T_ARRAY, (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myTListType = this.myFactory.createType(this.myList, (PsiType)this.myTType);
            this.myPersistenceMap = new HashMap();
            this.myIgnoredMethods = new HashSet();
            this.populateIgnoredMethods();
            this.populateFieldPersistenceByType();
        }

        private void implement() {
            this.findOrCreateParcelableFromImplementsList();
            PsiMethod constructor = this.findOrCreateConstructor();
            this.addFieldReadsToConstructor(constructor);
            PsiMethod writeToParcel = this.findOrCreateWriteToParcel();
            this.addFieldWrites(writeToParcel);
            PsiMethod describeContents = this.findOrCreateDescribeContents();
            PsiField creator = this.findOrCreateCreator();
            PsiElement insertionPoint = this.findInsertionPoint();
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)constructor, insertionPoint);
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)writeToParcel, insertionPoint);
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)describeContents, insertionPoint);
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)creator, insertionPoint);
            this.save();
        }

        private void remove() {
            QuickFixWorker.delete((PsiElement)this.findConstructor());
            QuickFixWorker.delete((PsiElement)this.findWriteToParcel());
            QuickFixWorker.delete((PsiElement)this.findDescribeContents());
            QuickFixWorker.delete((PsiElement)this.findCreator());
            QuickFixWorker.delete(ParcelableQuickFix.findParcelableFromImplementsList(this.myParcelable));
            QuickFixWorker.delete(this.findImportOfClass("android.os.Parcel"));
            QuickFixWorker.delete(this.findImportOfClass("android.os.Parcelable"));
            this.save();
        }

        private void reimplement() {
            QuickFixWorker.delete((PsiElement)this.findConstructor());
            QuickFixWorker.delete((PsiElement)this.findWriteToParcel());
            QuickFixWorker.delete((PsiElement)this.findDescribeContents());
            QuickFixWorker.delete((PsiElement)this.findCreator());
            this.implement();
            this.save();
        }

        private void save() {
            Document document = FileDocumentManager.getInstance().getDocument(this.myParcelable.getContainingFile().getVirtualFile());
            if (document != null) {
                PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            }
        }

        @Nullable
        private PsiField findCreator() {
            return this.myParcelable.findFieldByName("CREATOR", false);
        }

        @NotNull
        private PsiField findOrCreateCreator() {
            PsiField field = this.findCreator();
            if (field == null) {
                field = this.myFactory.createFieldFromText(String.format(ParcelableQuickFix.CREATOR, this.myParcelable.getName()), (PsiElement)this.myParcelable);
            }
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)field);
            PsiField psiField = field;
            if (psiField == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "findOrCreateCreator"));
            }
            return psiField;
        }

        @Nullable
        private PsiMethod findConstructor() {
            for (PsiMethod method : this.myParcelable.getConstructors()) {
                if (!QuickFixWorker.isConstructorWithParcelParameter(method)) continue;
                return method;
            }
            return null;
        }

        @NotNull
        private PsiMethod findOrCreateConstructor() {
            PsiMethod method = this.findConstructor();
            if (method == null) {
                String fmt = this.doesSuperClassImplementParcelable() ? ParcelableQuickFix.CONSTRUCTOR_WITH_SUPER : ParcelableQuickFix.CONSTRUCTOR;
                method = this.createMethodWithShortClassReferences(String.format(fmt, this.myParcelable.getName()));
            }
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "findOrCreateConstructor"));
            }
            return psiMethod;
        }

        @Nullable
        private PsiMethod findDescribeContents() {
            for (PsiMethod method : this.myParcelable.getMethods()) {
                PsiParameterList params = method.getParameterList();
                if (!method.getName().equals("describeContents") || params.getParametersCount() != 0) continue;
                return method;
            }
            return null;
        }

        @NotNull
        private PsiMethod findOrCreateDescribeContents() {
            PsiMethod method = this.findDescribeContents();
            if (method == null) {
                method = this.createMethodWithShortClassReferences(ParcelableQuickFix.DESCRIBE_CONTENTS);
            }
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "findOrCreateDescribeContents"));
            }
            return psiMethod;
        }

        @Nullable
        private PsiMethod findWriteToParcel() {
            for (PsiMethod method : this.myParcelable.getMethods()) {
                if (!QuickFixWorker.isWriteToParcelMethod(method)) continue;
                return method;
            }
            return null;
        }

        @NotNull
        private PsiMethod findOrCreateWriteToParcel() {
            PsiMethod method = this.findWriteToParcel();
            if (method == null) {
                String text = this.doesSuperClassImplementParcelable() ? ParcelableQuickFix.WRITE_TO_PARCEL_WITH_SUPER : ParcelableQuickFix.WRITE_TO_PARCEL;
                method = this.createMethodWithShortClassReferences(text);
            }
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "findOrCreateWriteToParcel"));
            }
            return psiMethod;
        }

        private void findOrCreateParcelableFromImplementsList() {
            PsiReferenceList implementsList;
            PsiElement element = ParcelableQuickFix.findParcelableFromImplementsList(this.myParcelable);
            if (element == null && (implementsList = this.myParcelable.getImplementsList()) != null) {
                PsiJavaCodeReferenceElement implementsParcelable = this.myFactory.createReferenceElementByFQClassName("android.os.Parcelable", this.myParcelable.getResolveScope());
                implementsList.add((PsiElement)implementsParcelable);
            }
        }

        @Nullable
        private PsiElement findImportOfClass(@NotNull String className) {
            PsiImportList importList;
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "findImportOfClass"));
            }
            PsiFile file = this.myParcelable.getContainingFile();
            if (file != null && file instanceof PsiJavaFile && (importList = ((PsiJavaFile)file).getImportList()) != null) {
                return importList.findSingleClassImportStatement(className);
            }
            return null;
        }

        private PsiMethod createMethodWithShortClassReferences(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "createMethodWithShortClassReferences"));
            }
            PsiMethod method = this.myFactory.createMethodFromText(text, (PsiElement)this.myParcelable);
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)method);
            return method;
        }

        private static boolean isConstructorWithParcelParameter(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "isConstructorWithParcelParameter"));
            }
            PsiParameterList params = method.getParameterList();
            return method.isConstructor() && params.getParametersCount() == 1 && params.getParameters()[0].getType().equalsToText("android.os.Parcel");
        }

        private static boolean isWriteToParcelMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "isWriteToParcelMethod"));
            }
            PsiParameterList params = method.getParameterList();
            return method.getName().equals("writeToParcel") && params.getParametersCount() == 2 && params.getParameters()[0].getType().equalsToText("android.os.Parcel") && params.getParameters()[1].getType().equalsToText(PsiType.INT.getCanonicalText());
        }

        private boolean doesSuperClassImplementParcelable() {
            PsiClass superClass = this.myParcelable.getSuperClass();
            if (superClass == null) {
                return false;
            }
            return ParcelableQuickFix.findParcelableFromImplementsList(superClass) != null;
        }

        private void addFieldReadsToConstructor(@NotNull PsiMethod constructor) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "addFieldReadsToConstructor"));
            }
            assert (QuickFixWorker.isConstructorWithParcelParameter(constructor));
            if (!this.isEmptyMethod(constructor)) {
                return;
            }
            this.removeInitialBlankLines(constructor);
            String paramName = constructor.getParameterList().getParameters()[0].getName();
            PsiCodeBlock body = constructor.getBody();
            assert (body != null);
            for (PsiField field : this.myParcelable.getFields()) {
                FieldPersistence persistence = this.findFieldPersistence(field);
                if (persistence == null) continue;
                this.createStatements(persistence.formatRead(field, paramName), body, constructor);
            }
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)constructor);
        }

        private void addFieldWrites(@NotNull PsiMethod writeToParcel) {
            if (writeToParcel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writeToParcel", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "addFieldWrites"));
            }
            assert (QuickFixWorker.isWriteToParcelMethod(writeToParcel));
            if (!this.isEmptyMethod(writeToParcel)) {
                return;
            }
            this.removeInitialBlankLines(writeToParcel);
            String parcelName = writeToParcel.getParameterList().getParameters()[0].getName();
            String flagsName = writeToParcel.getParameterList().getParameters()[1].getName();
            PsiCodeBlock body = writeToParcel.getBody();
            assert (body != null);
            for (PsiField field : this.myParcelable.getFields()) {
                FieldPersistence persistence = this.findFieldPersistence(field);
                if (persistence == null) continue;
                this.createStatements(persistence.formatWrite(field, parcelName, flagsName), body, writeToParcel);
            }
        }

        private boolean isEmptyMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "isEmptyMethod"));
            }
            int expectedStatementCount = this.doesSuperClassImplementParcelable() ? 1 : 0;
            return method.getBody() == null || method.getBody().getStatements().length <= expectedStatementCount;
        }

        private void removeInitialBlankLines(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "removeInitialBlankLines"));
            }
            PsiWhiteSpace whiteSpace = (PsiWhiteSpace)PsiTreeUtil.getChildOfType((PsiElement)method.getBody(), PsiWhiteSpace.class);
            if (whiteSpace != null && whiteSpace.getText().startsWith("\n\n")) {
                method.getBody().replace((PsiElement)this.myFactory.createCodeBlock());
            }
        }

        private void createStatements(@NotNull String[] stmtText, @NotNull PsiCodeBlock body, @NotNull PsiMethod method) {
            if (stmtText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stmtText", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "createStatements"));
            }
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "createStatements"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "createStatements"));
            }
            for (String text : stmtText) {
                PsiStatement stmt = this.myFactory.createStatementFromText(text, (PsiElement)method);
                body.add((PsiElement)stmt);
            }
        }

        @Nullable
        private FieldPersistence findFieldPersistence(@NotNull PsiField field) {
            PsiType elemType;
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "findFieldPersistence"));
            }
            if (field.hasModifierProperty("transient") || field.hasModifierProperty("static")) {
                return null;
            }
            PsiType type = field.getType();
            FieldPersistence persistence = this.myPersistenceMap.get(type);
            if (persistence != null) {
                return persistence;
            }
            if (this.myParcelableType.isAssignableFrom(type.getDeepComponentType()) && !this.myParcelableType.equals((Object)type.getDeepComponentType())) {
                PsiArrayType arrayType;
                if (type.equals(type.getDeepComponentType())) {
                    return this.myPersistenceMap.get(this.myTType);
                }
                if (type instanceof PsiArrayType && (arrayType = (PsiArrayType)type).getComponentType().equals(type.getDeepComponentType())) {
                    return this.myPersistenceMap.get(this.myTArrayType);
                }
            }
            if ((elemType = QuickFixWorker.getListElementType(type)) != null && this.myParcelableType.isAssignableFrom(elemType) && !this.myParcelableType.equals((Object)elemType)) {
                return this.myPersistenceMap.get(this.myTListType);
            }
            return null;
        }

        @Nullable
        private PsiElement findInsertionPoint() {
            for (PsiMethod method : this.myParcelable.getMethods()) {
                if (method.isConstructor()) continue;
                return method;
            }
            return null;
        }

        private static void addBefore(@NotNull PsiElement parent, @NotNull PsiElement element, @Nullable PsiElement insertionPoint) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "addBefore"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "addBefore"));
            }
            if (element.getParent() == parent) {
                return;
            }
            parent.addBefore(element, insertionPoint);
        }

        private static void delete(@Nullable PsiElement element) {
            if (element != null) {
                element.delete();
            }
        }

        private void populateIgnoredMethods() {
            this.myIgnoredMethods.add("writeParcelable");
            this.myIgnoredMethods.add("readParcelable");
            this.myIgnoredMethods.add("writeParcelableArray");
            this.myIgnoredMethods.add("readParcelableArray");
            this.myIgnoredMethods.add("readSerializable");
            this.myIgnoredMethods.add("writeSerializable");
            this.myIgnoredMethods.add("readValue");
            this.myIgnoredMethods.add("writeValue");
            this.myIgnoredMethods.add("readArray");
            this.myIgnoredMethods.add("writeArray");
        }

        /*
         * WARNING - void declaration
         */
        private void populateFieldPersistenceByType() {
            PsiClass parcel = this.myFacade.findClass("android.os.Parcel", GlobalSearchScope.allScope((Project)this.myProject));
            if (parcel == null) {
                return;
            }
            HashMap setters = new HashMap();
            HashMap getters = new HashMap();
            for (PsiMethod method : parcel.getMethods()) {
                PsiType type;
                if (this.myIgnoredMethods.contains(method.getName())) continue;
                if (QuickFixWorker.isSimpleWrite(method) || QuickFixWorker.isWriteWithParcelableFlags(method)) {
                    type = method.getParameterList().getParameters()[0].getType();
                    setters.put(type, method);
                    continue;
                }
                if (!QuickFixWorker.isSimpleRead(method)) continue;
                type = method.getReturnType();
                getters.put(type, method);
            }
            for (PsiType type : getters.keySet()) {
                void var9_11;
                SimpleFieldPersistence persistence;
                PsiType setterType = this.getTypicalSetterType(type);
                PsiMethod getter = (PsiMethod)getters.get(type);
                PsiMethod setter = (PsiMethod)setters.get(setterType);
                if (getter == null || setter == null) continue;
                if (QuickFixWorker.isSimpleWrite(setter)) {
                    persistence = new SimpleFieldPersistence(setter.getName(), getter.getName());
                } else {
                    if (!QuickFixWorker.isWriteWithParcelableFlags(setter)) continue;
                    persistence = new SimpleWithFlagsFieldPersistence(setter.getName(), getter.getName());
                }
                this.myPersistenceMap.put(type, (FieldPersistence)var9_11);
                this.myPersistenceMap.put(setterType, (FieldPersistence)var9_11);
            }
            this.myPersistenceMap.put((PsiType)this.myTType, new ParcelableFieldPersistence());
            this.myPersistenceMap.put((PsiType)this.myTArrayType, new EfficientParcelableArrayFieldPersistence());
            this.myPersistenceMap.put((PsiType)this.myTListType, new EfficientParcelableListFieldPersistence());
        }

        @NotNull
        private PsiType getTypicalSetterType(@NotNull PsiType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "getTypicalSetterType"));
            }
            PsiType elemType = QuickFixWorker.getListElementType(type);
            Object object = elemType == null ? type : this.myFactory.createType(this.myList, elemType);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "getTypicalSetterType"));
            }
            return object;
        }

        @Nullable
        private static PsiType getListElementType(@NotNull PsiType type) {
            PsiClassReferenceType refType;
            PsiType[] elemTypes;
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "getListElementType"));
            }
            if (type instanceof PsiClassReferenceType && (elemTypes = (refType = (PsiClassReferenceType)type).getParameters()).length == 1 && (type.getCanonicalText().startsWith("java.util.List") || type.getCanonicalText().startsWith("java.util.ArrayList"))) {
                return elemTypes[0];
            }
            return null;
        }

        private static boolean isSimpleWrite(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "isSimpleWrite"));
            }
            return method.getName().startsWith("write") && method.getParameterList().getParametersCount() == 1;
        }

        private static boolean isWriteWithParcelableFlags(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "isWriteWithParcelableFlags"));
            }
            if (!method.getName().startsWith("write") || method.getParameterList().getParametersCount() != 2) {
                return false;
            }
            PsiParameter param = method.getParameterList().getParameters()[1];
            return param.getType().equals(PsiType.INT) && param.getName().equals("parcelableFlags");
        }

        private static boolean isSimpleRead(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker", "isSimpleRead"));
            }
            return (method.getName().startsWith("read") || method.getName().startsWith("create")) && method.getParameterList().getParametersCount() == 0;
        }

        private static class EfficientParcelableListFieldPersistence
        implements FieldPersistence {
            private EfficientParcelableListFieldPersistence() {
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableListFieldPersistence", "formatWrite"));
                }
                if (parcelVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parcelVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableListFieldPersistence", "formatWrite"));
                }
                if (flagsVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flagsVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableListFieldPersistence", "formatWrite"));
                }
                return new String[]{String.format("%1$s.writeTypedList(%2$s);\n", parcelVariableName, field.getName())};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableListFieldPersistence", "formatRead"));
                }
                if (parcelVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parcelVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableListFieldPersistence", "formatRead"));
                }
                PsiType elemType = QuickFixWorker.getListElementType(field.getType());
                assert (elemType != null);
                return new String[]{String.format("%1$s = %2$s.createTypedArrayList(%3$s.CREATOR);\n", field.getName(), parcelVariableName, elemType.getCanonicalText())};
            }
        }

        private static class EfficientParcelableArrayFieldPersistence
        implements FieldPersistence {
            private EfficientParcelableArrayFieldPersistence() {
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableArrayFieldPersistence", "formatWrite"));
                }
                if (parcelVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parcelVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableArrayFieldPersistence", "formatWrite"));
                }
                if (flagsVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flagsVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableArrayFieldPersistence", "formatWrite"));
                }
                return new String[]{String.format("%1$s.writeTypedArray(%2$s, %3$s);\n", parcelVariableName, field.getName(), flagsVariableName)};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableArrayFieldPersistence", "formatRead"));
                }
                if (parcelVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parcelVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$EfficientParcelableArrayFieldPersistence", "formatRead"));
                }
                String typeName = field.getType().getDeepComponentType().getCanonicalText();
                return new String[]{String.format("%1$s = %2$s.createTypedArray(%3$s.CREATOR);\n", field.getName(), parcelVariableName, typeName)};
            }
        }

        private static class ParcelableFieldPersistence
        implements FieldPersistence {
            private ParcelableFieldPersistence() {
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$ParcelableFieldPersistence", "formatWrite"));
                }
                if (parcelVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parcelVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$ParcelableFieldPersistence", "formatWrite"));
                }
                if (flagsVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flagsVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$ParcelableFieldPersistence", "formatWrite"));
                }
                return new String[]{String.format("%1$s.writeParcelable(%2$s, %3$s);\n", parcelVariableName, field.getName(), flagsVariableName)};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$ParcelableFieldPersistence", "formatRead"));
                }
                if (parcelVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parcelVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$ParcelableFieldPersistence", "formatRead"));
                }
                return new String[]{String.format("%1$s = %2$s.readParcelable(%3$s.class.getClassLoader());\n", field.getName(), parcelVariableName, field.getType().getCanonicalText())};
            }
        }

        private static class SimpleWithFlagsFieldPersistence
        extends SimpleFieldPersistence {
            SimpleWithFlagsFieldPersistence(@NotNull String writeMethod, @NotNull String readMethod) {
                if (writeMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writeMethod", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleWithFlagsFieldPersistence", "<init>"));
                }
                if (readMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readMethod", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleWithFlagsFieldPersistence", "<init>"));
                }
                super(writeMethod, readMethod);
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleWithFlagsFieldPersistence", "formatWrite"));
                }
                if (parcelVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parcelVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleWithFlagsFieldPersistence", "formatWrite"));
                }
                if (flagsVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flagsVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleWithFlagsFieldPersistence", "formatWrite"));
                }
                return new String[]{String.format("%1$s.%2$s(%3$s, %4$s);\n", parcelVariableName, this.myWriteMethodName, field.getName(), flagsVariableName)};
            }
        }

        private static class SimpleFieldPersistence
        implements FieldPersistence {
            protected String myWriteMethodName;
            protected String myReadMethodName;

            SimpleFieldPersistence(@NotNull String writeMethod, @NotNull String readMethod) {
                if (writeMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writeMethod", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleFieldPersistence", "<init>"));
                }
                if (readMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readMethod", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleFieldPersistence", "<init>"));
                }
                this.myWriteMethodName = writeMethod;
                this.myReadMethodName = readMethod;
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleFieldPersistence", "formatWrite"));
                }
                if (parcelVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parcelVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleFieldPersistence", "formatWrite"));
                }
                if (flagsVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flagsVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleFieldPersistence", "formatWrite"));
                }
                return new String[]{String.format("%1$s.%2$s(%3$s);\n", parcelVariableName, this.myWriteMethodName, field.getName())};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field, @NotNull String parcelVariableName) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleFieldPersistence", "formatRead"));
                }
                if (parcelVariableName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parcelVariableName", "org/jetbrains/android/inspections/lint/ParcelableQuickFix$QuickFixWorker$SimpleFieldPersistence", "formatRead"));
                }
                return new String[]{String.format("%1$s = %2$s.%3$s();\n", field.getName(), parcelVariableName, this.myReadMethodName)};
            }
        }

        private static interface FieldPersistence {
            public String[] formatWrite(@NotNull PsiField var1, @NotNull String var2, @NotNull String var3);

            public String[] formatRead(@NotNull PsiField var1, @NotNull String var2);
        }
    }

    public static enum Operation {
        IMPLEMENT,
        REMOVE,
        REIMPLEMENT;

    }
}

