/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

class RemoveAttributeQuickFix
implements AndroidLintQuickFix {
    RemoveAttributeQuickFix() {
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/RemoveAttributeQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/RemoveAttributeQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/RemoveAttributeQuickFix", "apply"));
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class);
        if (attribute != null) {
            attribute.getParent().setAttribute(attribute.getName(), null);
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/RemoveAttributeQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/RemoveAttributeQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "org/jetbrains/android/inspections/lint/RemoveAttributeQuickFix", "isApplicable"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class) != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = AndroidBundle.message("android.lint.fix.remove.attribute", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/RemoveAttributeQuickFix", "getName"));
        }
        return string;
    }
}

