/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.List;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

class TypographyQuickFix
implements AndroidLintQuickFix {
    private final Issue myIssue;
    private final String myMessage;

    public TypographyQuickFix(@NotNull Issue issue, @NotNull String message) {
        if (issue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issue", "org/jetbrains/android/inspections/lint/TypographyQuickFix", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/android/inspections/lint/TypographyQuickFix", "<init>"));
        }
        this.myIssue = issue;
        this.myMessage = message;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/TypographyQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/TypographyQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/TypographyQuickFix", "apply"));
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return;
        }
        for (PsiElement child : tag.getChildren()) {
            XmlText xmlText;
            String value;
            if (!(child instanceof XmlText) || (value = (xmlText = (XmlText)child).getValue()) == null) continue;
            List edits = TypographyDetector.getEdits((String)this.myIssue.getId(), (String)this.myMessage, (String)value);
            StringBuilder builder = new StringBuilder(value);
            for (TypographyDetector.ReplaceEdit edit : edits) {
                String with = edit.replaceWith;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    with = with.replace('\u2013', '~').replace('\u2018', '{').replace('\u2019', '}');
                }
                builder.replace(edit.offset, edit.offset + edit.length, with);
            }
            String newValue = builder.toString();
            if (newValue.equals(value)) continue;
            xmlText.setValue(newValue);
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/TypographyQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/TypographyQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "org/jetbrains/android/inspections/lint/TypographyQuickFix", "isApplicable"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = AndroidBundle.message("android.lint.fix.replace.with.suggested.characters", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/TypographyQuickFix", "getName"));
        }
        return string;
    }
}

